// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/firestore/v1/firestore.proto

package firestorepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Firestore_GetDocument_FullMethodName         = "/google.firestore.v1.Firestore/GetDocument"
	Firestore_ListDocuments_FullMethodName       = "/google.firestore.v1.Firestore/ListDocuments"
	Firestore_UpdateDocument_FullMethodName      = "/google.firestore.v1.Firestore/UpdateDocument"
	Firestore_DeleteDocument_FullMethodName      = "/google.firestore.v1.Firestore/DeleteDocument"
	Firestore_BatchGetDocuments_FullMethodName   = "/google.firestore.v1.Firestore/BatchGetDocuments"
	Firestore_BeginTransaction_FullMethodName    = "/google.firestore.v1.Firestore/BeginTransaction"
	Firestore_Commit_FullMethodName              = "/google.firestore.v1.Firestore/Commit"
	Firestore_Rollback_FullMethodName            = "/google.firestore.v1.Firestore/Rollback"
	Firestore_RunQuery_FullMethodName            = "/google.firestore.v1.Firestore/RunQuery"
	Firestore_RunAggregationQuery_FullMethodName = "/google.firestore.v1.Firestore/RunAggregationQuery"
	Firestore_PartitionQuery_FullMethodName      = "/google.firestore.v1.Firestore/PartitionQuery"
	Firestore_Write_FullMethodName               = "/google.firestore.v1.Firestore/Write"
	Firestore_Listen_FullMethodName              = "/google.firestore.v1.Firestore/Listen"
	Firestore_ListCollectionIds_FullMethodName   = "/google.firestore.v1.Firestore/ListCollectionIds"
	Firestore_BatchWrite_FullMethodName          = "/google.firestore.v1.Firestore/BatchWrite"
	Firestore_CreateDocument_FullMethodName      = "/google.firestore.v1.Firestore/CreateDocument"
)

// FirestoreClient is the client API for Firestore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FirestoreClient interface {
	// Gets a single document.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Lists documents.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Updates or inserts a document.
	UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Deletes a document.
	DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets multiple documents.
	//
	// Documents returned by this method are not guaranteed to be returned in the
	// same order that they were requested.
	BatchGetDocuments(ctx context.Context, in *BatchGetDocumentsRequest, opts ...grpc.CallOption) (Firestore_BatchGetDocumentsClient, error)
	// Starts a new transaction.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error)
	// Commits a transaction, while optionally updating documents.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Runs a query.
	RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (Firestore_RunQueryClient, error)
	// Runs an aggregation query.
	//
	// Rather than producing [Document][google.firestore.v1.Document] results like
	// [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery], this API
	// allows running an aggregation to produce a series of
	// [AggregationResult][google.firestore.v1.AggregationResult] server-side.
	//
	// High-Level Example:
	//
	// ```
	// -- Return the number of documents in table given a filter.
	// SELECT COUNT(*) FROM ( SELECT * FROM k where a = true );
	// ```
	RunAggregationQuery(ctx context.Context, in *RunAggregationQueryRequest, opts ...grpc.CallOption) (Firestore_RunAggregationQueryClient, error)
	// Partitions a query by returning partition cursors that can be used to run
	// the query in parallel. The returned partition cursors are split points that
	// can be used by RunQuery as starting/end points for the query results.
	PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionQueryResponse, error)
	// Streams batches of document updates and deletes, in order. This method is
	// only available via gRPC or WebChannel (not REST).
	Write(ctx context.Context, opts ...grpc.CallOption) (Firestore_WriteClient, error)
	// Listens to changes. This method is only available via gRPC or WebChannel
	// (not REST).
	Listen(ctx context.Context, opts ...grpc.CallOption) (Firestore_ListenClient, error)
	// Lists all the collection IDs underneath a document.
	ListCollectionIds(ctx context.Context, in *ListCollectionIdsRequest, opts ...grpc.CallOption) (*ListCollectionIdsResponse, error)
	// Applies a batch of write operations.
	//
	// The BatchWrite method does not apply the write operations atomically
	// and can apply them out of order. Method does not allow more than one write
	// per document. Each write succeeds or fails independently. See the
	// [BatchWriteResponse][google.firestore.v1.BatchWriteResponse] for the
	// success status of each write.
	//
	// If you require an atomically applied set of writes, use
	// [Commit][google.firestore.v1.Firestore.Commit] instead.
	BatchWrite(ctx context.Context, in *BatchWriteRequest, opts ...grpc.CallOption) (*BatchWriteResponse, error)
	// Creates a new document.
	CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
}

type firestoreClient struct {
	cc grpc.ClientConnInterface
}

func NewFirestoreClient(cc grpc.ClientConnInterface) FirestoreClient {
	return &firestoreClient{cc}
}

func (c *firestoreClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, Firestore_GetDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, Firestore_ListDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, Firestore_UpdateDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Firestore_DeleteDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) BatchGetDocuments(ctx context.Context, in *BatchGetDocumentsRequest, opts ...grpc.CallOption) (Firestore_BatchGetDocumentsClient, error) {
	stream, err := c.cc.NewStream(ctx, &Firestore_ServiceDesc.Streams[0], Firestore_BatchGetDocuments_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreBatchGetDocumentsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Firestore_BatchGetDocumentsClient interface {
	Recv() (*BatchGetDocumentsResponse, error)
	grpc.ClientStream
}

type firestoreBatchGetDocumentsClient struct {
	grpc.ClientStream
}

func (x *firestoreBatchGetDocumentsClient) Recv() (*BatchGetDocumentsResponse, error) {
	m := new(BatchGetDocumentsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error) {
	out := new(BeginTransactionResponse)
	err := c.cc.Invoke(ctx, Firestore_BeginTransaction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, Firestore_Commit_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Firestore_Rollback_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (Firestore_RunQueryClient, error) {
	stream, err := c.cc.NewStream(ctx, &Firestore_ServiceDesc.Streams[1], Firestore_RunQuery_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreRunQueryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Firestore_RunQueryClient interface {
	Recv() (*RunQueryResponse, error)
	grpc.ClientStream
}

type firestoreRunQueryClient struct {
	grpc.ClientStream
}

func (x *firestoreRunQueryClient) Recv() (*RunQueryResponse, error) {
	m := new(RunQueryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) RunAggregationQuery(ctx context.Context, in *RunAggregationQueryRequest, opts ...grpc.CallOption) (Firestore_RunAggregationQueryClient, error) {
	stream, err := c.cc.NewStream(ctx, &Firestore_ServiceDesc.Streams[2], Firestore_RunAggregationQuery_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreRunAggregationQueryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Firestore_RunAggregationQueryClient interface {
	Recv() (*RunAggregationQueryResponse, error)
	grpc.ClientStream
}

type firestoreRunAggregationQueryClient struct {
	grpc.ClientStream
}

func (x *firestoreRunAggregationQueryClient) Recv() (*RunAggregationQueryResponse, error) {
	m := new(RunAggregationQueryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionQueryResponse, error) {
	out := new(PartitionQueryResponse)
	err := c.cc.Invoke(ctx, Firestore_PartitionQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Write(ctx context.Context, opts ...grpc.CallOption) (Firestore_WriteClient, error) {
	stream, err := c.cc.NewStream(ctx, &Firestore_ServiceDesc.Streams[3], Firestore_Write_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreWriteClient{stream}
	return x, nil
}

type Firestore_WriteClient interface {
	Send(*WriteRequest) error
	Recv() (*WriteResponse, error)
	grpc.ClientStream
}

type firestoreWriteClient struct {
	grpc.ClientStream
}

func (x *firestoreWriteClient) Send(m *WriteRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *firestoreWriteClient) Recv() (*WriteResponse, error) {
	m := new(WriteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) Listen(ctx context.Context, opts ...grpc.CallOption) (Firestore_ListenClient, error) {
	stream, err := c.cc.NewStream(ctx, &Firestore_ServiceDesc.Streams[4], Firestore_Listen_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreListenClient{stream}
	return x, nil
}

type Firestore_ListenClient interface {
	Send(*ListenRequest) error
	Recv() (*ListenResponse, error)
	grpc.ClientStream
}

type firestoreListenClient struct {
	grpc.ClientStream
}

func (x *firestoreListenClient) Send(m *ListenRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *firestoreListenClient) Recv() (*ListenResponse, error) {
	m := new(ListenResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) ListCollectionIds(ctx context.Context, in *ListCollectionIdsRequest, opts ...grpc.CallOption) (*ListCollectionIdsResponse, error) {
	out := new(ListCollectionIdsResponse)
	err := c.cc.Invoke(ctx, Firestore_ListCollectionIds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) BatchWrite(ctx context.Context, in *BatchWriteRequest, opts ...grpc.CallOption) (*BatchWriteResponse, error) {
	out := new(BatchWriteResponse)
	err := c.cc.Invoke(ctx, Firestore_BatchWrite_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, Firestore_CreateDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirestoreServer is the server API for Firestore service.
// All implementations should embed UnimplementedFirestoreServer
// for forward compatibility
type FirestoreServer interface {
	// Gets a single document.
	GetDocument(context.Context, *GetDocumentRequest) (*Document, error)
	// Lists documents.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Updates or inserts a document.
	UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error)
	// Deletes a document.
	DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error)
	// Gets multiple documents.
	//
	// Documents returned by this method are not guaranteed to be returned in the
	// same order that they were requested.
	BatchGetDocuments(*BatchGetDocumentsRequest, Firestore_BatchGetDocumentsServer) error
	// Starts a new transaction.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error)
	// Commits a transaction, while optionally updating documents.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error)
	// Runs a query.
	RunQuery(*RunQueryRequest, Firestore_RunQueryServer) error
	// Runs an aggregation query.
	//
	// Rather than producing [Document][google.firestore.v1.Document] results like
	// [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery], this API
	// allows running an aggregation to produce a series of
	// [AggregationResult][google.firestore.v1.AggregationResult] server-side.
	//
	// High-Level Example:
	//
	// ```
	// -- Return the number of documents in table given a filter.
	// SELECT COUNT(*) FROM ( SELECT * FROM k where a = true );
	// ```
	RunAggregationQuery(*RunAggregationQueryRequest, Firestore_RunAggregationQueryServer) error
	// Partitions a query by returning partition cursors that can be used to run
	// the query in parallel. The returned partition cursors are split points that
	// can be used by RunQuery as starting/end points for the query results.
	PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionQueryResponse, error)
	// Streams batches of document updates and deletes, in order. This method is
	// only available via gRPC or WebChannel (not REST).
	Write(Firestore_WriteServer) error
	// Listens to changes. This method is only available via gRPC or WebChannel
	// (not REST).
	Listen(Firestore_ListenServer) error
	// Lists all the collection IDs underneath a document.
	ListCollectionIds(context.Context, *ListCollectionIdsRequest) (*ListCollectionIdsResponse, error)
	// Applies a batch of write operations.
	//
	// The BatchWrite method does not apply the write operations atomically
	// and can apply them out of order. Method does not allow more than one write
	// per document. Each write succeeds or fails independently. See the
	// [BatchWriteResponse][google.firestore.v1.BatchWriteResponse] for the
	// success status of each write.
	//
	// If you require an atomically applied set of writes, use
	// [Commit][google.firestore.v1.Firestore.Commit] instead.
	BatchWrite(context.Context, *BatchWriteRequest) (*BatchWriteResponse, error)
	// Creates a new document.
	CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error)
}

// UnimplementedFirestoreServer should be embedded to have forward compatible implementations.
type UnimplementedFirestoreServer struct {
}

func (UnimplementedFirestoreServer) GetDocument(context.Context, *GetDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDocument not implemented")
}
func (UnimplementedFirestoreServer) ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDocuments not implemented")
}
func (UnimplementedFirestoreServer) UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDocument not implemented")
}
func (UnimplementedFirestoreServer) DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDocument not implemented")
}
func (UnimplementedFirestoreServer) BatchGetDocuments(*BatchGetDocumentsRequest, Firestore_BatchGetDocumentsServer) error {
	return status.Errorf(codes.Unimplemented, "method BatchGetDocuments not implemented")
}
func (UnimplementedFirestoreServer) BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BeginTransaction not implemented")
}
func (UnimplementedFirestoreServer) Commit(context.Context, *CommitRequest) (*CommitResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Commit not implemented")
}
func (UnimplementedFirestoreServer) Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rollback not implemented")
}
func (UnimplementedFirestoreServer) RunQuery(*RunQueryRequest, Firestore_RunQueryServer) error {
	return status.Errorf(codes.Unimplemented, "method RunQuery not implemented")
}
func (UnimplementedFirestoreServer) RunAggregationQuery(*RunAggregationQueryRequest, Firestore_RunAggregationQueryServer) error {
	return status.Errorf(codes.Unimplemented, "method RunAggregationQuery not implemented")
}
func (UnimplementedFirestoreServer) PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PartitionQuery not implemented")
}
func (UnimplementedFirestoreServer) Write(Firestore_WriteServer) error {
	return status.Errorf(codes.Unimplemented, "method Write not implemented")
}
func (UnimplementedFirestoreServer) Listen(Firestore_ListenServer) error {
	return status.Errorf(codes.Unimplemented, "method Listen not implemented")
}
func (UnimplementedFirestoreServer) ListCollectionIds(context.Context, *ListCollectionIdsRequest) (*ListCollectionIdsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCollectionIds not implemented")
}
func (UnimplementedFirestoreServer) BatchWrite(context.Context, *BatchWriteRequest) (*BatchWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchWrite not implemented")
}
func (UnimplementedFirestoreServer) CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDocument not implemented")
}

// UnsafeFirestoreServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FirestoreServer will
// result in compilation errors.
type UnsafeFirestoreServer interface {
	mustEmbedUnimplementedFirestoreServer()
}

func RegisterFirestoreServer(s grpc.ServiceRegistrar, srv FirestoreServer) {
	s.RegisterService(&Firestore_ServiceDesc, srv)
}

func _Firestore_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_GetDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_ListDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_UpdateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).UpdateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_UpdateDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).UpdateDocument(ctx, req.(*UpdateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_DeleteDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).DeleteDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_DeleteDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).DeleteDocument(ctx, req.(*DeleteDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_BatchGetDocuments_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BatchGetDocumentsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FirestoreServer).BatchGetDocuments(m, &firestoreBatchGetDocumentsServer{stream})
}

type Firestore_BatchGetDocumentsServer interface {
	Send(*BatchGetDocumentsResponse) error
	grpc.ServerStream
}

type firestoreBatchGetDocumentsServer struct {
	grpc.ServerStream
}

func (x *firestoreBatchGetDocumentsServer) Send(m *BatchGetDocumentsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Firestore_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_BeginTransaction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_Commit_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_Rollback_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_RunQuery_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RunQueryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FirestoreServer).RunQuery(m, &firestoreRunQueryServer{stream})
}

type Firestore_RunQueryServer interface {
	Send(*RunQueryResponse) error
	grpc.ServerStream
}

type firestoreRunQueryServer struct {
	grpc.ServerStream
}

func (x *firestoreRunQueryServer) Send(m *RunQueryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Firestore_RunAggregationQuery_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RunAggregationQueryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FirestoreServer).RunAggregationQuery(m, &firestoreRunAggregationQueryServer{stream})
}

type Firestore_RunAggregationQueryServer interface {
	Send(*RunAggregationQueryResponse) error
	grpc.ServerStream
}

type firestoreRunAggregationQueryServer struct {
	grpc.ServerStream
}

func (x *firestoreRunAggregationQueryServer) Send(m *RunAggregationQueryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Firestore_PartitionQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).PartitionQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_PartitionQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).PartitionQuery(ctx, req.(*PartitionQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Write_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FirestoreServer).Write(&firestoreWriteServer{stream})
}

type Firestore_WriteServer interface {
	Send(*WriteResponse) error
	Recv() (*WriteRequest, error)
	grpc.ServerStream
}

type firestoreWriteServer struct {
	grpc.ServerStream
}

func (x *firestoreWriteServer) Send(m *WriteResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *firestoreWriteServer) Recv() (*WriteRequest, error) {
	m := new(WriteRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Firestore_Listen_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FirestoreServer).Listen(&firestoreListenServer{stream})
}

type Firestore_ListenServer interface {
	Send(*ListenResponse) error
	Recv() (*ListenRequest, error)
	grpc.ServerStream
}

type firestoreListenServer struct {
	grpc.ServerStream
}

func (x *firestoreListenServer) Send(m *ListenResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *firestoreListenServer) Recv() (*ListenRequest, error) {
	m := new(ListenRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Firestore_ListCollectionIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCollectionIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).ListCollectionIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_ListCollectionIds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).ListCollectionIds(ctx, req.(*ListCollectionIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_BatchWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).BatchWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_BatchWrite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).BatchWrite(ctx, req.(*BatchWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_CreateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).CreateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firestore_CreateDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).CreateDocument(ctx, req.(*CreateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Firestore_ServiceDesc is the grpc.ServiceDesc for Firestore service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Firestore_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.firestore.v1.Firestore",
	HandlerType: (*FirestoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDocument",
			Handler:    _Firestore_GetDocument_Handler,
		},
		{
			MethodName: "ListDocuments",
			Handler:    _Firestore_ListDocuments_Handler,
		},
		{
			MethodName: "UpdateDocument",
			Handler:    _Firestore_UpdateDocument_Handler,
		},
		{
			MethodName: "DeleteDocument",
			Handler:    _Firestore_DeleteDocument_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Firestore_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Firestore_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Firestore_Rollback_Handler,
		},
		{
			MethodName: "PartitionQuery",
			Handler:    _Firestore_PartitionQuery_Handler,
		},
		{
			MethodName: "ListCollectionIds",
			Handler:    _Firestore_ListCollectionIds_Handler,
		},
		{
			MethodName: "BatchWrite",
			Handler:    _Firestore_BatchWrite_Handler,
		},
		{
			MethodName: "CreateDocument",
			Handler:    _Firestore_CreateDocument_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "BatchGetDocuments",
			Handler:       _Firestore_BatchGetDocuments_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RunQuery",
			Handler:       _Firestore_RunQuery_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RunAggregationQuery",
			Handler:       _Firestore_RunAggregationQuery_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Write",
			Handler:       _Firestore_Write_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Listen",
			Handler:       _Firestore_Listen_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/firestore/v1/firestore.proto",
}
