// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/gaming/v1/game_server_clusters.proto

package gamingpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A view for GameServerCluster objects.
type GameServerClusterView int32

const (
	// The default / unset value.
	// The API will default to the BASIC view.
	GameServerClusterView_GAME_SERVER_CLUSTER_VIEW_UNSPECIFIED GameServerClusterView = 0
	// Include basic information of a GameServerCluster resource and omit
	// `cluster_state`. This is the default value (for ListGameServerClusters,
	// GetGameServerCluster and PreviewCreateGameServerCluster).
	GameServerClusterView_BASIC GameServerClusterView = 1
	// Include everything.
	GameServerClusterView_FULL GameServerClusterView = 2
)

// Enum value maps for GameServerClusterView.
var (
	GameServerClusterView_name = map[int32]string{
		0: "GAME_SERVER_CLUSTER_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
	}
	GameServerClusterView_value = map[string]int32{
		"GAME_SERVER_CLUSTER_VIEW_UNSPECIFIED": 0,
		"BASIC":                                1,
		"FULL":                                 2,
	}
)

func (x GameServerClusterView) Enum() *GameServerClusterView {
	p := new(GameServerClusterView)
	*p = x
	return p
}

func (x GameServerClusterView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GameServerClusterView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_enumTypes[0].Descriptor()
}

func (GameServerClusterView) Type() protoreflect.EnumType {
	return &file_google_cloud_gaming_v1_game_server_clusters_proto_enumTypes[0]
}

func (x GameServerClusterView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GameServerClusterView.Descriptor instead.
func (GameServerClusterView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{0}
}

// The state of the installed versions of Agones/Kubernetes. See also
// https://cloud.google.com/game-servers/docs/versions-and-upgrades.
type KubernetesClusterState_InstallationState int32

const (
	// The default value. This value is used if the state is omitted.
	KubernetesClusterState_INSTALLATION_STATE_UNSPECIFIED KubernetesClusterState_InstallationState = 0
	// The combination of Agones and Kubernetes versions is supported by Google
	// Cloud Game Servers.
	KubernetesClusterState_AGONES_KUBERNETES_VERSION_SUPPORTED KubernetesClusterState_InstallationState = 1
	// The installed version of Agones is not supported by Google Cloud Game
	// Servers.
	KubernetesClusterState_AGONES_VERSION_UNSUPPORTED KubernetesClusterState_InstallationState = 2
	// The installed version of Agones is supported by Google Cloud Game
	// Servers, but the installed version of Kubernetes is not recommended or
	// supported by the version of Agones.
	KubernetesClusterState_AGONES_KUBERNETES_VERSION_UNSUPPORTED KubernetesClusterState_InstallationState = 3
	// The installed version of Agones is not recognized because the Agones
	// controller's image name does not have a version string reported as
	// {major}.{minor}(.{patch}).
	KubernetesClusterState_AGONES_VERSION_UNRECOGNIZED KubernetesClusterState_InstallationState = 4
	// The server version of Kubernetes cluster is not recognized because the
	// API server didn't return parsable version info on path/version.
	KubernetesClusterState_KUBERNETES_VERSION_UNRECOGNIZED KubernetesClusterState_InstallationState = 5
	// Failed to read or verify the version of Agones or Kubernetes. See
	// version_installed_error_message for details.
	KubernetesClusterState_VERSION_VERIFICATION_FAILED KubernetesClusterState_InstallationState = 6
	// Agones is not installed.
	KubernetesClusterState_AGONES_NOT_INSTALLED KubernetesClusterState_InstallationState = 7
)

// Enum value maps for KubernetesClusterState_InstallationState.
var (
	KubernetesClusterState_InstallationState_name = map[int32]string{
		0: "INSTALLATION_STATE_UNSPECIFIED",
		1: "AGONES_KUBERNETES_VERSION_SUPPORTED",
		2: "AGONES_VERSION_UNSUPPORTED",
		3: "AGONES_KUBERNETES_VERSION_UNSUPPORTED",
		4: "AGONES_VERSION_UNRECOGNIZED",
		5: "KUBERNETES_VERSION_UNRECOGNIZED",
		6: "VERSION_VERIFICATION_FAILED",
		7: "AGONES_NOT_INSTALLED",
	}
	KubernetesClusterState_InstallationState_value = map[string]int32{
		"INSTALLATION_STATE_UNSPECIFIED":        0,
		"AGONES_KUBERNETES_VERSION_SUPPORTED":   1,
		"AGONES_VERSION_UNSUPPORTED":            2,
		"AGONES_KUBERNETES_VERSION_UNSUPPORTED": 3,
		"AGONES_VERSION_UNRECOGNIZED":           4,
		"KUBERNETES_VERSION_UNRECOGNIZED":       5,
		"VERSION_VERIFICATION_FAILED":           6,
		"AGONES_NOT_INSTALLED":                  7,
	}
)

func (x KubernetesClusterState_InstallationState) Enum() *KubernetesClusterState_InstallationState {
	p := new(KubernetesClusterState_InstallationState)
	*p = x
	return p
}

func (x KubernetesClusterState_InstallationState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KubernetesClusterState_InstallationState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_enumTypes[1].Descriptor()
}

func (KubernetesClusterState_InstallationState) Type() protoreflect.EnumType {
	return &file_google_cloud_gaming_v1_game_server_clusters_proto_enumTypes[1]
}

func (x KubernetesClusterState_InstallationState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KubernetesClusterState_InstallationState.Descriptor instead.
func (KubernetesClusterState_InstallationState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{15, 0}
}

// Request message for GameServerClustersService.ListGameServerClusters.
type ListGameServerClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name, in the following form:
	// "projects/{project}/locations/{location}/realms/{realm}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return. If unspecified, the server
	// will pick an appropriate default. The server may return fewer items than
	// requested. A caller should only rely on response's
	// [next_page_token][google.cloud.gaming.v1.ListGameServerClustersResponse.next_page_token] to
	// determine if there are more GameServerClusters left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results following syntax at
	// https://cloud.google.com/apis/design/design_patterns#sorting_order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. View for the returned GameServerCluster objects. When `FULL` is
	// specified, the `cluster_state` field is also returned in the
	// GameServerCluster object, which includes the state of the referenced
	// Kubernetes cluster such as versions and provider info. The default/unset
	// value is GAME_SERVER_CLUSTER_VIEW_UNSPECIFIED, same as BASIC, which does
	// not return the `cluster_state` field.
	View GameServerClusterView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.gaming.v1.GameServerClusterView" json:"view,omitempty"`
}

func (x *ListGameServerClustersRequest) Reset() {
	*x = ListGameServerClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGameServerClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGameServerClustersRequest) ProtoMessage() {}

func (x *ListGameServerClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGameServerClustersRequest.ProtoReflect.Descriptor instead.
func (*ListGameServerClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{0}
}

func (x *ListGameServerClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGameServerClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGameServerClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGameServerClustersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListGameServerClustersRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListGameServerClustersRequest) GetView() GameServerClusterView {
	if x != nil {
		return x.View
	}
	return GameServerClusterView_GAME_SERVER_CLUSTER_VIEW_UNSPECIFIED
}

// Response message for GameServerClustersService.ListGameServerClusters.
type ListGameServerClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of game server clusters.
	GameServerClusters []*GameServerCluster `protobuf:"bytes,1,rep,name=game_server_clusters,json=gameServerClusters,proto3" json:"game_server_clusters,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// List of locations that could not be reached.
	Unreachable []string `protobuf:"bytes,4,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListGameServerClustersResponse) Reset() {
	*x = ListGameServerClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGameServerClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGameServerClustersResponse) ProtoMessage() {}

func (x *ListGameServerClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGameServerClustersResponse.ProtoReflect.Descriptor instead.
func (*ListGameServerClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{1}
}

func (x *ListGameServerClustersResponse) GetGameServerClusters() []*GameServerCluster {
	if x != nil {
		return x.GameServerClusters
	}
	return nil
}

func (x *ListGameServerClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListGameServerClustersResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GameServerClustersService.GetGameServerCluster.
type GetGameServerClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the game server cluster to retrieve, in the following form:
	// `projects/{project}/locations/{location}/realms/{realm-id}/gameServerClusters/{cluster}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. View for the returned GameServerCluster objects. When `FULL` is
	// specified, the `cluster_state` field is also returned in the
	// GameServerCluster object, which includes the state of the referenced
	// Kubernetes cluster such as versions and provider info. The default/unset
	// value is GAME_SERVER_CLUSTER_VIEW_UNSPECIFIED, same as BASIC, which does
	// not return the `cluster_state` field.
	View GameServerClusterView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.gaming.v1.GameServerClusterView" json:"view,omitempty"`
}

func (x *GetGameServerClusterRequest) Reset() {
	*x = GetGameServerClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGameServerClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGameServerClusterRequest) ProtoMessage() {}

func (x *GetGameServerClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGameServerClusterRequest.ProtoReflect.Descriptor instead.
func (*GetGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{2}
}

func (x *GetGameServerClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetGameServerClusterRequest) GetView() GameServerClusterView {
	if x != nil {
		return x.View
	}
	return GameServerClusterView_GAME_SERVER_CLUSTER_VIEW_UNSPECIFIED
}

// Request message for GameServerClustersService.CreateGameServerCluster.
type CreateGameServerClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name, in the following form:
	// `projects/{project}/locations/{location}/realms/{realm-id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the game server cluster resource to be created.
	GameServerClusterId string `protobuf:"bytes,2,opt,name=game_server_cluster_id,json=gameServerClusterId,proto3" json:"game_server_cluster_id,omitempty"`
	// Required. The game server cluster resource to be created.
	GameServerCluster *GameServerCluster `protobuf:"bytes,3,opt,name=game_server_cluster,json=gameServerCluster,proto3" json:"game_server_cluster,omitempty"`
}

func (x *CreateGameServerClusterRequest) Reset() {
	*x = CreateGameServerClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGameServerClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGameServerClusterRequest) ProtoMessage() {}

func (x *CreateGameServerClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGameServerClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{3}
}

func (x *CreateGameServerClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGameServerClusterRequest) GetGameServerClusterId() string {
	if x != nil {
		return x.GameServerClusterId
	}
	return ""
}

func (x *CreateGameServerClusterRequest) GetGameServerCluster() *GameServerCluster {
	if x != nil {
		return x.GameServerCluster
	}
	return nil
}

// Request message for GameServerClustersService.PreviewCreateGameServerCluster.
type PreviewCreateGameServerClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name, in the following form:
	// `projects/{project}/locations/{location}/realms/{realm}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the game server cluster resource to be created.
	GameServerClusterId string `protobuf:"bytes,2,opt,name=game_server_cluster_id,json=gameServerClusterId,proto3" json:"game_server_cluster_id,omitempty"`
	// Required. The game server cluster resource to be created.
	GameServerCluster *GameServerCluster `protobuf:"bytes,3,opt,name=game_server_cluster,json=gameServerCluster,proto3" json:"game_server_cluster,omitempty"`
	// Optional. The target timestamp to compute the preview.
	PreviewTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=preview_time,json=previewTime,proto3" json:"preview_time,omitempty"`
	// Optional. This field is deprecated, preview will always return
	// KubernetesClusterState.
	//
	// Deprecated: Do not use.
	View GameServerClusterView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.gaming.v1.GameServerClusterView" json:"view,omitempty"`
}

func (x *PreviewCreateGameServerClusterRequest) Reset() {
	*x = PreviewCreateGameServerClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewCreateGameServerClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewCreateGameServerClusterRequest) ProtoMessage() {}

func (x *PreviewCreateGameServerClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewCreateGameServerClusterRequest.ProtoReflect.Descriptor instead.
func (*PreviewCreateGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{4}
}

func (x *PreviewCreateGameServerClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *PreviewCreateGameServerClusterRequest) GetGameServerClusterId() string {
	if x != nil {
		return x.GameServerClusterId
	}
	return ""
}

func (x *PreviewCreateGameServerClusterRequest) GetGameServerCluster() *GameServerCluster {
	if x != nil {
		return x.GameServerCluster
	}
	return nil
}

func (x *PreviewCreateGameServerClusterRequest) GetPreviewTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PreviewTime
	}
	return nil
}

// Deprecated: Do not use.
func (x *PreviewCreateGameServerClusterRequest) GetView() GameServerClusterView {
	if x != nil {
		return x.View
	}
	return GameServerClusterView_GAME_SERVER_CLUSTER_VIEW_UNSPECIFIED
}

// Response message for
// GameServerClustersService.PreviewCreateGameServerCluster.
type PreviewCreateGameServerClusterResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ETag of the game server cluster.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The target state.
	TargetState *TargetState `protobuf:"bytes,3,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
	// Output only. The state of the Kubernetes cluster in preview, this will be available if
	// 'view' is set to `FULL` in the relevant List/Get/Preview request.
	ClusterState *KubernetesClusterState `protobuf:"bytes,4,opt,name=cluster_state,json=clusterState,proto3" json:"cluster_state,omitempty"`
}

func (x *PreviewCreateGameServerClusterResponse) Reset() {
	*x = PreviewCreateGameServerClusterResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewCreateGameServerClusterResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewCreateGameServerClusterResponse) ProtoMessage() {}

func (x *PreviewCreateGameServerClusterResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewCreateGameServerClusterResponse.ProtoReflect.Descriptor instead.
func (*PreviewCreateGameServerClusterResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{5}
}

func (x *PreviewCreateGameServerClusterResponse) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *PreviewCreateGameServerClusterResponse) GetTargetState() *TargetState {
	if x != nil {
		return x.TargetState
	}
	return nil
}

func (x *PreviewCreateGameServerClusterResponse) GetClusterState() *KubernetesClusterState {
	if x != nil {
		return x.ClusterState
	}
	return nil
}

// Request message for GameServerClustersService.DeleteGameServerCluster.
type DeleteGameServerClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the game server cluster to delete, in the following form:
	// `projects/{project}/locations/{location}/gameServerClusters/{cluster}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGameServerClusterRequest) Reset() {
	*x = DeleteGameServerClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGameServerClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGameServerClusterRequest) ProtoMessage() {}

func (x *DeleteGameServerClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGameServerClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteGameServerClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GameServerClustersService.PreviewDeleteGameServerCluster.
type PreviewDeleteGameServerClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the game server cluster to delete, in the following form:
	// `projects/{project}/locations/{location}/gameServerClusters/{cluster}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The target timestamp to compute the preview.
	PreviewTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=preview_time,json=previewTime,proto3" json:"preview_time,omitempty"`
}

func (x *PreviewDeleteGameServerClusterRequest) Reset() {
	*x = PreviewDeleteGameServerClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewDeleteGameServerClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewDeleteGameServerClusterRequest) ProtoMessage() {}

func (x *PreviewDeleteGameServerClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewDeleteGameServerClusterRequest.ProtoReflect.Descriptor instead.
func (*PreviewDeleteGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{7}
}

func (x *PreviewDeleteGameServerClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PreviewDeleteGameServerClusterRequest) GetPreviewTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PreviewTime
	}
	return nil
}

// Response message for
// GameServerClustersService.PreviewDeleteGameServerCluster.
type PreviewDeleteGameServerClusterResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ETag of the game server cluster.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The target state.
	TargetState *TargetState `protobuf:"bytes,3,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
}

func (x *PreviewDeleteGameServerClusterResponse) Reset() {
	*x = PreviewDeleteGameServerClusterResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewDeleteGameServerClusterResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewDeleteGameServerClusterResponse) ProtoMessage() {}

func (x *PreviewDeleteGameServerClusterResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewDeleteGameServerClusterResponse.ProtoReflect.Descriptor instead.
func (*PreviewDeleteGameServerClusterResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{8}
}

func (x *PreviewDeleteGameServerClusterResponse) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *PreviewDeleteGameServerClusterResponse) GetTargetState() *TargetState {
	if x != nil {
		return x.TargetState
	}
	return nil
}

// Request message for GameServerClustersService.UpdateGameServerCluster.
type UpdateGameServerClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The game server cluster to be updated.
	// Only fields specified in update_mask are updated.
	GameServerCluster *GameServerCluster `protobuf:"bytes,1,opt,name=game_server_cluster,json=gameServerCluster,proto3" json:"game_server_cluster,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGameServerClusterRequest) Reset() {
	*x = UpdateGameServerClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGameServerClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGameServerClusterRequest) ProtoMessage() {}

func (x *UpdateGameServerClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGameServerClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateGameServerClusterRequest) GetGameServerCluster() *GameServerCluster {
	if x != nil {
		return x.GameServerCluster
	}
	return nil
}

func (x *UpdateGameServerClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GameServerClustersService.UpdateGameServerCluster.
type PreviewUpdateGameServerClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The game server cluster to be updated.
	// Only fields specified in update_mask are updated.
	GameServerCluster *GameServerCluster `protobuf:"bytes,1,opt,name=game_server_cluster,json=gameServerCluster,proto3" json:"game_server_cluster,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The target timestamp to compute the preview.
	PreviewTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=preview_time,json=previewTime,proto3" json:"preview_time,omitempty"`
}

func (x *PreviewUpdateGameServerClusterRequest) Reset() {
	*x = PreviewUpdateGameServerClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewUpdateGameServerClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewUpdateGameServerClusterRequest) ProtoMessage() {}

func (x *PreviewUpdateGameServerClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewUpdateGameServerClusterRequest.ProtoReflect.Descriptor instead.
func (*PreviewUpdateGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{10}
}

func (x *PreviewUpdateGameServerClusterRequest) GetGameServerCluster() *GameServerCluster {
	if x != nil {
		return x.GameServerCluster
	}
	return nil
}

func (x *PreviewUpdateGameServerClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *PreviewUpdateGameServerClusterRequest) GetPreviewTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PreviewTime
	}
	return nil
}

// Response message for GameServerClustersService.PreviewUpdateGameServerCluster
type PreviewUpdateGameServerClusterResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ETag of the game server cluster.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The target state.
	TargetState *TargetState `protobuf:"bytes,3,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
}

func (x *PreviewUpdateGameServerClusterResponse) Reset() {
	*x = PreviewUpdateGameServerClusterResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewUpdateGameServerClusterResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewUpdateGameServerClusterResponse) ProtoMessage() {}

func (x *PreviewUpdateGameServerClusterResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewUpdateGameServerClusterResponse.ProtoReflect.Descriptor instead.
func (*PreviewUpdateGameServerClusterResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{11}
}

func (x *PreviewUpdateGameServerClusterResponse) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *PreviewUpdateGameServerClusterResponse) GetTargetState() *TargetState {
	if x != nil {
		return x.TargetState
	}
	return nil
}

// The game server cluster connection information.
type GameServerClusterConnectionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location of the Kubernetes cluster.
	//
	// Types that are assignable to ClusterReference:
	//
	//	*GameServerClusterConnectionInfo_GkeClusterReference
	ClusterReference isGameServerClusterConnectionInfo_ClusterReference `protobuf_oneof:"cluster_reference"`
	// Namespace designated on the game server cluster where the Agones game
	// server instances will be created. Existence of the namespace will be
	// validated during creation.
	Namespace string `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (x *GameServerClusterConnectionInfo) Reset() {
	*x = GameServerClusterConnectionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GameServerClusterConnectionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GameServerClusterConnectionInfo) ProtoMessage() {}

func (x *GameServerClusterConnectionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GameServerClusterConnectionInfo.ProtoReflect.Descriptor instead.
func (*GameServerClusterConnectionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{12}
}

func (m *GameServerClusterConnectionInfo) GetClusterReference() isGameServerClusterConnectionInfo_ClusterReference {
	if m != nil {
		return m.ClusterReference
	}
	return nil
}

func (x *GameServerClusterConnectionInfo) GetGkeClusterReference() *GkeClusterReference {
	if x, ok := x.GetClusterReference().(*GameServerClusterConnectionInfo_GkeClusterReference); ok {
		return x.GkeClusterReference
	}
	return nil
}

func (x *GameServerClusterConnectionInfo) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

type isGameServerClusterConnectionInfo_ClusterReference interface {
	isGameServerClusterConnectionInfo_ClusterReference()
}

type GameServerClusterConnectionInfo_GkeClusterReference struct {
	// Reference to the GKE cluster where the game servers are installed.
	GkeClusterReference *GkeClusterReference `protobuf:"bytes,7,opt,name=gke_cluster_reference,json=gkeClusterReference,proto3,oneof"`
}

func (*GameServerClusterConnectionInfo_GkeClusterReference) isGameServerClusterConnectionInfo_ClusterReference() {
}

// A reference to a GKE cluster.
type GkeClusterReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full or partial name of a GKE cluster, using one of the following
	// forms:
	//   - `projects/{project}/locations/{location}/clusters/{cluster}`
	//   - `locations/{location}/clusters/{cluster}`
	//   - `{cluster}`
	//
	// If project and location are not specified, the project and location of the
	// GameServerCluster resource are used to generate the full name of the
	// GKE cluster.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
}

func (x *GkeClusterReference) Reset() {
	*x = GkeClusterReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeClusterReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeClusterReference) ProtoMessage() {}

func (x *GkeClusterReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeClusterReference.ProtoReflect.Descriptor instead.
func (*GkeClusterReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{13}
}

func (x *GkeClusterReference) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

// A game server cluster resource.
type GameServerCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the game server cluster, in the following form:
	// `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
	// For example,
	// `projects/my-project/locations/{location}/realms/zanzibar/gameServerClusters/my-onprem-cluster`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last-modified time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels associated with this game server cluster. Each label is a
	// key-value pair.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The game server cluster connection information. This information is used to
	// manage game server clusters.
	ConnectionInfo *GameServerClusterConnectionInfo `protobuf:"bytes,5,opt,name=connection_info,json=connectionInfo,proto3" json:"connection_info,omitempty"`
	// ETag of the resource.
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
	// Human readable description of the cluster.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The state of the Kubernetes cluster, this will be available if
	// 'view' is set to `FULL` in the relevant List/Get/Preview request.
	ClusterState *KubernetesClusterState `protobuf:"bytes,11,opt,name=cluster_state,json=clusterState,proto3" json:"cluster_state,omitempty"`
}

func (x *GameServerCluster) Reset() {
	*x = GameServerCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GameServerCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GameServerCluster) ProtoMessage() {}

func (x *GameServerCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GameServerCluster.ProtoReflect.Descriptor instead.
func (*GameServerCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{14}
}

func (x *GameServerCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GameServerCluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GameServerCluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *GameServerCluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *GameServerCluster) GetConnectionInfo() *GameServerClusterConnectionInfo {
	if x != nil {
		return x.ConnectionInfo
	}
	return nil
}

func (x *GameServerCluster) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *GameServerCluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *GameServerCluster) GetClusterState() *KubernetesClusterState {
	if x != nil {
		return x.ClusterState
	}
	return nil
}

// The state of the Kubernetes cluster.
type KubernetesClusterState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The version of Agones currently installed in the registered Kubernetes
	// cluster.
	AgonesVersionInstalled string `protobuf:"bytes,1,opt,name=agones_version_installed,json=agonesVersionInstalled,proto3" json:"agones_version_installed,omitempty"`
	// Output only. The version of Kubernetes that is currently used in the registered
	// Kubernetes cluster (as detected by the Cloud Game Servers service).
	KubernetesVersionInstalled string `protobuf:"bytes,2,opt,name=kubernetes_version_installed,json=kubernetesVersionInstalled,proto3" json:"kubernetes_version_installed,omitempty"`
	// Output only. The state for the installed versions of Agones/Kubernetes.
	InstallationState KubernetesClusterState_InstallationState `protobuf:"varint,3,opt,name=installation_state,json=installationState,proto3,enum=google.cloud.gaming.v1.KubernetesClusterState_InstallationState" json:"installation_state,omitempty"`
	// Output only. The detailed error message for the installed versions of Agones/Kubernetes.
	VersionInstalledErrorMessage string `protobuf:"bytes,4,opt,name=version_installed_error_message,json=versionInstalledErrorMessage,proto3" json:"version_installed_error_message,omitempty"`
	// Output only. The cloud provider type reported by the first node's providerID in the list
	// of nodes on the Kubernetes endpoint. On Kubernetes platforms that support
	// zero-node clusters (like GKE-on-GCP), the provider type will be empty.
	Provider string `protobuf:"bytes,5,opt,name=provider,proto3" json:"provider,omitempty"`
	// Output only. The version of Agones that is targeted to be installed in the cluster.
	AgonesVersionTargeted string `protobuf:"bytes,6,opt,name=agones_version_targeted,json=agonesVersionTargeted,proto3" json:"agones_version_targeted,omitempty"`
}

func (x *KubernetesClusterState) Reset() {
	*x = KubernetesClusterState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesClusterState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesClusterState) ProtoMessage() {}

func (x *KubernetesClusterState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesClusterState.ProtoReflect.Descriptor instead.
func (*KubernetesClusterState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP(), []int{15}
}

func (x *KubernetesClusterState) GetAgonesVersionInstalled() string {
	if x != nil {
		return x.AgonesVersionInstalled
	}
	return ""
}

func (x *KubernetesClusterState) GetKubernetesVersionInstalled() string {
	if x != nil {
		return x.KubernetesVersionInstalled
	}
	return ""
}

func (x *KubernetesClusterState) GetInstallationState() KubernetesClusterState_InstallationState {
	if x != nil {
		return x.InstallationState
	}
	return KubernetesClusterState_INSTALLATION_STATE_UNSPECIFIED
}

func (x *KubernetesClusterState) GetVersionInstalledErrorMessage() string {
	if x != nil {
		return x.VersionInstalledErrorMessage
	}
	return ""
}

func (x *KubernetesClusterState) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *KubernetesClusterState) GetAgonesVersionTargeted() string {
	if x != nil {
		return x.AgonesVersionTargeted
	}
	return ""
}

var File_google_cloud_gaming_v1_game_server_clusters_proto protoreflect.FileDescriptor

var file_google_cloud_gaming_v1_game_server_clusters_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xb9, 0x02, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x67, 0x61, 0x6d, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x12, 0x46, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xc7, 0x01, 0x0a, 0x1e,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b,
	0x0a, 0x14, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x12, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x47, 0x61, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x67, 0x61, 0x6d,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x46, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x89, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x16, 0x67, 0x61,
	0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x13, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x5e, 0x0a, 0x13, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x11, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x22, 0x9e, 0x03, 0x0a, 0x25, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a,
	0x16, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x13, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x5e, 0x0a, 0x13, 0x67, 0x61, 0x6d, 0x65, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x42, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xde, 0x01, 0x0a, 0x26, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x12, 0x46, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x58, 0x0a, 0x0d,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62,
	0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x6b, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d,
	0x67, 0x61, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x6d, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x25, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x84, 0x01, 0x0a,
	0x26, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x61,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x46, 0x0a, 0x0c, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x22, 0xc2, 0x01, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x61,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x13, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x8d, 0x02, 0x0a, 0x25, 0x50, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x5e, 0x0a, 0x13, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x11, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x42, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x84, 0x01, 0x0a, 0x26, 0x50, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x46, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22,
	0xb7, 0x01, 0x0a, 0x1f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x61, 0x0a, 0x15, 0x67, 0x6b, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x13, 0x67, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x2f, 0x0a, 0x13, 0x47, 0x6b, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0xb7, 0x05, 0x0a, 0x11, 0x47,
	0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x60, 0x0a, 0x0f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x88, 0x01, 0xea, 0x41, 0x84, 0x01,
	0x0a, 0x2d, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x61, 0x6c, 0x6d, 0x73, 0x2f,
	0x7b, 0x72, 0x65, 0x61, 0x6c, 0x6d, 0x7d, 0x2f, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x7d, 0x22, 0xed, 0x05, 0x0a, 0x16, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65,
	0x74, 0x65, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x3d, 0x0a, 0x18, 0x61, 0x67, 0x6f, 0x6e, 0x65, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x61, 0x67, 0x6f, 0x6e, 0x65, 0x73, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x12, 0x45,
	0x0a, 0x1c, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x6b, 0x75, 0x62, 0x65, 0x72,
	0x6e, 0x65, 0x74, 0x65, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x65, 0x64, 0x12, 0x74, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72,
	0x6e, 0x65, 0x74, 0x65, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4a, 0x0a, 0x1f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1c, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x17, 0x61, 0x67, 0x6f, 0x6e,
	0x65, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x61, 0x67, 0x6f, 0x6e, 0x65, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x65, 0x64, 0x22, 0xac, 0x02, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x49,
	0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x27, 0x0a, 0x23, 0x41, 0x47, 0x4f, 0x4e, 0x45, 0x53, 0x5f, 0x4b, 0x55, 0x42, 0x45, 0x52, 0x4e,
	0x45, 0x54, 0x45, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x47, 0x4f, 0x4e,
	0x45, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x29, 0x0a, 0x25, 0x41, 0x47, 0x4f, 0x4e,
	0x45, 0x53, 0x5f, 0x4b, 0x55, 0x42, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x45, 0x53, 0x5f, 0x56, 0x45,
	0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x47, 0x4f, 0x4e, 0x45, 0x53, 0x5f, 0x56, 0x45,
	0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x52, 0x45, 0x43, 0x4f, 0x47, 0x4e, 0x49, 0x5a,
	0x45, 0x44, 0x10, 0x04, 0x12, 0x23, 0x0a, 0x1f, 0x4b, 0x55, 0x42, 0x45, 0x52, 0x4e, 0x45, 0x54,
	0x45, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x52, 0x45, 0x43,
	0x4f, 0x47, 0x4e, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x05, 0x12, 0x1f, 0x0a, 0x1b, 0x56, 0x45, 0x52,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x47,
	0x4f, 0x4e, 0x45, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c,
	0x45, 0x44, 0x10, 0x07, 0x2a, 0x56, 0x0a, 0x15, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x12, 0x28, 0x0a,
	0x24, 0x47, 0x41, 0x4d, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x43, 0x4c, 0x55,
	0x53, 0x54, 0x45, 0x52, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43,
	0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x42, 0x5c, 0x0a, 0x1a,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x3c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x2f, 0x76, 0x31, 0x3b, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescOnce sync.Once
	file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescData = file_google_cloud_gaming_v1_game_server_clusters_proto_rawDesc
)

func file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescGZIP() []byte {
	file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescOnce.Do(func() {
		file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescData)
	})
	return file_google_cloud_gaming_v1_game_server_clusters_proto_rawDescData
}

var file_google_cloud_gaming_v1_game_server_clusters_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_gaming_v1_game_server_clusters_proto_goTypes = []interface{}{
	(GameServerClusterView)(0),                     // 0: google.cloud.gaming.v1.GameServerClusterView
	(KubernetesClusterState_InstallationState)(0),  // 1: google.cloud.gaming.v1.KubernetesClusterState.InstallationState
	(*ListGameServerClustersRequest)(nil),          // 2: google.cloud.gaming.v1.ListGameServerClustersRequest
	(*ListGameServerClustersResponse)(nil),         // 3: google.cloud.gaming.v1.ListGameServerClustersResponse
	(*GetGameServerClusterRequest)(nil),            // 4: google.cloud.gaming.v1.GetGameServerClusterRequest
	(*CreateGameServerClusterRequest)(nil),         // 5: google.cloud.gaming.v1.CreateGameServerClusterRequest
	(*PreviewCreateGameServerClusterRequest)(nil),  // 6: google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest
	(*PreviewCreateGameServerClusterResponse)(nil), // 7: google.cloud.gaming.v1.PreviewCreateGameServerClusterResponse
	(*DeleteGameServerClusterRequest)(nil),         // 8: google.cloud.gaming.v1.DeleteGameServerClusterRequest
	(*PreviewDeleteGameServerClusterRequest)(nil),  // 9: google.cloud.gaming.v1.PreviewDeleteGameServerClusterRequest
	(*PreviewDeleteGameServerClusterResponse)(nil), // 10: google.cloud.gaming.v1.PreviewDeleteGameServerClusterResponse
	(*UpdateGameServerClusterRequest)(nil),         // 11: google.cloud.gaming.v1.UpdateGameServerClusterRequest
	(*PreviewUpdateGameServerClusterRequest)(nil),  // 12: google.cloud.gaming.v1.PreviewUpdateGameServerClusterRequest
	(*PreviewUpdateGameServerClusterResponse)(nil), // 13: google.cloud.gaming.v1.PreviewUpdateGameServerClusterResponse
	(*GameServerClusterConnectionInfo)(nil),        // 14: google.cloud.gaming.v1.GameServerClusterConnectionInfo
	(*GkeClusterReference)(nil),                    // 15: google.cloud.gaming.v1.GkeClusterReference
	(*GameServerCluster)(nil),                      // 16: google.cloud.gaming.v1.GameServerCluster
	(*KubernetesClusterState)(nil),                 // 17: google.cloud.gaming.v1.KubernetesClusterState
	nil,                                            // 18: google.cloud.gaming.v1.GameServerCluster.LabelsEntry
	(*timestamppb.Timestamp)(nil),                  // 19: google.protobuf.Timestamp
	(*TargetState)(nil),                            // 20: google.cloud.gaming.v1.TargetState
	(*fieldmaskpb.FieldMask)(nil),                  // 21: google.protobuf.FieldMask
}
var file_google_cloud_gaming_v1_game_server_clusters_proto_depIdxs = []int32{
	0,  // 0: google.cloud.gaming.v1.ListGameServerClustersRequest.view:type_name -> google.cloud.gaming.v1.GameServerClusterView
	16, // 1: google.cloud.gaming.v1.ListGameServerClustersResponse.game_server_clusters:type_name -> google.cloud.gaming.v1.GameServerCluster
	0,  // 2: google.cloud.gaming.v1.GetGameServerClusterRequest.view:type_name -> google.cloud.gaming.v1.GameServerClusterView
	16, // 3: google.cloud.gaming.v1.CreateGameServerClusterRequest.game_server_cluster:type_name -> google.cloud.gaming.v1.GameServerCluster
	16, // 4: google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest.game_server_cluster:type_name -> google.cloud.gaming.v1.GameServerCluster
	19, // 5: google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest.preview_time:type_name -> google.protobuf.Timestamp
	0,  // 6: google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest.view:type_name -> google.cloud.gaming.v1.GameServerClusterView
	20, // 7: google.cloud.gaming.v1.PreviewCreateGameServerClusterResponse.target_state:type_name -> google.cloud.gaming.v1.TargetState
	17, // 8: google.cloud.gaming.v1.PreviewCreateGameServerClusterResponse.cluster_state:type_name -> google.cloud.gaming.v1.KubernetesClusterState
	19, // 9: google.cloud.gaming.v1.PreviewDeleteGameServerClusterRequest.preview_time:type_name -> google.protobuf.Timestamp
	20, // 10: google.cloud.gaming.v1.PreviewDeleteGameServerClusterResponse.target_state:type_name -> google.cloud.gaming.v1.TargetState
	16, // 11: google.cloud.gaming.v1.UpdateGameServerClusterRequest.game_server_cluster:type_name -> google.cloud.gaming.v1.GameServerCluster
	21, // 12: google.cloud.gaming.v1.UpdateGameServerClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	16, // 13: google.cloud.gaming.v1.PreviewUpdateGameServerClusterRequest.game_server_cluster:type_name -> google.cloud.gaming.v1.GameServerCluster
	21, // 14: google.cloud.gaming.v1.PreviewUpdateGameServerClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	19, // 15: google.cloud.gaming.v1.PreviewUpdateGameServerClusterRequest.preview_time:type_name -> google.protobuf.Timestamp
	20, // 16: google.cloud.gaming.v1.PreviewUpdateGameServerClusterResponse.target_state:type_name -> google.cloud.gaming.v1.TargetState
	15, // 17: google.cloud.gaming.v1.GameServerClusterConnectionInfo.gke_cluster_reference:type_name -> google.cloud.gaming.v1.GkeClusterReference
	19, // 18: google.cloud.gaming.v1.GameServerCluster.create_time:type_name -> google.protobuf.Timestamp
	19, // 19: google.cloud.gaming.v1.GameServerCluster.update_time:type_name -> google.protobuf.Timestamp
	18, // 20: google.cloud.gaming.v1.GameServerCluster.labels:type_name -> google.cloud.gaming.v1.GameServerCluster.LabelsEntry
	14, // 21: google.cloud.gaming.v1.GameServerCluster.connection_info:type_name -> google.cloud.gaming.v1.GameServerClusterConnectionInfo
	17, // 22: google.cloud.gaming.v1.GameServerCluster.cluster_state:type_name -> google.cloud.gaming.v1.KubernetesClusterState
	1,  // 23: google.cloud.gaming.v1.KubernetesClusterState.installation_state:type_name -> google.cloud.gaming.v1.KubernetesClusterState.InstallationState
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_cloud_gaming_v1_game_server_clusters_proto_init() }
func file_google_cloud_gaming_v1_game_server_clusters_proto_init() {
	if File_google_cloud_gaming_v1_game_server_clusters_proto != nil {
		return
	}
	file_google_cloud_gaming_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGameServerClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGameServerClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGameServerClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGameServerClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewCreateGameServerClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewCreateGameServerClusterResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGameServerClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewDeleteGameServerClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewDeleteGameServerClusterResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGameServerClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewUpdateGameServerClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewUpdateGameServerClusterResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GameServerClusterConnectionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeClusterReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GameServerCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesClusterState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*GameServerClusterConnectionInfo_GkeClusterReference)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gaming_v1_game_server_clusters_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gaming_v1_game_server_clusters_proto_goTypes,
		DependencyIndexes: file_google_cloud_gaming_v1_game_server_clusters_proto_depIdxs,
		EnumInfos:         file_google_cloud_gaming_v1_game_server_clusters_proto_enumTypes,
		MessageInfos:      file_google_cloud_gaming_v1_game_server_clusters_proto_msgTypes,
	}.Build()
	File_google_cloud_gaming_v1_game_server_clusters_proto = out.File
	file_google_cloud_gaming_v1_game_server_clusters_proto_rawDesc = nil
	file_google_cloud_gaming_v1_game_server_clusters_proto_goTypes = nil
	file_google_cloud_gaming_v1_game_server_clusters_proto_depIdxs = nil
}
