// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networkconnectivity/v1/internal_range.proto

package networkconnectivitypb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	InternalRangeService_ListInternalRanges_FullMethodName  = "/google.cloud.networkconnectivity.v1.InternalRangeService/ListInternalRanges"
	InternalRangeService_GetInternalRange_FullMethodName    = "/google.cloud.networkconnectivity.v1.InternalRangeService/GetInternalRange"
	InternalRangeService_CreateInternalRange_FullMethodName = "/google.cloud.networkconnectivity.v1.InternalRangeService/CreateInternalRange"
	InternalRangeService_UpdateInternalRange_FullMethodName = "/google.cloud.networkconnectivity.v1.InternalRangeService/UpdateInternalRange"
	InternalRangeService_DeleteInternalRange_FullMethodName = "/google.cloud.networkconnectivity.v1.InternalRangeService/DeleteInternalRange"
)

// InternalRangeServiceClient is the client API for InternalRangeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InternalRangeServiceClient interface {
	// Lists internal ranges in a given project and location.
	ListInternalRanges(ctx context.Context, in *ListInternalRangesRequest, opts ...grpc.CallOption) (*ListInternalRangesResponse, error)
	// Gets details of a single internal range.
	GetInternalRange(ctx context.Context, in *GetInternalRangeRequest, opts ...grpc.CallOption) (*InternalRange, error)
	// Creates a new internal range in a given project and location.
	CreateInternalRange(ctx context.Context, in *CreateInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single internal range.
	UpdateInternalRange(ctx context.Context, in *UpdateInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single internal range.
	DeleteInternalRange(ctx context.Context, in *DeleteInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type internalRangeServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewInternalRangeServiceClient(cc grpc.ClientConnInterface) InternalRangeServiceClient {
	return &internalRangeServiceClient{cc}
}

func (c *internalRangeServiceClient) ListInternalRanges(ctx context.Context, in *ListInternalRangesRequest, opts ...grpc.CallOption) (*ListInternalRangesResponse, error) {
	out := new(ListInternalRangesResponse)
	err := c.cc.Invoke(ctx, InternalRangeService_ListInternalRanges_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalRangeServiceClient) GetInternalRange(ctx context.Context, in *GetInternalRangeRequest, opts ...grpc.CallOption) (*InternalRange, error) {
	out := new(InternalRange)
	err := c.cc.Invoke(ctx, InternalRangeService_GetInternalRange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalRangeServiceClient) CreateInternalRange(ctx context.Context, in *CreateInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InternalRangeService_CreateInternalRange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalRangeServiceClient) UpdateInternalRange(ctx context.Context, in *UpdateInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InternalRangeService_UpdateInternalRange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalRangeServiceClient) DeleteInternalRange(ctx context.Context, in *DeleteInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InternalRangeService_DeleteInternalRange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InternalRangeServiceServer is the server API for InternalRangeService service.
// All implementations should embed UnimplementedInternalRangeServiceServer
// for forward compatibility
type InternalRangeServiceServer interface {
	// Lists internal ranges in a given project and location.
	ListInternalRanges(context.Context, *ListInternalRangesRequest) (*ListInternalRangesResponse, error)
	// Gets details of a single internal range.
	GetInternalRange(context.Context, *GetInternalRangeRequest) (*InternalRange, error)
	// Creates a new internal range in a given project and location.
	CreateInternalRange(context.Context, *CreateInternalRangeRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single internal range.
	UpdateInternalRange(context.Context, *UpdateInternalRangeRequest) (*longrunningpb.Operation, error)
	// Deletes a single internal range.
	DeleteInternalRange(context.Context, *DeleteInternalRangeRequest) (*longrunningpb.Operation, error)
}

// UnimplementedInternalRangeServiceServer should be embedded to have forward compatible implementations.
type UnimplementedInternalRangeServiceServer struct {
}

func (UnimplementedInternalRangeServiceServer) ListInternalRanges(context.Context, *ListInternalRangesRequest) (*ListInternalRangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInternalRanges not implemented")
}
func (UnimplementedInternalRangeServiceServer) GetInternalRange(context.Context, *GetInternalRangeRequest) (*InternalRange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInternalRange not implemented")
}
func (UnimplementedInternalRangeServiceServer) CreateInternalRange(context.Context, *CreateInternalRangeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInternalRange not implemented")
}
func (UnimplementedInternalRangeServiceServer) UpdateInternalRange(context.Context, *UpdateInternalRangeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInternalRange not implemented")
}
func (UnimplementedInternalRangeServiceServer) DeleteInternalRange(context.Context, *DeleteInternalRangeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInternalRange not implemented")
}

// UnsafeInternalRangeServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InternalRangeServiceServer will
// result in compilation errors.
type UnsafeInternalRangeServiceServer interface {
	mustEmbedUnimplementedInternalRangeServiceServer()
}

func RegisterInternalRangeServiceServer(s grpc.ServiceRegistrar, srv InternalRangeServiceServer) {
	s.RegisterService(&InternalRangeService_ServiceDesc, srv)
}

func _InternalRangeService_ListInternalRanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInternalRangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).ListInternalRanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InternalRangeService_ListInternalRanges_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).ListInternalRanges(ctx, req.(*ListInternalRangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalRangeService_GetInternalRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInternalRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).GetInternalRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InternalRangeService_GetInternalRange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).GetInternalRange(ctx, req.(*GetInternalRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalRangeService_CreateInternalRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInternalRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).CreateInternalRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InternalRangeService_CreateInternalRange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).CreateInternalRange(ctx, req.(*CreateInternalRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalRangeService_UpdateInternalRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInternalRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).UpdateInternalRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InternalRangeService_UpdateInternalRange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).UpdateInternalRange(ctx, req.(*UpdateInternalRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalRangeService_DeleteInternalRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInternalRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).DeleteInternalRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InternalRangeService_DeleteInternalRange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).DeleteInternalRange(ctx, req.(*DeleteInternalRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InternalRangeService_ServiceDesc is the grpc.ServiceDesc for InternalRangeService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InternalRangeService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.InternalRangeService",
	HandlerType: (*InternalRangeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInternalRanges",
			Handler:    _InternalRangeService_ListInternalRanges_Handler,
		},
		{
			MethodName: "GetInternalRange",
			Handler:    _InternalRangeService_GetInternalRange_Handler,
		},
		{
			MethodName: "CreateInternalRange",
			Handler:    _InternalRangeService_CreateInternalRange_Handler,
		},
		{
			MethodName: "UpdateInternalRange",
			Handler:    _InternalRangeService_UpdateInternalRange_Handler,
		},
		{
			MethodName: "DeleteInternalRange",
			Handler:    _InternalRangeService_DeleteInternalRange_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/internal_range.proto",
}
