// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/optimization/v1/fleet_routing.proto

package optimizationpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	FleetRouting_OptimizeTours_FullMethodName      = "/google.cloud.optimization.v1.FleetRouting/OptimizeTours"
	FleetRouting_BatchOptimizeTours_FullMethodName = "/google.cloud.optimization.v1.FleetRouting/BatchOptimizeTours"
)

// FleetRoutingClient is the client API for FleetRouting service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FleetRoutingClient interface {
	// Sends an `OptimizeToursRequest` containing a `ShipmentModel` and returns an
	// `OptimizeToursResponse` containing `ShipmentRoute`s, which are a set of
	// routes to be performed by vehicles minimizing the overall cost.
	//
	// A `ShipmentModel` model consists mainly of `Shipment`s that need to be
	// carried out and `Vehicle`s that can be used to transport the `Shipment`s.
	// The `ShipmentRoute`s assign `Shipment`s to `Vehicle`s. More specifically,
	// they assign a series of `Visit`s to each vehicle, where a `Visit`
	// corresponds to a `VisitRequest`, which is a pickup or delivery for a
	// `Shipment`.
	//
	// The goal is to provide an assignment of `ShipmentRoute`s to `Vehicle`s that
	// minimizes the total cost where cost has many components defined in the
	// `ShipmentModel`.
	OptimizeTours(ctx context.Context, in *OptimizeToursRequest, opts ...grpc.CallOption) (*OptimizeToursResponse, error)
	// Optimizes vehicle tours for one or more `OptimizeToursRequest`
	// messages as a batch.
	//
	// This method is a Long Running Operation (LRO). The inputs for optimization
	// (`OptimizeToursRequest` messages) and outputs (`OptimizeToursResponse`
	// messages) are read/written from/to Cloud Storage in user-specified
	// format. Like the `OptimizeTours` method, each `OptimizeToursRequest`
	// contains a `ShipmentModel` and returns an `OptimizeToursResponse`
	// containing `ShipmentRoute`s, which are a set of routes to be performed by
	// vehicles minimizing the overall cost.
	BatchOptimizeTours(ctx context.Context, in *BatchOptimizeToursRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type fleetRoutingClient struct {
	cc grpc.ClientConnInterface
}

func NewFleetRoutingClient(cc grpc.ClientConnInterface) FleetRoutingClient {
	return &fleetRoutingClient{cc}
}

func (c *fleetRoutingClient) OptimizeTours(ctx context.Context, in *OptimizeToursRequest, opts ...grpc.CallOption) (*OptimizeToursResponse, error) {
	out := new(OptimizeToursResponse)
	err := c.cc.Invoke(ctx, FleetRouting_OptimizeTours_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fleetRoutingClient) BatchOptimizeTours(ctx context.Context, in *BatchOptimizeToursRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FleetRouting_BatchOptimizeTours_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FleetRoutingServer is the server API for FleetRouting service.
// All implementations should embed UnimplementedFleetRoutingServer
// for forward compatibility
type FleetRoutingServer interface {
	// Sends an `OptimizeToursRequest` containing a `ShipmentModel` and returns an
	// `OptimizeToursResponse` containing `ShipmentRoute`s, which are a set of
	// routes to be performed by vehicles minimizing the overall cost.
	//
	// A `ShipmentModel` model consists mainly of `Shipment`s that need to be
	// carried out and `Vehicle`s that can be used to transport the `Shipment`s.
	// The `ShipmentRoute`s assign `Shipment`s to `Vehicle`s. More specifically,
	// they assign a series of `Visit`s to each vehicle, where a `Visit`
	// corresponds to a `VisitRequest`, which is a pickup or delivery for a
	// `Shipment`.
	//
	// The goal is to provide an assignment of `ShipmentRoute`s to `Vehicle`s that
	// minimizes the total cost where cost has many components defined in the
	// `ShipmentModel`.
	OptimizeTours(context.Context, *OptimizeToursRequest) (*OptimizeToursResponse, error)
	// Optimizes vehicle tours for one or more `OptimizeToursRequest`
	// messages as a batch.
	//
	// This method is a Long Running Operation (LRO). The inputs for optimization
	// (`OptimizeToursRequest` messages) and outputs (`OptimizeToursResponse`
	// messages) are read/written from/to Cloud Storage in user-specified
	// format. Like the `OptimizeTours` method, each `OptimizeToursRequest`
	// contains a `ShipmentModel` and returns an `OptimizeToursResponse`
	// containing `ShipmentRoute`s, which are a set of routes to be performed by
	// vehicles minimizing the overall cost.
	BatchOptimizeTours(context.Context, *BatchOptimizeToursRequest) (*longrunningpb.Operation, error)
}

// UnimplementedFleetRoutingServer should be embedded to have forward compatible implementations.
type UnimplementedFleetRoutingServer struct {
}

func (UnimplementedFleetRoutingServer) OptimizeTours(context.Context, *OptimizeToursRequest) (*OptimizeToursResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OptimizeTours not implemented")
}
func (UnimplementedFleetRoutingServer) BatchOptimizeTours(context.Context, *BatchOptimizeToursRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchOptimizeTours not implemented")
}

// UnsafeFleetRoutingServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FleetRoutingServer will
// result in compilation errors.
type UnsafeFleetRoutingServer interface {
	mustEmbedUnimplementedFleetRoutingServer()
}

func RegisterFleetRoutingServer(s grpc.ServiceRegistrar, srv FleetRoutingServer) {
	s.RegisterService(&FleetRouting_ServiceDesc, srv)
}

func _FleetRouting_OptimizeTours_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OptimizeToursRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FleetRoutingServer).OptimizeTours(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FleetRouting_OptimizeTours_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FleetRoutingServer).OptimizeTours(ctx, req.(*OptimizeToursRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FleetRouting_BatchOptimizeTours_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchOptimizeToursRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FleetRoutingServer).BatchOptimizeTours(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FleetRouting_BatchOptimizeTours_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FleetRoutingServer).BatchOptimizeTours(ctx, req.(*BatchOptimizeToursRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FleetRouting_ServiceDesc is the grpc.ServiceDesc for FleetRouting service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FleetRouting_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.optimization.v1.FleetRouting",
	HandlerType: (*FleetRoutingServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "OptimizeTours",
			Handler:    _FleetRouting_OptimizeTours_Handler,
		},
		{
			MethodName: "BatchOptimizeTours",
			Handler:    _FleetRouting_BatchOptimizeTours_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/optimization/v1/fleet_routing.proto",
}
