// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/resourcemanager/v3/tag_keys.proto

package resourcemanagerpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TagKeys_ListTagKeys_FullMethodName         = "/google.cloud.resourcemanager.v3.TagKeys/ListTagKeys"
	TagKeys_GetTagKey_FullMethodName           = "/google.cloud.resourcemanager.v3.TagKeys/GetTagKey"
	TagKeys_GetNamespacedTagKey_FullMethodName = "/google.cloud.resourcemanager.v3.TagKeys/GetNamespacedTagKey"
	TagKeys_CreateTagKey_FullMethodName        = "/google.cloud.resourcemanager.v3.TagKeys/CreateTagKey"
	TagKeys_UpdateTagKey_FullMethodName        = "/google.cloud.resourcemanager.v3.TagKeys/UpdateTagKey"
	TagKeys_DeleteTagKey_FullMethodName        = "/google.cloud.resourcemanager.v3.TagKeys/DeleteTagKey"
	TagKeys_GetIamPolicy_FullMethodName        = "/google.cloud.resourcemanager.v3.TagKeys/GetIamPolicy"
	TagKeys_SetIamPolicy_FullMethodName        = "/google.cloud.resourcemanager.v3.TagKeys/SetIamPolicy"
	TagKeys_TestIamPermissions_FullMethodName  = "/google.cloud.resourcemanager.v3.TagKeys/TestIamPermissions"
)

// TagKeysClient is the client API for TagKeys service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TagKeysClient interface {
	// Lists all TagKeys for a parent resource.
	ListTagKeys(ctx context.Context, in *ListTagKeysRequest, opts ...grpc.CallOption) (*ListTagKeysResponse, error)
	// Retrieves a TagKey. This method will return `PERMISSION_DENIED` if the
	// key does not exist or the user does not have permission to view it.
	GetTagKey(ctx context.Context, in *GetTagKeyRequest, opts ...grpc.CallOption) (*TagKey, error)
	// Retrieves a TagKey by its namespaced name.
	// This method will return `PERMISSION_DENIED` if the key does not exist
	// or the user does not have permission to view it.
	GetNamespacedTagKey(ctx context.Context, in *GetNamespacedTagKeyRequest, opts ...grpc.CallOption) (*TagKey, error)
	// Creates a new TagKey. If another request with the same parameters is
	// sent while the original request is in process, the second request
	// will receive an error. A maximum of 1000 TagKeys can exist under a parent
	// at any given time.
	CreateTagKey(ctx context.Context, in *CreateTagKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the attributes of the TagKey resource.
	UpdateTagKey(ctx context.Context, in *UpdateTagKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a TagKey. The TagKey cannot be deleted if it has any child
	// TagValues.
	DeleteTagKey(ctx context.Context, in *DeleteTagKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the access control policy for a TagKey. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the TagKey's resource name. For example, "tagKeys/1234".
	// The caller must have
	// `cloudresourcemanager.googleapis.com/tagKeys.getIamPolicy` permission on
	// the specified TagKey.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the access control policy on a TagKey, replacing any existing
	// policy. The `resource` field should be the TagKey's resource name.
	// For example, "tagKeys/1234".
	// The caller must have `resourcemanager.tagKeys.setIamPolicy` permission
	// on the identified tagValue.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified TagKey.
	// The `resource` field should be the TagKey's resource name.
	// For example, "tagKeys/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type tagKeysClient struct {
	cc grpc.ClientConnInterface
}

func NewTagKeysClient(cc grpc.ClientConnInterface) TagKeysClient {
	return &tagKeysClient{cc}
}

func (c *tagKeysClient) ListTagKeys(ctx context.Context, in *ListTagKeysRequest, opts ...grpc.CallOption) (*ListTagKeysResponse, error) {
	out := new(ListTagKeysResponse)
	err := c.cc.Invoke(ctx, TagKeys_ListTagKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagKeysClient) GetTagKey(ctx context.Context, in *GetTagKeyRequest, opts ...grpc.CallOption) (*TagKey, error) {
	out := new(TagKey)
	err := c.cc.Invoke(ctx, TagKeys_GetTagKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagKeysClient) GetNamespacedTagKey(ctx context.Context, in *GetNamespacedTagKeyRequest, opts ...grpc.CallOption) (*TagKey, error) {
	out := new(TagKey)
	err := c.cc.Invoke(ctx, TagKeys_GetNamespacedTagKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagKeysClient) CreateTagKey(ctx context.Context, in *CreateTagKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TagKeys_CreateTagKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagKeysClient) UpdateTagKey(ctx context.Context, in *UpdateTagKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TagKeys_UpdateTagKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagKeysClient) DeleteTagKey(ctx context.Context, in *DeleteTagKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TagKeys_DeleteTagKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagKeysClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, TagKeys_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagKeysClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, TagKeys_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagKeysClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, TagKeys_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TagKeysServer is the server API for TagKeys service.
// All implementations should embed UnimplementedTagKeysServer
// for forward compatibility
type TagKeysServer interface {
	// Lists all TagKeys for a parent resource.
	ListTagKeys(context.Context, *ListTagKeysRequest) (*ListTagKeysResponse, error)
	// Retrieves a TagKey. This method will return `PERMISSION_DENIED` if the
	// key does not exist or the user does not have permission to view it.
	GetTagKey(context.Context, *GetTagKeyRequest) (*TagKey, error)
	// Retrieves a TagKey by its namespaced name.
	// This method will return `PERMISSION_DENIED` if the key does not exist
	// or the user does not have permission to view it.
	GetNamespacedTagKey(context.Context, *GetNamespacedTagKeyRequest) (*TagKey, error)
	// Creates a new TagKey. If another request with the same parameters is
	// sent while the original request is in process, the second request
	// will receive an error. A maximum of 1000 TagKeys can exist under a parent
	// at any given time.
	CreateTagKey(context.Context, *CreateTagKeyRequest) (*longrunningpb.Operation, error)
	// Updates the attributes of the TagKey resource.
	UpdateTagKey(context.Context, *UpdateTagKeyRequest) (*longrunningpb.Operation, error)
	// Deletes a TagKey. The TagKey cannot be deleted if it has any child
	// TagValues.
	DeleteTagKey(context.Context, *DeleteTagKeyRequest) (*longrunningpb.Operation, error)
	// Gets the access control policy for a TagKey. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the TagKey's resource name. For example, "tagKeys/1234".
	// The caller must have
	// `cloudresourcemanager.googleapis.com/tagKeys.getIamPolicy` permission on
	// the specified TagKey.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the access control policy on a TagKey, replacing any existing
	// policy. The `resource` field should be the TagKey's resource name.
	// For example, "tagKeys/1234".
	// The caller must have `resourcemanager.tagKeys.setIamPolicy` permission
	// on the identified tagValue.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified TagKey.
	// The `resource` field should be the TagKey's resource name.
	// For example, "tagKeys/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedTagKeysServer should be embedded to have forward compatible implementations.
type UnimplementedTagKeysServer struct {
}

func (UnimplementedTagKeysServer) ListTagKeys(context.Context, *ListTagKeysRequest) (*ListTagKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTagKeys not implemented")
}
func (UnimplementedTagKeysServer) GetTagKey(context.Context, *GetTagKeyRequest) (*TagKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTagKey not implemented")
}
func (UnimplementedTagKeysServer) GetNamespacedTagKey(context.Context, *GetNamespacedTagKeyRequest) (*TagKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNamespacedTagKey not implemented")
}
func (UnimplementedTagKeysServer) CreateTagKey(context.Context, *CreateTagKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagKey not implemented")
}
func (UnimplementedTagKeysServer) UpdateTagKey(context.Context, *UpdateTagKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagKey not implemented")
}
func (UnimplementedTagKeysServer) DeleteTagKey(context.Context, *DeleteTagKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagKey not implemented")
}
func (UnimplementedTagKeysServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedTagKeysServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedTagKeysServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeTagKeysServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TagKeysServer will
// result in compilation errors.
type UnsafeTagKeysServer interface {
	mustEmbedUnimplementedTagKeysServer()
}

func RegisterTagKeysServer(s grpc.ServiceRegistrar, srv TagKeysServer) {
	s.RegisterService(&TagKeys_ServiceDesc, srv)
}

func _TagKeys_ListTagKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagKeysServer).ListTagKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagKeys_ListTagKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagKeysServer).ListTagKeys(ctx, req.(*ListTagKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagKeys_GetTagKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagKeysServer).GetTagKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagKeys_GetTagKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagKeysServer).GetTagKey(ctx, req.(*GetTagKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagKeys_GetNamespacedTagKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNamespacedTagKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagKeysServer).GetNamespacedTagKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagKeys_GetNamespacedTagKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagKeysServer).GetNamespacedTagKey(ctx, req.(*GetNamespacedTagKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagKeys_CreateTagKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagKeysServer).CreateTagKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagKeys_CreateTagKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagKeysServer).CreateTagKey(ctx, req.(*CreateTagKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagKeys_UpdateTagKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagKeysServer).UpdateTagKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagKeys_UpdateTagKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagKeysServer).UpdateTagKey(ctx, req.(*UpdateTagKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagKeys_DeleteTagKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagKeysServer).DeleteTagKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagKeys_DeleteTagKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagKeysServer).DeleteTagKey(ctx, req.(*DeleteTagKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagKeys_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagKeysServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagKeys_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagKeysServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagKeys_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagKeysServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagKeys_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagKeysServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagKeys_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagKeysServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagKeys_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagKeysServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TagKeys_ServiceDesc is the grpc.ServiceDesc for TagKeys service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TagKeys_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcemanager.v3.TagKeys",
	HandlerType: (*TagKeysServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTagKeys",
			Handler:    _TagKeys_ListTagKeys_Handler,
		},
		{
			MethodName: "GetTagKey",
			Handler:    _TagKeys_GetTagKey_Handler,
		},
		{
			MethodName: "GetNamespacedTagKey",
			Handler:    _TagKeys_GetNamespacedTagKey_Handler,
		},
		{
			MethodName: "CreateTagKey",
			Handler:    _TagKeys_CreateTagKey_Handler,
		},
		{
			MethodName: "UpdateTagKey",
			Handler:    _TagKeys_UpdateTagKey_Handler,
		},
		{
			MethodName: "DeleteTagKey",
			Handler:    _TagKeys_DeleteTagKey_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _TagKeys_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _TagKeys_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _TagKeys_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcemanager/v3/tag_keys.proto",
}
