// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/finding.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of the finding.
type Finding_State int32

const (
	// Unspecified state.
	Finding_STATE_UNSPECIFIED Finding_State = 0
	// The finding requires attention and has not been addressed yet.
	Finding_ACTIVE Finding_State = 1
	// The finding has been fixed, triaged as a non-issue or otherwise addressed
	// and is no longer active.
	Finding_INACTIVE Finding_State = 2
)

// Enum value maps for Finding_State.
var (
	Finding_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "INACTIVE",
	}
	Finding_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"INACTIVE":          2,
	}
)

func (x Finding_State) Enum() *Finding_State {
	p := new(Finding_State)
	*p = x
	return p
}

func (x Finding_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Finding_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_finding_proto_enumTypes[0].Descriptor()
}

func (Finding_State) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_finding_proto_enumTypes[0]
}

func (x Finding_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Finding_State.Descriptor instead.
func (Finding_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_finding_proto_rawDescGZIP(), []int{0, 0}
}

// The severity of the finding.
type Finding_Severity int32

const (
	// This value is used for findings when a source doesn't write a severity
	// value.
	Finding_SEVERITY_UNSPECIFIED Finding_Severity = 0
	// Vulnerability:
	// A critical vulnerability is easily discoverable by an external actor,
	// exploitable, and results in the direct ability to execute arbitrary code,
	// exfiltrate data, and otherwise gain additional access and privileges to
	// cloud resources and workloads. Examples include publicly accessible
	// unprotected user data and public SSH access with weak or no
	// passwords.
	//
	// Threat:
	// Indicates a threat that is able to access, modify, or delete data or
	// execute unauthorized code within existing resources.
	Finding_CRITICAL Finding_Severity = 1
	// Vulnerability:
	// A high risk vulnerability can be easily discovered and exploited in
	// combination with other vulnerabilities in order to gain direct access and
	// the ability to execute arbitrary code, exfiltrate data, and otherwise
	// gain additional access and privileges to cloud resources and workloads.
	// An example is a database with weak or no passwords that is only
	// accessible internally. This database could easily be compromised by an
	// actor that had access to the internal network.
	//
	// Threat:
	// Indicates a threat that is able to create new computational resources in
	// an environment but not able to access data or execute code in existing
	// resources.
	Finding_HIGH Finding_Severity = 2
	// Vulnerability:
	// A medium risk vulnerability could be used by an actor to gain access to
	// resources or privileges that enable them to eventually (through multiple
	// steps or a complex exploit) gain access and the ability to execute
	// arbitrary code or exfiltrate data. An example is a service account with
	// access to more projects than it should have. If an actor gains access to
	// the service account, they could potentially use that access to manipulate
	// a project the service account was not intended to.
	//
	// Threat:
	// Indicates a threat that is able to cause operational impact but may not
	// access data or execute unauthorized code.
	Finding_MEDIUM Finding_Severity = 3
	// Vulnerability:
	// A low risk vulnerability hampers a security organization's ability to
	// detect vulnerabilities or active threats in their deployment, or prevents
	// the root cause investigation of security issues. An example is monitoring
	// and logs being disabled for resource configurations and access.
	//
	// Threat:
	// Indicates a threat that has obtained minimal access to an environment but
	// is not able to access data, execute code, or create resources.
	Finding_LOW Finding_Severity = 4
)

// Enum value maps for Finding_Severity.
var (
	Finding_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "CRITICAL",
		2: "HIGH",
		3: "MEDIUM",
		4: "LOW",
	}
	Finding_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"CRITICAL":             1,
		"HIGH":                 2,
		"MEDIUM":               3,
		"LOW":                  4,
	}
)

func (x Finding_Severity) Enum() *Finding_Severity {
	p := new(Finding_Severity)
	*p = x
	return p
}

func (x Finding_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Finding_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_finding_proto_enumTypes[1].Descriptor()
}

func (Finding_Severity) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_finding_proto_enumTypes[1]
}

func (x Finding_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Finding_Severity.Descriptor instead.
func (Finding_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_finding_proto_rawDescGZIP(), []int{0, 1}
}

// Mute state a finding can be in.
type Finding_Mute int32

const (
	// Unspecified.
	Finding_MUTE_UNSPECIFIED Finding_Mute = 0
	// Finding has been muted.
	Finding_MUTED Finding_Mute = 1
	// Finding has been unmuted.
	Finding_UNMUTED Finding_Mute = 2
	// Finding has never been muted/unmuted.
	Finding_UNDEFINED Finding_Mute = 3
)

// Enum value maps for Finding_Mute.
var (
	Finding_Mute_name = map[int32]string{
		0: "MUTE_UNSPECIFIED",
		1: "MUTED",
		2: "UNMUTED",
		3: "UNDEFINED",
	}
	Finding_Mute_value = map[string]int32{
		"MUTE_UNSPECIFIED": 0,
		"MUTED":            1,
		"UNMUTED":          2,
		"UNDEFINED":        3,
	}
)

func (x Finding_Mute) Enum() *Finding_Mute {
	p := new(Finding_Mute)
	*p = x
	return p
}

func (x Finding_Mute) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Finding_Mute) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_finding_proto_enumTypes[2].Descriptor()
}

func (Finding_Mute) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_finding_proto_enumTypes[2]
}

func (x Finding_Mute) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Finding_Mute.Descriptor instead.
func (Finding_Mute) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_finding_proto_rawDescGZIP(), []int{0, 2}
}

// Represents what kind of Finding it is.
type Finding_FindingClass int32

const (
	// Unspecified finding class.
	Finding_FINDING_CLASS_UNSPECIFIED Finding_FindingClass = 0
	// Describes unwanted or malicious activity.
	Finding_THREAT Finding_FindingClass = 1
	// Describes a potential weakness in software that increases risk to
	// Confidentiality & Integrity & Availability.
	Finding_VULNERABILITY Finding_FindingClass = 2
	// Describes a potential weakness in cloud resource/asset configuration that
	// increases risk.
	Finding_MISCONFIGURATION Finding_FindingClass = 3
	// Describes a security observation that is for informational purposes.
	Finding_OBSERVATION Finding_FindingClass = 4
	// Describes an error that prevents some SCC functionality.
	Finding_SCC_ERROR Finding_FindingClass = 5
	// Describes a potential security risk due to a change in the security
	// posture.
	Finding_POSTURE_VIOLATION Finding_FindingClass = 6
	// Describes a combination of security issues that represent a more severe
	// security problem when taken together.
	Finding_TOXIC_COMBINATION Finding_FindingClass = 7
	// Describes a potential security risk to data assets that contain sensitive
	// data.
	Finding_SENSITIVE_DATA_RISK Finding_FindingClass = 8
)

// Enum value maps for Finding_FindingClass.
var (
	Finding_FindingClass_name = map[int32]string{
		0: "FINDING_CLASS_UNSPECIFIED",
		1: "THREAT",
		2: "VULNERABILITY",
		3: "MISCONFIGURATION",
		4: "OBSERVATION",
		5: "SCC_ERROR",
		6: "POSTURE_VIOLATION",
		7: "TOXIC_COMBINATION",
		8: "SENSITIVE_DATA_RISK",
	}
	Finding_FindingClass_value = map[string]int32{
		"FINDING_CLASS_UNSPECIFIED": 0,
		"THREAT":                    1,
		"VULNERABILITY":             2,
		"MISCONFIGURATION":          3,
		"OBSERVATION":               4,
		"SCC_ERROR":                 5,
		"POSTURE_VIOLATION":         6,
		"TOXIC_COMBINATION":         7,
		"SENSITIVE_DATA_RISK":       8,
	}
)

func (x Finding_FindingClass) Enum() *Finding_FindingClass {
	p := new(Finding_FindingClass)
	*p = x
	return p
}

func (x Finding_FindingClass) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Finding_FindingClass) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_finding_proto_enumTypes[3].Descriptor()
}

func (Finding_FindingClass) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_finding_proto_enumTypes[3]
}

func (x Finding_FindingClass) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Finding_FindingClass.Descriptor instead.
func (Finding_FindingClass) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_finding_proto_rawDescGZIP(), []int{0, 3}
}

// Security Command Center finding.
//
// A finding is a record of assessment data like security, risk, health, or
// privacy, that is ingested into Security Command Center for presentation,
// notification, analysis, policy testing, and enforcement. For example, a
// cross-site scripting (XSS) vulnerability in an App Engine application is a
// finding.
type Finding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [relative resource
	// name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// of the finding. The following list shows some examples:
	//
	// +
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `organizations/{organization_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	// + `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	// + `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `projects/{project_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The canonical name of the finding. The following list shows
	// some examples:
	//
	// +
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `organizations/{organization_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	// + `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	// + `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `projects/{project_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	//
	// The prefix is the closest CRM ancestor of the resource associated with the
	// finding.
	CanonicalName string `protobuf:"bytes,2,opt,name=canonical_name,json=canonicalName,proto3" json:"canonical_name,omitempty"`
	// The relative resource name of the source and location the finding belongs
	// to. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// This field is immutable after creation time. The following list shows some
	// examples:
	//
	// + `organizations/{organization_id}/sources/{source_id}`
	// + `folders/{folders_id}/sources/{source_id}`
	// + `projects/{projects_id}/sources/{source_id}`
	// +
	// `organizations/{organization_id}/sources/{source_id}/locations/{location_id}`
	// + `folders/{folders_id}/sources/{source_id}/locations/{location_id}`
	// + `projects/{projects_id}/sources/{source_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Immutable. For findings on Google Cloud resources, the full resource
	// name of the Google Cloud resource this finding is for. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// When the finding is for a non-Google Cloud resource, the resourceName can
	// be a customer or partner defined string.
	ResourceName string `protobuf:"bytes,4,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The state of the finding.
	State Finding_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.securitycenter.v2.Finding_State" json:"state,omitempty"`
	// Immutable. The additional taxonomy group within findings from a given
	// source. Example: "XSS_FLASH_INJECTION"
	Category string `protobuf:"bytes,7,opt,name=category,proto3" json:"category,omitempty"`
	// The URI that, if available, points to a web page outside of Security
	// Command Center where additional information about the finding can be found.
	// This field is guaranteed to be either empty or a well formed URL.
	ExternalUri string `protobuf:"bytes,8,opt,name=external_uri,json=externalUri,proto3" json:"external_uri,omitempty"`
	// Source specific properties. These properties are managed by the source
	// that writes the finding. The key names in the source_properties map must be
	// between 1 and 255 characters, and must start with a letter and contain
	// alphanumeric characters or underscores only.
	SourceProperties map[string]*structpb.Value `protobuf:"bytes,9,rep,name=source_properties,json=sourceProperties,proto3" json:"source_properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. User specified security marks. These marks are entirely
	// managed by the user and come from the SecurityMarks resource that belongs
	// to the finding.
	SecurityMarks *SecurityMarks `protobuf:"bytes,10,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The time the finding was first detected. If an existing finding is updated,
	// then this is the time the update occurred.
	// For example, if the finding represents an open firewall, this property
	// captures the time the detector believes the firewall became open. The
	// accuracy is determined by the detector. If the finding is later resolved,
	// then this time reflects when the finding was resolved. This must not
	// be set to a value greater than the current timestamp.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// Output only. The time at which the finding was created in Security Command
	// Center.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The severity of the finding. This field is managed by the source that
	// writes the finding.
	Severity Finding_Severity `protobuf:"varint,14,opt,name=severity,proto3,enum=google.cloud.securitycenter.v2.Finding_Severity" json:"severity,omitempty"`
	// Indicates the mute state of a finding (either muted, unmuted
	// or undefined). Unlike other attributes of a finding, a finding provider
	// shouldn't set the value of mute.
	Mute Finding_Mute `protobuf:"varint,15,opt,name=mute,proto3,enum=google.cloud.securitycenter.v2.Finding_Mute" json:"mute,omitempty"`
	// Output only. The mute information regarding this finding.
	MuteInfo *Finding_MuteInfo `protobuf:"bytes,53,opt,name=mute_info,json=muteInfo,proto3" json:"mute_info,omitempty"`
	// The class of the finding.
	FindingClass Finding_FindingClass `protobuf:"varint,16,opt,name=finding_class,json=findingClass,proto3,enum=google.cloud.securitycenter.v2.Finding_FindingClass" json:"finding_class,omitempty"`
	// Represents what's commonly known as an *indicator of compromise* (IoC) in
	// computer forensics. This is an artifact observed on a network or in an
	// operating system that, with high confidence, indicates a computer
	// intrusion. For more information, see [Indicator of
	// compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
	Indicator *Indicator `protobuf:"bytes,17,opt,name=indicator,proto3" json:"indicator,omitempty"`
	// Represents vulnerability-specific fields like CVE and CVSS scores.
	// CVE stands for Common Vulnerabilities and Exposures
	// (https://cve.mitre.org/about/)
	Vulnerability *Vulnerability `protobuf:"bytes,18,opt,name=vulnerability,proto3" json:"vulnerability,omitempty"`
	// Output only. The most recent time this finding was muted or unmuted.
	MuteUpdateTime *timestamppb.Timestamp `protobuf:"bytes,19,opt,name=mute_update_time,json=muteUpdateTime,proto3" json:"mute_update_time,omitempty"`
	// Output only. Third party SIEM/SOAR fields within SCC, contains external
	// system information and external system finding fields.
	ExternalSystems map[string]*ExternalSystem `protobuf:"bytes,20,rep,name=external_systems,json=externalSystems,proto3" json:"external_systems,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// MITRE ATT&CK tactics and techniques related to this finding.
	// See: https://attack.mitre.org
	MitreAttack *MitreAttack `protobuf:"bytes,21,opt,name=mitre_attack,json=mitreAttack,proto3" json:"mitre_attack,omitempty"`
	// Access details associated with the finding, such as more information on the
	// caller, which method was accessed, and from where.
	Access *Access `protobuf:"bytes,22,opt,name=access,proto3" json:"access,omitempty"`
	// Contains information about the IP connection associated with the finding.
	Connections []*Connection `protobuf:"bytes,23,rep,name=connections,proto3" json:"connections,omitempty"`
	// Records additional information about the mute operation, for example, the
	// [mute
	// configuration](https://cloud.google.com/security-command-center/docs/how-to-mute-findings)
	// that muted the finding and the user who muted the finding.
	MuteInitiator string `protobuf:"bytes,24,opt,name=mute_initiator,json=muteInitiator,proto3" json:"mute_initiator,omitempty"`
	// Represents operating system processes associated with the Finding.
	Processes []*Process `protobuf:"bytes,25,rep,name=processes,proto3" json:"processes,omitempty"`
	// Output only. Map containing the points of contact for the given finding.
	// The key represents the type of contact, while the value contains a list of
	// all the contacts that pertain. Please refer to:
	// https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
	//
	//	{
	//	  "security": {
	//	    "contacts": [
	//	      {
	//	        "email": "person1@company.com"
	//	      },
	//	      {
	//	        "email": "person2@company.com"
	//	      }
	//	    ]
	//	  }
	//	}
	Contacts map[string]*ContactDetails `protobuf:"bytes,26,rep,name=contacts,proto3" json:"contacts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Contains compliance information for security standards associated to the
	// finding.
	Compliances []*Compliance `protobuf:"bytes,27,rep,name=compliances,proto3" json:"compliances,omitempty"`
	// Output only. The human readable display name of the finding source such as
	// "Event Threat Detection" or "Security Health Analytics".
	ParentDisplayName string `protobuf:"bytes,29,opt,name=parent_display_name,json=parentDisplayName,proto3" json:"parent_display_name,omitempty"`
	// Contains more details about the finding.
	Description string `protobuf:"bytes,30,opt,name=description,proto3" json:"description,omitempty"`
	// Represents exfiltrations associated with the finding.
	Exfiltration *Exfiltration `protobuf:"bytes,31,opt,name=exfiltration,proto3" json:"exfiltration,omitempty"`
	// Represents IAM bindings associated with the finding.
	IamBindings []*IamBinding `protobuf:"bytes,32,rep,name=iam_bindings,json=iamBindings,proto3" json:"iam_bindings,omitempty"`
	// Steps to address the finding.
	NextSteps string `protobuf:"bytes,33,opt,name=next_steps,json=nextSteps,proto3" json:"next_steps,omitempty"`
	// Unique identifier of the module which generated the finding.
	// Example:
	// folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
	ModuleName string `protobuf:"bytes,34,opt,name=module_name,json=moduleName,proto3" json:"module_name,omitempty"`
	// Containers associated with the finding. This field provides information for
	// both Kubernetes and non-Kubernetes containers.
	Containers []*Container `protobuf:"bytes,35,rep,name=containers,proto3" json:"containers,omitempty"`
	// Kubernetes resources associated with the finding.
	Kubernetes *Kubernetes `protobuf:"bytes,36,opt,name=kubernetes,proto3" json:"kubernetes,omitempty"`
	// Database associated with the finding.
	Database *Database `protobuf:"bytes,37,opt,name=database,proto3" json:"database,omitempty"`
	// The results of an attack path simulation relevant to this finding.
	AttackExposure *AttackExposure `protobuf:"bytes,38,opt,name=attack_exposure,json=attackExposure,proto3" json:"attack_exposure,omitempty"`
	// File associated with the finding.
	Files []*File `protobuf:"bytes,39,rep,name=files,proto3" json:"files,omitempty"`
	// Cloud Data Loss Prevention (Cloud DLP) inspection results that are
	// associated with the finding.
	CloudDlpInspection *CloudDlpInspection `protobuf:"bytes,40,opt,name=cloud_dlp_inspection,json=cloudDlpInspection,proto3" json:"cloud_dlp_inspection,omitempty"`
	// Cloud DLP data profile that is associated with the finding.
	CloudDlpDataProfile *CloudDlpDataProfile `protobuf:"bytes,41,opt,name=cloud_dlp_data_profile,json=cloudDlpDataProfile,proto3" json:"cloud_dlp_data_profile,omitempty"`
	// Signature of the kernel rootkit.
	KernelRootkit *KernelRootkit `protobuf:"bytes,42,opt,name=kernel_rootkit,json=kernelRootkit,proto3" json:"kernel_rootkit,omitempty"`
	// Contains information about the org policies associated with the finding.
	OrgPolicies []*OrgPolicy `protobuf:"bytes,43,rep,name=org_policies,json=orgPolicies,proto3" json:"org_policies,omitempty"`
	// Represents an application associated with the finding.
	Application *Application `protobuf:"bytes,45,opt,name=application,proto3" json:"application,omitempty"`
	// Fields related to Backup and DR findings.
	BackupDisasterRecovery *BackupDisasterRecovery `protobuf:"bytes,47,opt,name=backup_disaster_recovery,json=backupDisasterRecovery,proto3" json:"backup_disaster_recovery,omitempty"`
	// The security posture associated with the finding.
	SecurityPosture *SecurityPosture `protobuf:"bytes,48,opt,name=security_posture,json=securityPosture,proto3" json:"security_posture,omitempty"`
	// Log entries that are relevant to the finding.
	LogEntries []*LogEntry `protobuf:"bytes,49,rep,name=log_entries,json=logEntries,proto3" json:"log_entries,omitempty"`
	// The load balancers associated with the finding.
	LoadBalancers []*LoadBalancer `protobuf:"bytes,50,rep,name=load_balancers,json=loadBalancers,proto3" json:"load_balancers,omitempty"`
	// Fields related to Cloud Armor findings.
	CloudArmor *CloudArmor `protobuf:"bytes,51,opt,name=cloud_armor,json=cloudArmor,proto3" json:"cloud_armor,omitempty"`
	// Notebook associated with the finding.
	Notebook *Notebook `protobuf:"bytes,55,opt,name=notebook,proto3" json:"notebook,omitempty"`
	// Contains details about a group of security issues that, when the issues
	// occur together, represent a greater risk than when the issues occur
	// independently. A group of such issues is referred to as a toxic
	// combination.
	// This field cannot be updated. Its value is ignored in all update requests.
	ToxicCombination *ToxicCombination `protobuf:"bytes,56,opt,name=toxic_combination,json=toxicCombination,proto3" json:"toxic_combination,omitempty"`
	// Contains details about groups of which this finding is a member. A group is
	// a collection of findings that are related in some way.
	// This field cannot be updated. Its value is ignored in all update requests.
	GroupMemberships []*GroupMembership `protobuf:"bytes,57,rep,name=group_memberships,json=groupMemberships,proto3" json:"group_memberships,omitempty"`
	// Disk associated with the finding.
	Disk *Disk `protobuf:"bytes,58,opt,name=disk,proto3" json:"disk,omitempty"`
	// Data access events associated with the finding.
	DataAccessEvents []*DataAccessEvent `protobuf:"bytes,61,rep,name=data_access_events,json=dataAccessEvents,proto3" json:"data_access_events,omitempty"`
	// Data flow events associated with the finding.
	DataFlowEvents []*DataFlowEvent `protobuf:"bytes,62,rep,name=data_flow_events,json=dataFlowEvents,proto3" json:"data_flow_events,omitempty"`
	// Data retention deletion events associated with the finding.
	DataRetentionDeletionEvents []*DataRetentionDeletionEvent `protobuf:"bytes,64,rep,name=data_retention_deletion_events,json=dataRetentionDeletionEvents,proto3" json:"data_retention_deletion_events,omitempty"`
}

func (x *Finding) Reset() {
	*x = Finding{}
	mi := &file_google_cloud_securitycenter_v2_finding_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Finding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Finding) ProtoMessage() {}

func (x *Finding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_finding_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Finding.ProtoReflect.Descriptor instead.
func (*Finding) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_finding_proto_rawDescGZIP(), []int{0}
}

func (x *Finding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Finding) GetCanonicalName() string {
	if x != nil {
		return x.CanonicalName
	}
	return ""
}

func (x *Finding) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *Finding) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Finding) GetState() Finding_State {
	if x != nil {
		return x.State
	}
	return Finding_STATE_UNSPECIFIED
}

func (x *Finding) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *Finding) GetExternalUri() string {
	if x != nil {
		return x.ExternalUri
	}
	return ""
}

func (x *Finding) GetSourceProperties() map[string]*structpb.Value {
	if x != nil {
		return x.SourceProperties
	}
	return nil
}

func (x *Finding) GetSecurityMarks() *SecurityMarks {
	if x != nil {
		return x.SecurityMarks
	}
	return nil
}

func (x *Finding) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *Finding) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Finding) GetSeverity() Finding_Severity {
	if x != nil {
		return x.Severity
	}
	return Finding_SEVERITY_UNSPECIFIED
}

func (x *Finding) GetMute() Finding_Mute {
	if x != nil {
		return x.Mute
	}
	return Finding_MUTE_UNSPECIFIED
}

func (x *Finding) GetMuteInfo() *Finding_MuteInfo {
	if x != nil {
		return x.MuteInfo
	}
	return nil
}

func (x *Finding) GetFindingClass() Finding_FindingClass {
	if x != nil {
		return x.FindingClass
	}
	return Finding_FINDING_CLASS_UNSPECIFIED
}

func (x *Finding) GetIndicator() *Indicator {
	if x != nil {
		return x.Indicator
	}
	return nil
}

func (x *Finding) GetVulnerability() *Vulnerability {
	if x != nil {
		return x.Vulnerability
	}
	return nil
}

func (x *Finding) GetMuteUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MuteUpdateTime
	}
	return nil
}

func (x *Finding) GetExternalSystems() map[string]*ExternalSystem {
	if x != nil {
		return x.ExternalSystems
	}
	return nil
}

func (x *Finding) GetMitreAttack() *MitreAttack {
	if x != nil {
		return x.MitreAttack
	}
	return nil
}

func (x *Finding) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *Finding) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

func (x *Finding) GetMuteInitiator() string {
	if x != nil {
		return x.MuteInitiator
	}
	return ""
}

func (x *Finding) GetProcesses() []*Process {
	if x != nil {
		return x.Processes
	}
	return nil
}

func (x *Finding) GetContacts() map[string]*ContactDetails {
	if x != nil {
		return x.Contacts
	}
	return nil
}

func (x *Finding) GetCompliances() []*Compliance {
	if x != nil {
		return x.Compliances
	}
	return nil
}

func (x *Finding) GetParentDisplayName() string {
	if x != nil {
		return x.ParentDisplayName
	}
	return ""
}

func (x *Finding) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Finding) GetExfiltration() *Exfiltration {
	if x != nil {
		return x.Exfiltration
	}
	return nil
}

func (x *Finding) GetIamBindings() []*IamBinding {
	if x != nil {
		return x.IamBindings
	}
	return nil
}

func (x *Finding) GetNextSteps() string {
	if x != nil {
		return x.NextSteps
	}
	return ""
}

func (x *Finding) GetModuleName() string {
	if x != nil {
		return x.ModuleName
	}
	return ""
}

func (x *Finding) GetContainers() []*Container {
	if x != nil {
		return x.Containers
	}
	return nil
}

func (x *Finding) GetKubernetes() *Kubernetes {
	if x != nil {
		return x.Kubernetes
	}
	return nil
}

func (x *Finding) GetDatabase() *Database {
	if x != nil {
		return x.Database
	}
	return nil
}

func (x *Finding) GetAttackExposure() *AttackExposure {
	if x != nil {
		return x.AttackExposure
	}
	return nil
}

func (x *Finding) GetFiles() []*File {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *Finding) GetCloudDlpInspection() *CloudDlpInspection {
	if x != nil {
		return x.CloudDlpInspection
	}
	return nil
}

func (x *Finding) GetCloudDlpDataProfile() *CloudDlpDataProfile {
	if x != nil {
		return x.CloudDlpDataProfile
	}
	return nil
}

func (x *Finding) GetKernelRootkit() *KernelRootkit {
	if x != nil {
		return x.KernelRootkit
	}
	return nil
}

func (x *Finding) GetOrgPolicies() []*OrgPolicy {
	if x != nil {
		return x.OrgPolicies
	}
	return nil
}

func (x *Finding) GetApplication() *Application {
	if x != nil {
		return x.Application
	}
	return nil
}

func (x *Finding) GetBackupDisasterRecovery() *BackupDisasterRecovery {
	if x != nil {
		return x.BackupDisasterRecovery
	}
	return nil
}

func (x *Finding) GetSecurityPosture() *SecurityPosture {
	if x != nil {
		return x.SecurityPosture
	}
	return nil
}

func (x *Finding) GetLogEntries() []*LogEntry {
	if x != nil {
		return x.LogEntries
	}
	return nil
}

func (x *Finding) GetLoadBalancers() []*LoadBalancer {
	if x != nil {
		return x.LoadBalancers
	}
	return nil
}

func (x *Finding) GetCloudArmor() *CloudArmor {
	if x != nil {
		return x.CloudArmor
	}
	return nil
}

func (x *Finding) GetNotebook() *Notebook {
	if x != nil {
		return x.Notebook
	}
	return nil
}

func (x *Finding) GetToxicCombination() *ToxicCombination {
	if x != nil {
		return x.ToxicCombination
	}
	return nil
}

func (x *Finding) GetGroupMemberships() []*GroupMembership {
	if x != nil {
		return x.GroupMemberships
	}
	return nil
}

func (x *Finding) GetDisk() *Disk {
	if x != nil {
		return x.Disk
	}
	return nil
}

func (x *Finding) GetDataAccessEvents() []*DataAccessEvent {
	if x != nil {
		return x.DataAccessEvents
	}
	return nil
}

func (x *Finding) GetDataFlowEvents() []*DataFlowEvent {
	if x != nil {
		return x.DataFlowEvents
	}
	return nil
}

func (x *Finding) GetDataRetentionDeletionEvents() []*DataRetentionDeletionEvent {
	if x != nil {
		return x.DataRetentionDeletionEvents
	}
	return nil
}

// Mute information about the finding, including whether the finding has a
// static mute or any matching dynamic mute rules.
type Finding_MuteInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set, the static mute applied to this finding. Static mutes override
	// dynamic mutes. If unset, there is no static mute.
	StaticMute *Finding_MuteInfo_StaticMute `protobuf:"bytes,1,opt,name=static_mute,json=staticMute,proto3" json:"static_mute,omitempty"`
	// The list of dynamic mute rules that currently match the finding.
	DynamicMuteRecords []*Finding_MuteInfo_DynamicMuteRecord `protobuf:"bytes,2,rep,name=dynamic_mute_records,json=dynamicMuteRecords,proto3" json:"dynamic_mute_records,omitempty"`
}

func (x *Finding_MuteInfo) Reset() {
	*x = Finding_MuteInfo{}
	mi := &file_google_cloud_securitycenter_v2_finding_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Finding_MuteInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Finding_MuteInfo) ProtoMessage() {}

func (x *Finding_MuteInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_finding_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Finding_MuteInfo.ProtoReflect.Descriptor instead.
func (*Finding_MuteInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_finding_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Finding_MuteInfo) GetStaticMute() *Finding_MuteInfo_StaticMute {
	if x != nil {
		return x.StaticMute
	}
	return nil
}

func (x *Finding_MuteInfo) GetDynamicMuteRecords() []*Finding_MuteInfo_DynamicMuteRecord {
	if x != nil {
		return x.DynamicMuteRecords
	}
	return nil
}

// Information about the static mute state. A static mute state overrides
// any dynamic mute rules that apply to this finding. The static mute state
// can be set by a static mute rule or by muting the finding directly.
type Finding_MuteInfo_StaticMute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The static mute state. If the value is `MUTED` or `UNMUTED`, then the
	// finding's overall mute state will have the same value.
	State Finding_Mute `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.securitycenter.v2.Finding_Mute" json:"state,omitempty"`
	// When the static mute was applied.
	ApplyTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=apply_time,json=applyTime,proto3" json:"apply_time,omitempty"`
}

func (x *Finding_MuteInfo_StaticMute) Reset() {
	*x = Finding_MuteInfo_StaticMute{}
	mi := &file_google_cloud_securitycenter_v2_finding_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Finding_MuteInfo_StaticMute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Finding_MuteInfo_StaticMute) ProtoMessage() {}

func (x *Finding_MuteInfo_StaticMute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_finding_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Finding_MuteInfo_StaticMute.ProtoReflect.Descriptor instead.
func (*Finding_MuteInfo_StaticMute) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_finding_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Finding_MuteInfo_StaticMute) GetState() Finding_Mute {
	if x != nil {
		return x.State
	}
	return Finding_MUTE_UNSPECIFIED
}

func (x *Finding_MuteInfo_StaticMute) GetApplyTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ApplyTime
	}
	return nil
}

// The record of a dynamic mute rule that matches the finding.
type Finding_MuteInfo_DynamicMuteRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The relative resource name of the mute rule, represented by a mute
	// config, that created this record, for example
	// `organizations/123/muteConfigs/mymuteconfig` or
	// `organizations/123/locations/global/muteConfigs/mymuteconfig`.
	MuteConfig string `protobuf:"bytes,1,opt,name=mute_config,json=muteConfig,proto3" json:"mute_config,omitempty"`
	// When the dynamic mute rule first matched the finding.
	MatchTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=match_time,json=matchTime,proto3" json:"match_time,omitempty"`
}

func (x *Finding_MuteInfo_DynamicMuteRecord) Reset() {
	*x = Finding_MuteInfo_DynamicMuteRecord{}
	mi := &file_google_cloud_securitycenter_v2_finding_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Finding_MuteInfo_DynamicMuteRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Finding_MuteInfo_DynamicMuteRecord) ProtoMessage() {}

func (x *Finding_MuteInfo_DynamicMuteRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_finding_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Finding_MuteInfo_DynamicMuteRecord.ProtoReflect.Descriptor instead.
func (*Finding_MuteInfo_DynamicMuteRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_finding_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *Finding_MuteInfo_DynamicMuteRecord) GetMuteConfig() string {
	if x != nil {
		return x.MuteConfig
	}
	return ""
}

func (x *Finding_MuteInfo_DynamicMuteRecord) GetMatchTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MatchTime
	}
	return nil
}

var File_google_cloud_securitycenter_v2_finding_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_finding_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b,
	0x5f, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x6c, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x5f, 0x64, 0x6c, 0x70, 0x5f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x6c,
	0x6f, 0x77, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f,
	0x76, 0x32, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x32, 0x2f, 0x64, 0x69, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x78, 0x66,
	0x69, 0x6c, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x62, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61,
	0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c,
	0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x6b, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x6b,
	0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2f, 0x76, 0x32, 0x2f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2f, 0x76, 0x32, 0x2f, 0x6d, 0x69, 0x74, 0x72, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x6f, 0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61,
	0x72, 0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x74, 0x6f, 0x78, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9f, 0x2c, 0x0a, 0x07,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x63,
	0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x69, 0x12, 0x6a, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x6d, 0x61, 0x72, 0x6b, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x12, 0x39,
	0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x08, 0x73,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52,
	0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x40, 0x0a, 0x04, 0x6d, 0x75, 0x74,
	0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x2e, 0x4d, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x12, 0x52, 0x0a, 0x09, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x35, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x59, 0x0a, 0x0d, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x0c, 0x66, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x47, 0x0a, 0x09, 0x69, 0x6e,
	0x64, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61,
	0x74, 0x6f, 0x72, 0x12, 0x53, 0x0a, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x75, 0x6c, 0x6e,
	0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65,
	0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x49, 0x0a, 0x10, 0x6d, 0x75, 0x74, 0x65,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6d, 0x75, 0x74, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x6c, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x73, 0x12, 0x4e, 0x0a, 0x0c, 0x6d, 0x69, 0x74, 0x72, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x6b, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x69, 0x74, 0x72, 0x65, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x6b, 0x52, 0x0b, 0x6d, 0x69, 0x74, 0x72, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x6b, 0x12, 0x3e, 0x0a, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x25, 0x0a, 0x0e, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x6f,
	0x72, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6d, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x45, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x56, 0x0a,
	0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0c, 0x65, 0x78,
	0x66, 0x69, 0x6c, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x45, 0x78, 0x66, 0x69, 0x6c, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c,
	0x65, 0x78, 0x66, 0x69, 0x6c, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x0c,
	0x69, 0x61, 0x6d, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x20, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x61, 0x6d, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0b,
	0x69, 0x61, 0x6d, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x21, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x74, 0x65, 0x70, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x22, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x0a, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x23, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x4a, 0x0a, 0x0a, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x12, 0x44, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x25,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x08,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x6b, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x18, 0x26, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72,
	0x65, 0x52, 0x0e, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72,
	0x65, 0x12, 0x3a, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x27, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x64, 0x0a,
	0x14, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x6c, 0x70, 0x5f, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x44, 0x6c, 0x70, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x12, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x6c, 0x70, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x16, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x6c, 0x70,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x29, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x6c, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x13, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x44,
	0x6c, 0x70, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x54, 0x0a,
	0x0e, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x6b, 0x69, 0x74, 0x18,
	0x2a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x52, 0x6f, 0x6f,
	0x74, 0x6b, 0x69, 0x74, 0x52, 0x0d, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x52, 0x6f, 0x6f, 0x74,
	0x6b, 0x69, 0x74, 0x12, 0x4c, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x18, 0x2b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x72, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x0b, 0x6f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x12, 0x4d, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x70, 0x0a, 0x18, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x2f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x69, 0x73, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x16, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x44, 0x69, 0x73, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x12, 0x5a, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x18, 0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x0f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x12, 0x49,
	0x0a, 0x0b, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x31, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x6c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0e, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x73, 0x18, 0x32, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x52,
	0x0d, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x73, 0x12, 0x4b,
	0x0a, 0x0b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x18, 0x33, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x41, 0x72, 0x6d, 0x6f, 0x72, 0x52,
	0x0a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x41, 0x72, 0x6d, 0x6f, 0x72, 0x12, 0x44, 0x0a, 0x08, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x37, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x08, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x12, 0x5d, 0x0a, 0x11, 0x74, 0x6f, 0x78, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x38, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x6f,
	0x78, 0x69, 0x63, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x74, 0x6f, 0x78, 0x69, 0x63, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x5c, 0x0a, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x73, 0x18, 0x39, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x10, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x12, 0x38,
	0x0a, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x3a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69,
	0x73, 0x6b, 0x52, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x12, 0x5d, 0x0a, 0x12, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x3d,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x57, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x3e, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6c, 0x6f, 0x77, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x46, 0x6c, 0x6f, 0x77, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x7f, 0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x40, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x52, 0x1b, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x1a, 0xdd, 0x03, 0x0a, 0x08, 0x4d, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5c,
	0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x6d, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x75, 0x74,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x4d, 0x75, 0x74, 0x65,
	0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x4d, 0x75, 0x74, 0x65, 0x12, 0x74, 0x0a, 0x14,
	0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x44, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x4d, 0x75, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x12,
	0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x75, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x73, 0x1a, 0x8b, 0x01, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x4d, 0x75, 0x74,
	0x65, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x54, 0x69, 0x6d, 0x65,
	0x1a, 0x6f, 0x0a, 0x11, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x0a, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x69, 0x6d,
	0x65, 0x1a, 0x5b, 0x0a, 0x15, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x72,
	0x0a, 0x14, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x44, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x6b, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x44, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x38, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x49,
	0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x22, 0x51, 0x0a, 0x08, 0x53, 0x65, 0x76,
	0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x52, 0x49, 0x54, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55,
	0x4d, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x04, 0x22, 0x43, 0x0a, 0x04,
	0x4d, 0x75, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x55, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x55,
	0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4d, 0x55, 0x54, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10,
	0x03, 0x22, 0xc9, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4c,
	0x41, 0x53, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x48, 0x52, 0x45, 0x41, 0x54, 0x10, 0x01, 0x12, 0x11, 0x0a,
	0x0d, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x02,
	0x12, 0x14, 0x0a, 0x10, 0x4d, 0x49, 0x53, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x4f, 0x42, 0x53, 0x45, 0x52, 0x56,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43, 0x43, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x4f, 0x53, 0x54, 0x55, 0x52,
	0x45, 0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x15, 0x0a,
	0x11, 0x54, 0x4f, 0x58, 0x49, 0x43, 0x5f, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x07, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56,
	0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x49, 0x53, 0x4b, 0x10, 0x08, 0x3a, 0xdd, 0x03,
	0xea, 0x41, 0xd9, 0x03, 0x0a, 0x25, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0x55, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x7d, 0x12, 0x34, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0x49, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0x4b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x2a, 0x08, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x32, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0xe6, 0x01,
	0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x42, 0x0c, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62,
	0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56,
	0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c,
	0x56, 0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_finding_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_finding_proto_rawDescData = file_google_cloud_securitycenter_v2_finding_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_finding_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_finding_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_finding_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_finding_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_finding_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_finding_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_securitycenter_v2_finding_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_securitycenter_v2_finding_proto_goTypes = []any{
	(Finding_State)(0),                  // 0: google.cloud.securitycenter.v2.Finding.State
	(Finding_Severity)(0),               // 1: google.cloud.securitycenter.v2.Finding.Severity
	(Finding_Mute)(0),                   // 2: google.cloud.securitycenter.v2.Finding.Mute
	(Finding_FindingClass)(0),           // 3: google.cloud.securitycenter.v2.Finding.FindingClass
	(*Finding)(nil),                     // 4: google.cloud.securitycenter.v2.Finding
	(*Finding_MuteInfo)(nil),            // 5: google.cloud.securitycenter.v2.Finding.MuteInfo
	nil,                                 // 6: google.cloud.securitycenter.v2.Finding.SourcePropertiesEntry
	nil,                                 // 7: google.cloud.securitycenter.v2.Finding.ExternalSystemsEntry
	nil,                                 // 8: google.cloud.securitycenter.v2.Finding.ContactsEntry
	(*Finding_MuteInfo_StaticMute)(nil), // 9: google.cloud.securitycenter.v2.Finding.MuteInfo.StaticMute
	(*Finding_MuteInfo_DynamicMuteRecord)(nil), // 10: google.cloud.securitycenter.v2.Finding.MuteInfo.DynamicMuteRecord
	(*SecurityMarks)(nil),                      // 11: google.cloud.securitycenter.v2.SecurityMarks
	(*timestamppb.Timestamp)(nil),              // 12: google.protobuf.Timestamp
	(*Indicator)(nil),                          // 13: google.cloud.securitycenter.v2.Indicator
	(*Vulnerability)(nil),                      // 14: google.cloud.securitycenter.v2.Vulnerability
	(*MitreAttack)(nil),                        // 15: google.cloud.securitycenter.v2.MitreAttack
	(*Access)(nil),                             // 16: google.cloud.securitycenter.v2.Access
	(*Connection)(nil),                         // 17: google.cloud.securitycenter.v2.Connection
	(*Process)(nil),                            // 18: google.cloud.securitycenter.v2.Process
	(*Compliance)(nil),                         // 19: google.cloud.securitycenter.v2.Compliance
	(*Exfiltration)(nil),                       // 20: google.cloud.securitycenter.v2.Exfiltration
	(*IamBinding)(nil),                         // 21: google.cloud.securitycenter.v2.IamBinding
	(*Container)(nil),                          // 22: google.cloud.securitycenter.v2.Container
	(*Kubernetes)(nil),                         // 23: google.cloud.securitycenter.v2.Kubernetes
	(*Database)(nil),                           // 24: google.cloud.securitycenter.v2.Database
	(*AttackExposure)(nil),                     // 25: google.cloud.securitycenter.v2.AttackExposure
	(*File)(nil),                               // 26: google.cloud.securitycenter.v2.File
	(*CloudDlpInspection)(nil),                 // 27: google.cloud.securitycenter.v2.CloudDlpInspection
	(*CloudDlpDataProfile)(nil),                // 28: google.cloud.securitycenter.v2.CloudDlpDataProfile
	(*KernelRootkit)(nil),                      // 29: google.cloud.securitycenter.v2.KernelRootkit
	(*OrgPolicy)(nil),                          // 30: google.cloud.securitycenter.v2.OrgPolicy
	(*Application)(nil),                        // 31: google.cloud.securitycenter.v2.Application
	(*BackupDisasterRecovery)(nil),             // 32: google.cloud.securitycenter.v2.BackupDisasterRecovery
	(*SecurityPosture)(nil),                    // 33: google.cloud.securitycenter.v2.SecurityPosture
	(*LogEntry)(nil),                           // 34: google.cloud.securitycenter.v2.LogEntry
	(*LoadBalancer)(nil),                       // 35: google.cloud.securitycenter.v2.LoadBalancer
	(*CloudArmor)(nil),                         // 36: google.cloud.securitycenter.v2.CloudArmor
	(*Notebook)(nil),                           // 37: google.cloud.securitycenter.v2.Notebook
	(*ToxicCombination)(nil),                   // 38: google.cloud.securitycenter.v2.ToxicCombination
	(*GroupMembership)(nil),                    // 39: google.cloud.securitycenter.v2.GroupMembership
	(*Disk)(nil),                               // 40: google.cloud.securitycenter.v2.Disk
	(*DataAccessEvent)(nil),                    // 41: google.cloud.securitycenter.v2.DataAccessEvent
	(*DataFlowEvent)(nil),                      // 42: google.cloud.securitycenter.v2.DataFlowEvent
	(*DataRetentionDeletionEvent)(nil),         // 43: google.cloud.securitycenter.v2.DataRetentionDeletionEvent
	(*structpb.Value)(nil),                     // 44: google.protobuf.Value
	(*ExternalSystem)(nil),                     // 45: google.cloud.securitycenter.v2.ExternalSystem
	(*ContactDetails)(nil),                     // 46: google.cloud.securitycenter.v2.ContactDetails
}
var file_google_cloud_securitycenter_v2_finding_proto_depIdxs = []int32{
	0,  // 0: google.cloud.securitycenter.v2.Finding.state:type_name -> google.cloud.securitycenter.v2.Finding.State
	6,  // 1: google.cloud.securitycenter.v2.Finding.source_properties:type_name -> google.cloud.securitycenter.v2.Finding.SourcePropertiesEntry
	11, // 2: google.cloud.securitycenter.v2.Finding.security_marks:type_name -> google.cloud.securitycenter.v2.SecurityMarks
	12, // 3: google.cloud.securitycenter.v2.Finding.event_time:type_name -> google.protobuf.Timestamp
	12, // 4: google.cloud.securitycenter.v2.Finding.create_time:type_name -> google.protobuf.Timestamp
	1,  // 5: google.cloud.securitycenter.v2.Finding.severity:type_name -> google.cloud.securitycenter.v2.Finding.Severity
	2,  // 6: google.cloud.securitycenter.v2.Finding.mute:type_name -> google.cloud.securitycenter.v2.Finding.Mute
	5,  // 7: google.cloud.securitycenter.v2.Finding.mute_info:type_name -> google.cloud.securitycenter.v2.Finding.MuteInfo
	3,  // 8: google.cloud.securitycenter.v2.Finding.finding_class:type_name -> google.cloud.securitycenter.v2.Finding.FindingClass
	13, // 9: google.cloud.securitycenter.v2.Finding.indicator:type_name -> google.cloud.securitycenter.v2.Indicator
	14, // 10: google.cloud.securitycenter.v2.Finding.vulnerability:type_name -> google.cloud.securitycenter.v2.Vulnerability
	12, // 11: google.cloud.securitycenter.v2.Finding.mute_update_time:type_name -> google.protobuf.Timestamp
	7,  // 12: google.cloud.securitycenter.v2.Finding.external_systems:type_name -> google.cloud.securitycenter.v2.Finding.ExternalSystemsEntry
	15, // 13: google.cloud.securitycenter.v2.Finding.mitre_attack:type_name -> google.cloud.securitycenter.v2.MitreAttack
	16, // 14: google.cloud.securitycenter.v2.Finding.access:type_name -> google.cloud.securitycenter.v2.Access
	17, // 15: google.cloud.securitycenter.v2.Finding.connections:type_name -> google.cloud.securitycenter.v2.Connection
	18, // 16: google.cloud.securitycenter.v2.Finding.processes:type_name -> google.cloud.securitycenter.v2.Process
	8,  // 17: google.cloud.securitycenter.v2.Finding.contacts:type_name -> google.cloud.securitycenter.v2.Finding.ContactsEntry
	19, // 18: google.cloud.securitycenter.v2.Finding.compliances:type_name -> google.cloud.securitycenter.v2.Compliance
	20, // 19: google.cloud.securitycenter.v2.Finding.exfiltration:type_name -> google.cloud.securitycenter.v2.Exfiltration
	21, // 20: google.cloud.securitycenter.v2.Finding.iam_bindings:type_name -> google.cloud.securitycenter.v2.IamBinding
	22, // 21: google.cloud.securitycenter.v2.Finding.containers:type_name -> google.cloud.securitycenter.v2.Container
	23, // 22: google.cloud.securitycenter.v2.Finding.kubernetes:type_name -> google.cloud.securitycenter.v2.Kubernetes
	24, // 23: google.cloud.securitycenter.v2.Finding.database:type_name -> google.cloud.securitycenter.v2.Database
	25, // 24: google.cloud.securitycenter.v2.Finding.attack_exposure:type_name -> google.cloud.securitycenter.v2.AttackExposure
	26, // 25: google.cloud.securitycenter.v2.Finding.files:type_name -> google.cloud.securitycenter.v2.File
	27, // 26: google.cloud.securitycenter.v2.Finding.cloud_dlp_inspection:type_name -> google.cloud.securitycenter.v2.CloudDlpInspection
	28, // 27: google.cloud.securitycenter.v2.Finding.cloud_dlp_data_profile:type_name -> google.cloud.securitycenter.v2.CloudDlpDataProfile
	29, // 28: google.cloud.securitycenter.v2.Finding.kernel_rootkit:type_name -> google.cloud.securitycenter.v2.KernelRootkit
	30, // 29: google.cloud.securitycenter.v2.Finding.org_policies:type_name -> google.cloud.securitycenter.v2.OrgPolicy
	31, // 30: google.cloud.securitycenter.v2.Finding.application:type_name -> google.cloud.securitycenter.v2.Application
	32, // 31: google.cloud.securitycenter.v2.Finding.backup_disaster_recovery:type_name -> google.cloud.securitycenter.v2.BackupDisasterRecovery
	33, // 32: google.cloud.securitycenter.v2.Finding.security_posture:type_name -> google.cloud.securitycenter.v2.SecurityPosture
	34, // 33: google.cloud.securitycenter.v2.Finding.log_entries:type_name -> google.cloud.securitycenter.v2.LogEntry
	35, // 34: google.cloud.securitycenter.v2.Finding.load_balancers:type_name -> google.cloud.securitycenter.v2.LoadBalancer
	36, // 35: google.cloud.securitycenter.v2.Finding.cloud_armor:type_name -> google.cloud.securitycenter.v2.CloudArmor
	37, // 36: google.cloud.securitycenter.v2.Finding.notebook:type_name -> google.cloud.securitycenter.v2.Notebook
	38, // 37: google.cloud.securitycenter.v2.Finding.toxic_combination:type_name -> google.cloud.securitycenter.v2.ToxicCombination
	39, // 38: google.cloud.securitycenter.v2.Finding.group_memberships:type_name -> google.cloud.securitycenter.v2.GroupMembership
	40, // 39: google.cloud.securitycenter.v2.Finding.disk:type_name -> google.cloud.securitycenter.v2.Disk
	41, // 40: google.cloud.securitycenter.v2.Finding.data_access_events:type_name -> google.cloud.securitycenter.v2.DataAccessEvent
	42, // 41: google.cloud.securitycenter.v2.Finding.data_flow_events:type_name -> google.cloud.securitycenter.v2.DataFlowEvent
	43, // 42: google.cloud.securitycenter.v2.Finding.data_retention_deletion_events:type_name -> google.cloud.securitycenter.v2.DataRetentionDeletionEvent
	9,  // 43: google.cloud.securitycenter.v2.Finding.MuteInfo.static_mute:type_name -> google.cloud.securitycenter.v2.Finding.MuteInfo.StaticMute
	10, // 44: google.cloud.securitycenter.v2.Finding.MuteInfo.dynamic_mute_records:type_name -> google.cloud.securitycenter.v2.Finding.MuteInfo.DynamicMuteRecord
	44, // 45: google.cloud.securitycenter.v2.Finding.SourcePropertiesEntry.value:type_name -> google.protobuf.Value
	45, // 46: google.cloud.securitycenter.v2.Finding.ExternalSystemsEntry.value:type_name -> google.cloud.securitycenter.v2.ExternalSystem
	46, // 47: google.cloud.securitycenter.v2.Finding.ContactsEntry.value:type_name -> google.cloud.securitycenter.v2.ContactDetails
	2,  // 48: google.cloud.securitycenter.v2.Finding.MuteInfo.StaticMute.state:type_name -> google.cloud.securitycenter.v2.Finding.Mute
	12, // 49: google.cloud.securitycenter.v2.Finding.MuteInfo.StaticMute.apply_time:type_name -> google.protobuf.Timestamp
	12, // 50: google.cloud.securitycenter.v2.Finding.MuteInfo.DynamicMuteRecord.match_time:type_name -> google.protobuf.Timestamp
	51, // [51:51] is the sub-list for method output_type
	51, // [51:51] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_finding_proto_init() }
func file_google_cloud_securitycenter_v2_finding_proto_init() {
	if File_google_cloud_securitycenter_v2_finding_proto != nil {
		return
	}
	file_google_cloud_securitycenter_v2_access_proto_init()
	file_google_cloud_securitycenter_v2_application_proto_init()
	file_google_cloud_securitycenter_v2_attack_exposure_proto_init()
	file_google_cloud_securitycenter_v2_backup_disaster_recovery_proto_init()
	file_google_cloud_securitycenter_v2_cloud_armor_proto_init()
	file_google_cloud_securitycenter_v2_cloud_dlp_data_profile_proto_init()
	file_google_cloud_securitycenter_v2_cloud_dlp_inspection_proto_init()
	file_google_cloud_securitycenter_v2_compliance_proto_init()
	file_google_cloud_securitycenter_v2_connection_proto_init()
	file_google_cloud_securitycenter_v2_contact_details_proto_init()
	file_google_cloud_securitycenter_v2_container_proto_init()
	file_google_cloud_securitycenter_v2_data_access_event_proto_init()
	file_google_cloud_securitycenter_v2_data_flow_event_proto_init()
	file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_init()
	file_google_cloud_securitycenter_v2_database_proto_init()
	file_google_cloud_securitycenter_v2_disk_proto_init()
	file_google_cloud_securitycenter_v2_exfiltration_proto_init()
	file_google_cloud_securitycenter_v2_external_system_proto_init()
	file_google_cloud_securitycenter_v2_file_proto_init()
	file_google_cloud_securitycenter_v2_group_membership_proto_init()
	file_google_cloud_securitycenter_v2_iam_binding_proto_init()
	file_google_cloud_securitycenter_v2_indicator_proto_init()
	file_google_cloud_securitycenter_v2_kernel_rootkit_proto_init()
	file_google_cloud_securitycenter_v2_kubernetes_proto_init()
	file_google_cloud_securitycenter_v2_load_balancer_proto_init()
	file_google_cloud_securitycenter_v2_log_entry_proto_init()
	file_google_cloud_securitycenter_v2_mitre_attack_proto_init()
	file_google_cloud_securitycenter_v2_notebook_proto_init()
	file_google_cloud_securitycenter_v2_org_policy_proto_init()
	file_google_cloud_securitycenter_v2_process_proto_init()
	file_google_cloud_securitycenter_v2_security_marks_proto_init()
	file_google_cloud_securitycenter_v2_security_posture_proto_init()
	file_google_cloud_securitycenter_v2_toxic_combination_proto_init()
	file_google_cloud_securitycenter_v2_vulnerability_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_finding_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_finding_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_finding_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_finding_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_finding_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_finding_proto = out.File
	file_google_cloud_securitycenter_v2_finding_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_finding_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_finding_proto_depIdxs = nil
}
