// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestAdvancedSyntaxFeatures(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.AdvancedSyntaxFeaturesOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.AdvancedSyntaxFeatures([]string{"exactPhrase", "excludeWords"}...),
		},
		{
			opts:     []interface{}{opt.AdvancedSyntaxFeatures("value1")},
			expected: opt.AdvancedSyntaxFeatures("value1"),
		},
		{
			opts:     []interface{}{opt.AdvancedSyntaxFeatures("value1", "value2", "value3")},
			expected: opt.AdvancedSyntaxFeatures("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractAdvancedSyntaxFeatures(c.opts...)
			out opt.AdvancedSyntaxFeaturesOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestAdvancedSyntaxFeatures_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.AdvancedSyntaxFeaturesOption
	}{
		{
			payload:  `""`,
			expected: opt.AdvancedSyntaxFeatures([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.AdvancedSyntaxFeatures("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.AdvancedSyntaxFeatures("value1", "value2", "value3"),
		},
	} {
		var got opt.AdvancedSyntaxFeaturesOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
