// Code generated by go generate. DO NOT EDIT.

package opt

import "encoding/json"

// IndexPrefixOption is a wrapper for an IndexPrefix option parameter. It holds
// the actual value of the option that can be accessed by calling Get.
type IndexPrefixOption struct {
	value string
}

// IndexPrefix wraps the given value into a IndexPrefixOption.
func IndexPrefix(v string) *IndexPrefixOption {
	return &IndexPrefixOption{v}
}

// Get retrieves the actual value of the option parameter.
func (o *IndexPrefixOption) Get() string {
	if o == nil {
		return ""
	}
	return o.value
}

// MarshalJSON implements the json.Marshaler interface for
// IndexPrefixOption.
func (o IndexPrefixOption) MarshalJSON() ([]byte, error) {
	return json.Marshal(o.value)
}

// UnmarshalJSON implements the json.Unmarshaler interface for
// IndexPrefixOption.
func (o *IndexPrefixOption) UnmarshalJSON(data []byte) error {
	if string(data) == "null" {
		o.value = ""
		return nil
	}
	return json.Unmarshal(data, &o.value)
}

// Equal returns true if the given option is equal to the instance one. In case
// the given option is nil, we checked the instance one is set to the default
// value of the option.
func (o *IndexPrefixOption) Equal(o2 *IndexPrefixOption) bool {
	if o == nil {
		return o2 == nil || o2.value == ""
	}
	if o2 == nil {
		return o == nil || o.value == ""
	}
	return o.value == o2.value
}

// IndexPrefixEqual returns true if the two options are equal.
// In case of one option being nil, the value of the other must be nil as well
// or be set to the default value of this option.
func IndexPrefixEqual(o1, o2 *IndexPrefixOption) bool {
	return o1.Equal(o2)
}
