package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSuspiciousExport invokes the aegis.CreateSuspiciousExport API synchronously
// api document: https://help.aliyun.com/api/aegis/createsuspiciousexport.html
func (client *Client) CreateSuspiciousExport(request *CreateSuspiciousExportRequest) (response *CreateSuspiciousExportResponse, err error) {
	response = CreateCreateSuspiciousExportResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSuspiciousExportWithChan invokes the aegis.CreateSuspiciousExport API asynchronously
// api document: https://help.aliyun.com/api/aegis/createsuspiciousexport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSuspiciousExportWithChan(request *CreateSuspiciousExportRequest) (<-chan *CreateSuspiciousExportResponse, <-chan error) {
	responseChan := make(chan *CreateSuspiciousExportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSuspiciousExport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSuspiciousExportWithCallback invokes the aegis.CreateSuspiciousExport API asynchronously
// api document: https://help.aliyun.com/api/aegis/createsuspiciousexport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSuspiciousExportWithCallback(request *CreateSuspiciousExportRequest, callback func(response *CreateSuspiciousExportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSuspiciousExportResponse
		var err error
		defer close(result)
		response, err = client.CreateSuspiciousExport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSuspiciousExportRequest is the request struct for api CreateSuspiciousExport
type CreateSuspiciousExportRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EventNameRemark string           `position:"Query" name:"EventNameRemark"`
	StatusList      string           `position:"Query" name:"StatusList"`
	Level           string           `position:"Query" name:"Level"`
	Dealed          string           `position:"Query" name:"Dealed"`
	EventType       string           `position:"Query" name:"EventType"`
	Uuids           string           `position:"Query" name:"Uuids"`
	GroupId         string           `position:"Query" name:"GroupId"`
	Remark          string           `position:"Query" name:"Remark"`
	Tag             string           `position:"Query" name:"Tag"`
}

// CreateSuspiciousExportResponse is the response struct for api CreateSuspiciousExport
type CreateSuspiciousExportResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        int    `json:"Id" xml:"Id"`
	FileName  string `json:"FileName" xml:"FileName"`
}

// CreateCreateSuspiciousExportRequest creates a request to invoke CreateSuspiciousExport API
func CreateCreateSuspiciousExportRequest() (request *CreateSuspiciousExportRequest) {
	request = &CreateSuspiciousExportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "CreateSuspiciousExport", "vipaegis", "openAPI")
	return
}

// CreateCreateSuspiciousExportResponse creates a response to parse from CreateSuspiciousExport response
func CreateCreateSuspiciousExportResponse() (response *CreateSuspiciousExportResponse) {
	response = &CreateSuspiciousExportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
