package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DestroyOrganization invokes the baas.DestroyOrganization API synchronously
// api document: https://help.aliyun.com/api/baas/destroyorganization.html
func (client *Client) DestroyOrganization(request *DestroyOrganizationRequest) (response *DestroyOrganizationResponse, err error) {
	response = CreateDestroyOrganizationResponse()
	err = client.DoAction(request, response)
	return
}

// DestroyOrganizationWithChan invokes the baas.DestroyOrganization API asynchronously
// api document: https://help.aliyun.com/api/baas/destroyorganization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DestroyOrganizationWithChan(request *DestroyOrganizationRequest) (<-chan *DestroyOrganizationResponse, <-chan error) {
	responseChan := make(chan *DestroyOrganizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DestroyOrganization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DestroyOrganizationWithCallback invokes the baas.DestroyOrganization API asynchronously
// api document: https://help.aliyun.com/api/baas/destroyorganization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DestroyOrganizationWithCallback(request *DestroyOrganizationRequest, callback func(response *DestroyOrganizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DestroyOrganizationResponse
		var err error
		defer close(result)
		response, err = client.DestroyOrganization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DestroyOrganizationRequest is the request struct for api DestroyOrganization
type DestroyOrganizationRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Body" name:"OrganizationId"`
}

// DestroyOrganizationResponse is the response struct for api DestroyOrganization
type DestroyOrganizationResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      int    `json:"ErrorCode" xml:"ErrorCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Result         Result `json:"Result" xml:"Result"`
}

// CreateDestroyOrganizationRequest creates a request to invoke DestroyOrganization API
func CreateDestroyOrganizationRequest() (request *DestroyOrganizationRequest) {
	request = &DestroyOrganizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DestroyOrganization", "", "")
	return
}

// CreateDestroyOrganizationResponse creates a response to parse from DestroyOrganization response
func CreateDestroyOrganizationResponse() (response *DestroyOrganizationResponse) {
	response = &DestroyOrganizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
