package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnsubscribeExportToOSS invokes the bssopenapi.UnsubscribeExportToOSS API synchronously
// api document: https://help.aliyun.com/api/bssopenapi/unsubscribeexporttooss.html
func (client *Client) UnsubscribeExportToOSS(request *UnsubscribeExportToOSSRequest) (response *UnsubscribeExportToOSSResponse, err error) {
	response = CreateUnsubscribeExportToOSSResponse()
	err = client.DoAction(request, response)
	return
}

// UnsubscribeExportToOSSWithChan invokes the bssopenapi.UnsubscribeExportToOSS API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/unsubscribeexporttooss.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnsubscribeExportToOSSWithChan(request *UnsubscribeExportToOSSRequest) (<-chan *UnsubscribeExportToOSSResponse, <-chan error) {
	responseChan := make(chan *UnsubscribeExportToOSSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnsubscribeExportToOSS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnsubscribeExportToOSSWithCallback invokes the bssopenapi.UnsubscribeExportToOSS API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/unsubscribeexporttooss.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnsubscribeExportToOSSWithCallback(request *UnsubscribeExportToOSSRequest, callback func(response *UnsubscribeExportToOSSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnsubscribeExportToOSSResponse
		var err error
		defer close(result)
		response, err = client.UnsubscribeExportToOSS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnsubscribeExportToOSSRequest is the request struct for api UnsubscribeExportToOSS
type UnsubscribeExportToOSSRequest struct {
	*requests.RpcRequest
}

// UnsubscribeExportToOSSResponse is the response struct for api UnsubscribeExportToOSS
type UnsubscribeExportToOSSResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUnsubscribeExportToOSSRequest creates a request to invoke UnsubscribeExportToOSS API
func CreateUnsubscribeExportToOSSRequest() (request *UnsubscribeExportToOSSRequest) {
	request = &UnsubscribeExportToOSSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "UnsubscribeExportToOSS", "", "")
	return
}

// CreateUnsubscribeExportToOSSResponse creates a response to parse from UnsubscribeExportToOSS response
func CreateUnsubscribeExportToOSSResponse() (response *UnsubscribeExportToOSSResponse) {
	response = &UnsubscribeExportToOSSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
