package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SdkGenerate invokes the cloudapi.SdkGenerate API synchronously
// api document: https://help.aliyun.com/api/cloudapi/sdkgenerate.html
func (client *Client) SdkGenerate(request *SdkGenerateRequest) (response *SdkGenerateResponse, err error) {
	response = CreateSdkGenerateResponse()
	err = client.DoAction(request, response)
	return
}

// SdkGenerateWithChan invokes the cloudapi.SdkGenerate API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/sdkgenerate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SdkGenerateWithChan(request *SdkGenerateRequest) (<-chan *SdkGenerateResponse, <-chan error) {
	responseChan := make(chan *SdkGenerateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SdkGenerate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SdkGenerateWithCallback invokes the cloudapi.SdkGenerate API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/sdkgenerate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SdkGenerateWithCallback(request *SdkGenerateRequest, callback func(response *SdkGenerateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SdkGenerateResponse
		var err error
		defer close(result)
		response, err = client.SdkGenerate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SdkGenerateRequest is the request struct for api SdkGenerate
type SdkGenerateRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	GroupId       string           `position:"Query" name:"GroupId"`
	AppId         requests.Integer `position:"Query" name:"AppId"`
	Language      string           `position:"Query" name:"Language"`
}

// SdkGenerateResponse is the response struct for api SdkGenerate
type SdkGenerateResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	DownloadLink string `json:"DownloadLink" xml:"DownloadLink"`
}

// CreateSdkGenerateRequest creates a request to invoke SdkGenerate API
func CreateSdkGenerateRequest() (request *SdkGenerateRequest) {
	request = &SdkGenerateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "SdkGenerate", "apigateway", "openAPI")
	return
}

// CreateSdkGenerateResponse creates a response to parse from SdkGenerate response
func CreateSdkGenerateResponse() (response *SdkGenerateResponse) {
	response = &SdkGenerateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
