package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMyGroupAlert invokes the cms.GetMyGroupAlert API synchronously
// api document: https://help.aliyun.com/api/cms/getmygroupalert.html
func (client *Client) GetMyGroupAlert(request *GetMyGroupAlertRequest) (response *GetMyGroupAlertResponse, err error) {
	response = CreateGetMyGroupAlertResponse()
	err = client.DoAction(request, response)
	return
}

// GetMyGroupAlertWithChan invokes the cms.GetMyGroupAlert API asynchronously
// api document: https://help.aliyun.com/api/cms/getmygroupalert.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMyGroupAlertWithChan(request *GetMyGroupAlertRequest) (<-chan *GetMyGroupAlertResponse, <-chan error) {
	responseChan := make(chan *GetMyGroupAlertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMyGroupAlert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMyGroupAlertWithCallback invokes the cms.GetMyGroupAlert API asynchronously
// api document: https://help.aliyun.com/api/cms/getmygroupalert.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMyGroupAlertWithCallback(request *GetMyGroupAlertRequest, callback func(response *GetMyGroupAlertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMyGroupAlertResponse
		var err error
		defer close(result)
		response, err = client.GetMyGroupAlert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMyGroupAlertRequest is the request struct for api GetMyGroupAlert
type GetMyGroupAlertRequest struct {
	*requests.RpcRequest
	GroupId   requests.Integer `position:"Query" name:"GroupId"`
	AlertName string           `position:"Query" name:"AlertName"`
}

// GetMyGroupAlertResponse is the response struct for api GetMyGroupAlert
type GetMyGroupAlertResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	Success      bool       `json:"Success" xml:"Success"`
	ErrorCode    int        `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string     `json:"ErrorMessage" xml:"ErrorMessage"`
	GroupAlert   GroupAlert `json:"GroupAlert" xml:"GroupAlert"`
}

// CreateGetMyGroupAlertRequest creates a request to invoke GetMyGroupAlert API
func CreateGetMyGroupAlertRequest() (request *GetMyGroupAlertRequest) {
	request = &GetMyGroupAlertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "GetMyGroupAlert", "cms", "openAPI")
	return
}

// CreateGetMyGroupAlertResponse creates a response to parse from GetMyGroupAlert response
func CreateGetMyGroupAlertResponse() (response *GetMyGroupAlertResponse) {
	response = &GetMyGroupAlertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
