package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListActiveAlertRule invokes the cms.ListActiveAlertRule API synchronously
// api document: https://help.aliyun.com/api/cms/listactivealertrule.html
func (client *Client) ListActiveAlertRule(request *ListActiveAlertRuleRequest) (response *ListActiveAlertRuleResponse, err error) {
	response = CreateListActiveAlertRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListActiveAlertRuleWithChan invokes the cms.ListActiveAlertRule API asynchronously
// api document: https://help.aliyun.com/api/cms/listactivealertrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListActiveAlertRuleWithChan(request *ListActiveAlertRuleRequest) (<-chan *ListActiveAlertRuleResponse, <-chan error) {
	responseChan := make(chan *ListActiveAlertRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListActiveAlertRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListActiveAlertRuleWithCallback invokes the cms.ListActiveAlertRule API asynchronously
// api document: https://help.aliyun.com/api/cms/listactivealertrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListActiveAlertRuleWithCallback(request *ListActiveAlertRuleRequest, callback func(response *ListActiveAlertRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListActiveAlertRuleResponse
		var err error
		defer close(result)
		response, err = client.ListActiveAlertRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListActiveAlertRuleRequest is the request struct for api ListActiveAlertRule
type ListActiveAlertRuleRequest struct {
	*requests.RpcRequest
	Product string `position:"Query" name:"Product"`
	UserId  string `position:"Query" name:"UserId"`
}

// ListActiveAlertRuleResponse is the response struct for api ListActiveAlertRule
type ListActiveAlertRuleResponse struct {
	*responses.BaseResponse
	Success    bool                            `json:"Success" xml:"Success"`
	Code       string                          `json:"Code" xml:"Code"`
	Message    string                          `json:"Message" xml:"Message"`
	RequestId  string                          `json:"RequestId" xml:"RequestId"`
	Datapoints DatapointsInListActiveAlertRule `json:"Datapoints" xml:"Datapoints"`
}

// CreateListActiveAlertRuleRequest creates a request to invoke ListActiveAlertRule API
func CreateListActiveAlertRuleRequest() (request *ListActiveAlertRuleRequest) {
	request = &ListActiveAlertRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "ListActiveAlertRule", "cms", "openAPI")
	return
}

// CreateListActiveAlertRuleResponse creates a response to parse from ListActiveAlertRule response
func CreateListActiveAlertRuleResponse() (response *ListActiveAlertRuleResponse) {
	response = &ListActiveAlertRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
