package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusters invokes the cs.DescribeClusters API synchronously
// api document: https://help.aliyun.com/api/cs/describeclusters.html
func (client *Client) DescribeClusters(request *DescribeClustersRequest) (response *DescribeClustersResponse, err error) {
	response = CreateDescribeClustersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClustersWithChan invokes the cs.DescribeClusters API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusters.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClustersWithChan(request *DescribeClustersRequest) (<-chan *DescribeClustersResponse, <-chan error) {
	responseChan := make(chan *DescribeClustersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClustersWithCallback invokes the cs.DescribeClusters API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusters.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClustersWithCallback(request *DescribeClustersRequest, callback func(response *DescribeClustersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClustersResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClustersRequest is the request struct for api DescribeClusters
type DescribeClustersRequest struct {
	*requests.RoaRequest
	ClusterType string `position:"Query" name:"clusterType"`
	Name        string `position:"Query" name:"Name"`
}

// DescribeClustersResponse is the response struct for api DescribeClusters
type DescribeClustersResponse struct {
	*responses.BaseResponse
}

// CreateDescribeClustersRequest creates a request to invoke DescribeClusters API
func CreateDescribeClustersRequest() (request *DescribeClustersRequest) {
	request = &DescribeClustersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusters", "/clusters", "cs", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeClustersResponse creates a response to parse from DescribeClusters response
func CreateDescribeClustersResponse() (response *DescribeClustersResponse) {
	response = &DescribeClustersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
