package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainOriginBpsData invokes the dcdn.DescribeDcdnDomainOriginBpsData API synchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdndomainoriginbpsdata.html
func (client *Client) DescribeDcdnDomainOriginBpsData(request *DescribeDcdnDomainOriginBpsDataRequest) (response *DescribeDcdnDomainOriginBpsDataResponse, err error) {
	response = CreateDescribeDcdnDomainOriginBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainOriginBpsDataWithChan invokes the dcdn.DescribeDcdnDomainOriginBpsData API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdndomainoriginbpsdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnDomainOriginBpsDataWithChan(request *DescribeDcdnDomainOriginBpsDataRequest) (<-chan *DescribeDcdnDomainOriginBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainOriginBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainOriginBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainOriginBpsDataWithCallback invokes the dcdn.DescribeDcdnDomainOriginBpsData API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdndomainoriginbpsdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnDomainOriginBpsDataWithCallback(request *DescribeDcdnDomainOriginBpsDataRequest, callback func(response *DescribeDcdnDomainOriginBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainOriginBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainOriginBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainOriginBpsDataRequest is the request struct for api DescribeDcdnDomainOriginBpsData
type DescribeDcdnDomainOriginBpsDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	FixTimeGap string           `position:"Query" name:"FixTimeGap"`
	TimeMerge  string           `position:"Query" name:"TimeMerge"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// DescribeDcdnDomainOriginBpsDataResponse is the response struct for api DescribeDcdnDomainOriginBpsData
type DescribeDcdnDomainOriginBpsDataResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	DomainName               string                   `json:"DomainName" xml:"DomainName"`
	StartTime                string                   `json:"StartTime" xml:"StartTime"`
	EndTime                  string                   `json:"EndTime" xml:"EndTime"`
	DataInterval             string                   `json:"DataInterval" xml:"DataInterval"`
	OriginBpsDataPerInterval OriginBpsDataPerInterval `json:"OriginBpsDataPerInterval" xml:"OriginBpsDataPerInterval"`
}

// CreateDescribeDcdnDomainOriginBpsDataRequest creates a request to invoke DescribeDcdnDomainOriginBpsData API
func CreateDescribeDcdnDomainOriginBpsDataRequest() (request *DescribeDcdnDomainOriginBpsDataRequest) {
	request = &DescribeDcdnDomainOriginBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainOriginBpsData", "", "")
	return
}

// CreateDescribeDcdnDomainOriginBpsDataResponse creates a response to parse from DescribeDcdnDomainOriginBpsData response
func CreateDescribeDcdnDomainOriginBpsDataResponse() (response *DescribeDcdnDomainOriginBpsDataResponse) {
	response = &DescribeDcdnDomainOriginBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
