package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ContextQueryLog invokes the emr.ContextQueryLog API synchronously
// api document: https://help.aliyun.com/api/emr/contextquerylog.html
func (client *Client) ContextQueryLog(request *ContextQueryLogRequest) (response *ContextQueryLogResponse, err error) {
	response = CreateContextQueryLogResponse()
	err = client.DoAction(request, response)
	return
}

// ContextQueryLogWithChan invokes the emr.ContextQueryLog API asynchronously
// api document: https://help.aliyun.com/api/emr/contextquerylog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ContextQueryLogWithChan(request *ContextQueryLogRequest) (<-chan *ContextQueryLogResponse, <-chan error) {
	responseChan := make(chan *ContextQueryLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ContextQueryLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ContextQueryLogWithCallback invokes the emr.ContextQueryLog API asynchronously
// api document: https://help.aliyun.com/api/emr/contextquerylog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ContextQueryLogWithCallback(request *ContextQueryLogRequest, callback func(response *ContextQueryLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ContextQueryLogResponse
		var err error
		defer close(result)
		response, err = client.ContextQueryLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ContextQueryLogRequest is the request struct for api ContextQueryLog
type ContextQueryLogRequest struct {
	*requests.RpcRequest
	PackId          string           `position:"Query" name:"PackId"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TotalOffset     requests.Integer `position:"Query" name:"TotalOffset"`
	Size            requests.Integer `position:"Query" name:"Size"`
	PackMeta        string           `position:"Query" name:"PackMeta"`
	From            requests.Integer `position:"Query" name:"From"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	To              requests.Integer `position:"Query" name:"To"`
	Reverse         requests.Boolean `position:"Query" name:"Reverse"`
	LogStore        string           `position:"Query" name:"LogStore"`
}

// ContextQueryLogResponse is the response struct for api ContextQueryLog
type ContextQueryLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	PackId    string `json:"PackId" xml:"PackId"`
	PackMeta  string `json:"PackMeta" xml:"PackMeta"`
	Time      string `json:"Time" xml:"Time"`
	Logs      Logs   `json:"Logs" xml:"Logs"`
}

// CreateContextQueryLogRequest creates a request to invoke ContextQueryLog API
func CreateContextQueryLogRequest() (request *ContextQueryLogRequest) {
	request = &ContextQueryLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ContextQueryLog", "emr", "openAPI")
	return
}

// CreateContextQueryLogResponse creates a response to parse from ContextQueryLog response
func CreateContextQueryLogResponse() (response *ContextQueryLogResponse) {
	response = &ContextQueryLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
