package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLogDownloadUrl invokes the emr.GetLogDownloadUrl API synchronously
// api document: https://help.aliyun.com/api/emr/getlogdownloadurl.html
func (client *Client) GetLogDownloadUrl(request *GetLogDownloadUrlRequest) (response *GetLogDownloadUrlResponse, err error) {
	response = CreateGetLogDownloadUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetLogDownloadUrlWithChan invokes the emr.GetLogDownloadUrl API asynchronously
// api document: https://help.aliyun.com/api/emr/getlogdownloadurl.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLogDownloadUrlWithChan(request *GetLogDownloadUrlRequest) (<-chan *GetLogDownloadUrlResponse, <-chan error) {
	responseChan := make(chan *GetLogDownloadUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLogDownloadUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLogDownloadUrlWithCallback invokes the emr.GetLogDownloadUrl API asynchronously
// api document: https://help.aliyun.com/api/emr/getlogdownloadurl.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLogDownloadUrlWithCallback(request *GetLogDownloadUrlRequest, callback func(response *GetLogDownloadUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLogDownloadUrlResponse
		var err error
		defer close(result)
		response, err = client.GetLogDownloadUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLogDownloadUrlRequest is the request struct for api GetLogDownloadUrl
type GetLogDownloadUrlRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostName        string           `position:"Query" name:"HostName"`
	LogstoreName    string           `position:"Query" name:"LogstoreName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	LogFileName     string           `position:"Query" name:"LogFileName"`
}

// GetLogDownloadUrlResponse is the response struct for api GetLogDownloadUrl
type GetLogDownloadUrlResponse struct {
	*responses.BaseResponse
	RequestId                string `json:"RequestId" xml:"RequestId"`
	DownloadUrlBase64Encoded string `json:"DownloadUrlBase64Encoded" xml:"DownloadUrlBase64Encoded"`
}

// CreateGetLogDownloadUrlRequest creates a request to invoke GetLogDownloadUrl API
func CreateGetLogDownloadUrlRequest() (request *GetLogDownloadUrlRequest) {
	request = &GetLogDownloadUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetLogDownloadUrl", "emr", "openAPI")
	return
}

// CreateGetLogDownloadUrlResponse creates a response to parse from GetLogDownloadUrl response
func CreateGetLogDownloadUrlResponse() (response *GetLogDownloadUrlResponse) {
	response = &GetLogDownloadUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
