package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreListKafkaConsumerGroup invokes the emr.MetastoreListKafkaConsumerGroup API synchronously
// api document: https://help.aliyun.com/api/emr/metastorelistkafkaconsumergroup.html
func (client *Client) MetastoreListKafkaConsumerGroup(request *MetastoreListKafkaConsumerGroupRequest) (response *MetastoreListKafkaConsumerGroupResponse, err error) {
	response = CreateMetastoreListKafkaConsumerGroupResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreListKafkaConsumerGroupWithChan invokes the emr.MetastoreListKafkaConsumerGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelistkafkaconsumergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListKafkaConsumerGroupWithChan(request *MetastoreListKafkaConsumerGroupRequest) (<-chan *MetastoreListKafkaConsumerGroupResponse, <-chan error) {
	responseChan := make(chan *MetastoreListKafkaConsumerGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreListKafkaConsumerGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreListKafkaConsumerGroupWithCallback invokes the emr.MetastoreListKafkaConsumerGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelistkafkaconsumergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListKafkaConsumerGroupWithCallback(request *MetastoreListKafkaConsumerGroupRequest, callback func(response *MetastoreListKafkaConsumerGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreListKafkaConsumerGroupResponse
		var err error
		defer close(result)
		response, err = client.MetastoreListKafkaConsumerGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreListKafkaConsumerGroupRequest is the request struct for api MetastoreListKafkaConsumerGroup
type MetastoreListKafkaConsumerGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TopicId         string           `position:"Query" name:"TopicId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// MetastoreListKafkaConsumerGroupResponse is the response struct for api MetastoreListKafkaConsumerGroup
type MetastoreListKafkaConsumerGroupResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	TotalCount        int               `json:"TotalCount" xml:"TotalCount"`
	PageNumber        int               `json:"PageNumber" xml:"PageNumber"`
	PageSize          int               `json:"PageSize" xml:"PageSize"`
	ConsumerGroupList ConsumerGroupList `json:"ConsumerGroupList" xml:"ConsumerGroupList"`
}

// CreateMetastoreListKafkaConsumerGroupRequest creates a request to invoke MetastoreListKafkaConsumerGroup API
func CreateMetastoreListKafkaConsumerGroupRequest() (request *MetastoreListKafkaConsumerGroupRequest) {
	request = &MetastoreListKafkaConsumerGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreListKafkaConsumerGroup", "emr", "openAPI")
	return
}

// CreateMetastoreListKafkaConsumerGroupResponse creates a response to parse from MetastoreListKafkaConsumerGroup response
func CreateMetastoreListKafkaConsumerGroupResponse() (response *MetastoreListKafkaConsumerGroupResponse) {
	response = &MetastoreListKafkaConsumerGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
