package imagesearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddItem invokes the imagesearch.AddItem API synchronously
// api document: https://help.aliyun.com/api/imagesearch/additem.html
func (client *Client) AddItem(request *AddItemRequest) (response *AddItemResponse, err error) {
	response = CreateAddItemResponse()
	err = client.DoAction(request, response)
	return
}

// AddItemWithChan invokes the imagesearch.AddItem API asynchronously
// api document: https://help.aliyun.com/api/imagesearch/additem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddItemWithChan(request *AddItemRequest) (<-chan *AddItemResponse, <-chan error) {
	responseChan := make(chan *AddItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddItemWithCallback invokes the imagesearch.AddItem API asynchronously
// api document: https://help.aliyun.com/api/imagesearch/additem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddItemWithCallback(request *AddItemRequest, callback func(response *AddItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddItemResponse
		var err error
		defer close(result)
		response, err = client.AddItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddItemRequest is the request struct for api AddItem
type AddItemRequest struct {
	*requests.RoaRequest
	InstanceName string `position:"Query" name:"instanceName"`
}

// AddItemResponse is the response struct for api AddItem
type AddItemResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateAddItemRequest creates a request to invoke AddItem API
func CreateAddItemRequest() (request *AddItemRequest) {
	request = &AddItemRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ImageSearch", "2018-01-20", "AddItem", "/item/add", "imagesearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddItemResponse creates a response to parse from AddItem response
func CreateAddItemResponse() (response *AddItemResponse) {
	response = &AddItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
