//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package push

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPushStatByApp invokes the push.QueryPushStatByApp API synchronously
// api document: https://help.aliyun.com/api/push/querypushstatbyapp.html
func (client *Client) QueryPushStatByApp(request *QueryPushStatByAppRequest) (response *QueryPushStatByAppResponse, err error) {
	response = CreateQueryPushStatByAppResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPushStatByAppWithChan invokes the push.QueryPushStatByApp API asynchronously
// api document: https://help.aliyun.com/api/push/querypushstatbyapp.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryPushStatByAppWithChan(request *QueryPushStatByAppRequest) (<-chan *QueryPushStatByAppResponse, <-chan error) {
	responseChan := make(chan *QueryPushStatByAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPushStatByApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPushStatByAppWithCallback invokes the push.QueryPushStatByApp API asynchronously
// api document: https://help.aliyun.com/api/push/querypushstatbyapp.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryPushStatByAppWithCallback(request *QueryPushStatByAppRequest, callback func(response *QueryPushStatByAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPushStatByAppResponse
		var err error
		defer close(result)
		response, err = client.QueryPushStatByApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPushStatByAppRequest is the request struct for api QueryPushStatByApp
type QueryPushStatByAppRequest struct {
	*requests.RpcRequest
	AccessKeyId string           `position:"Query" name:"AccessKeyId"`
	AppKey      requests.Integer `position:"Query" name:"AppKey"`
	StartTime   string           `position:"Query" name:"StartTime"`
	EndTime     string           `position:"Query" name:"EndTime"`
	Granularity string           `position:"Query" name:"Granularity"`
}

// QueryPushStatByAppResponse is the response struct for api QueryPushStatByApp
type QueryPushStatByAppResponse struct {
	*responses.BaseResponse
	RequestId    string                          `json:"RequestId" xml:"RequestId"`
	AppPushStats QueryPushStatByAppAppPushStats0 `json:"AppPushStats" xml:"AppPushStats"`
}

type QueryPushStatByAppAppPushStats0 struct {
	AppPushStat []QueryPushStatByAppAppPushStat1 `json:"AppPushStat" xml:"AppPushStat"`
}

type QueryPushStatByAppAppPushStat1 struct {
	Time                   string `json:"Time" xml:"Time"`
	AcceptCount            int64  `json:"AcceptCount" xml:"AcceptCount"`
	SentCount              int64  `json:"SentCount" xml:"SentCount"`
	ReceivedCount          int64  `json:"ReceivedCount" xml:"ReceivedCount"`
	OpenedCount            int64  `json:"OpenedCount" xml:"OpenedCount"`
	DeletedCount           int64  `json:"DeletedCount" xml:"DeletedCount"`
	SmsSentCount           int64  `json:"SmsSentCount" xml:"SmsSentCount"`
	SmsSkipCount           int64  `json:"SmsSkipCount" xml:"SmsSkipCount"`
	SmsFailedCount         int64  `json:"SmsFailedCount" xml:"SmsFailedCount"`
	SmsReceiveSuccessCount int64  `json:"SmsReceiveSuccessCount" xml:"SmsReceiveSuccessCount"`
	SmsReceiveFailedCount  int64  `json:"SmsReceiveFailedCount" xml:"SmsReceiveFailedCount"`
}

// CreateQueryPushStatByAppRequest creates a request to invoke QueryPushStatByApp API
func CreateQueryPushStatByAppRequest() (request *QueryPushStatByAppRequest) {
	request = &QueryPushStatByAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Push", "2016-08-01", "QueryPushStatByApp", "push", "openAPI")
	return
}

// CreateQueryPushStatByAppResponse creates a response to parse from QueryPushStatByApp response
func CreateQueryPushStatByAppResponse() (response *QueryPushStatByAppResponse) {
	response = &QueryPushStatByAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
