// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a crash-consistent, point-in-time copy of an existing Amazon EBS volume
// within the same Availability Zone. The volume copy can be attached to an Amazon
// EC2 instance once it reaches the available state. For more information, see [Copy an Amazon EBS volume].
//
// [Copy an Amazon EBS volume]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copying-volume.html
func (c *Client) CopyVolumes(ctx context.Context, params *CopyVolumesInput, optFns ...func(*Options)) (*CopyVolumesOutput, error) {
	if params == nil {
		params = &CopyVolumesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CopyVolumes", params, optFns, c.addOperationCopyVolumesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CopyVolumesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CopyVolumesInput struct {

	// The ID of the source EBS volume to copy.
	//
	// This member is required.
	SourceVolumeId *string

	// Unique, case-sensitive identifier that you provide to ensure the idempotency of
	// the request. For more information, see [Ensure Idempotency].
	//
	// [Ensure Idempotency]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
	ClientToken *string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The number of I/O operations per second (IOPS) to provision for the volume
	// copy. Required for io1 and io2 volumes. Optional for gp3 volumes. Omit for all
	// other volume types. Full provisioned IOPS performance can be achieved only once
	// the volume copy is fully initialized.
	//
	// Valid ranges:
	//
	//   - gp3: 3,000 (default) - 80,000 IOPS
	//
	//   - io1: 100 - 64,000 IOPS
	//
	//   - io2: 100 - 256,000 IOPS
	//
	// [Instances built on the Nitro System]can support up to 256,000 IOPS. Other instances can support up to 32,000 IOPS.
	//
	// [Instances built on the Nitro System]: https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html
	Iops *int32

	// Indicates whether to enable Amazon EBS Multi-Attach for the volume copy. If you
	// enable Multi-Attach, you can attach the volume to up to 16 Nitro instances in
	// the same Availability Zone simultaneously. Supported with io1 and io2 volumes
	// only. For more information, see [Amazon EBS Multi-Attach].
	//
	// [Amazon EBS Multi-Attach]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html
	MultiAttachEnabled *bool

	// The size of the volume copy, in GiBs. The size must be equal to or greater than
	// the size of the source volume. If not specified, the size defaults to the size
	// of the source volume.
	//
	// Maximum supported sizes:
	//
	//   - gp2: 16,384 GiB
	//
	//   - gp3: 65,536 GiB
	//
	//   - io1: 16,384 GiB
	//
	//   - io2: 65,536 GiB
	//
	//   - st1 and sc1: 16,384 GiB
	//
	//   - standard: 1024 GiB
	Size *int32

	// The tags to apply to the volume copy during creation.
	TagSpecifications []types.TagSpecification

	// The throughput to provision for the volume copy, in MiB/s. Supported for gp3
	// volumes only. Omit for all other volume types. Full provisioned throughput
	// performance can be achieved only once the volume copy is fully initialized.
	//
	// Valid Range: 125 - 2000 MiB/s
	Throughput *int32

	// The volume type for the volume copy. If not specified, the volume type defaults
	// to gp2 .
	VolumeType types.VolumeType

	noSmithyDocumentSerde
}

type CopyVolumesOutput struct {

	// Information about the volume copy.
	Volumes []types.Volume

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCopyVolumesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpCopyVolumes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCopyVolumes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CopyVolumes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCopyVolumesMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCopyVolumesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCopyVolumes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCopyVolumes struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCopyVolumes) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCopyVolumes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CopyVolumesInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CopyVolumesInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCopyVolumesMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCopyVolumes{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCopyVolumes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CopyVolumes",
	}
}
