// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Retrieves the current configuration and status of EC2 Capacity Manager for
//
// your account, including enablement status, Organizations access settings, and
// data ingestion status.
func (c *Client) GetCapacityManagerAttributes(ctx context.Context, params *GetCapacityManagerAttributesInput, optFns ...func(*Options)) (*GetCapacityManagerAttributesOutput, error) {
	if params == nil {
		params = &GetCapacityManagerAttributesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCapacityManagerAttributes", params, optFns, c.addOperationGetCapacityManagerAttributesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCapacityManagerAttributesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCapacityManagerAttributesInput struct {

	//  Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	noSmithyDocumentSerde
}

type GetCapacityManagerAttributesOutput struct {

	//  The current status of Capacity Manager.
	CapacityManagerStatus types.CapacityManagerStatus

	//  The number of active data export configurations for this account. This count
	// includes all data exports regardless of their current delivery status.
	DataExportCount *int32

	//  The timestamp of the earliest data point available in Capacity Manager, in
	// milliseconds since epoch. This indicates how far back historical data is
	// available for queries.
	EarliestDatapointTimestamp *time.Time

	//  The current data ingestion status. Initial ingestion may take several hours
	// after enabling Capacity Manager.
	IngestionStatus types.IngestionStatus

	//  A descriptive message providing additional details about the current ingestion
	// status. This may include error information if ingestion has failed or progress
	// details during initial setup.
	IngestionStatusMessage *string

	//  The timestamp of the most recent data point ingested by Capacity Manager, in
	// milliseconds since epoch. This indicates how current your capacity data is.
	LatestDatapointTimestamp *time.Time

	//  Indicates whether Organizations access is enabled for cross-account data
	// aggregation.
	OrganizationsAccess *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCapacityManagerAttributesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpGetCapacityManagerAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpGetCapacityManagerAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCapacityManagerAttributes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCapacityManagerAttributes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCapacityManagerAttributes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCapacityManagerAttributes",
	}
}
