// Code generated by smithy-go-codegen DO NOT EDIT.

package signin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/signin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// CreateOAuth2Token API
//
// Path: /v1/token Request Method: POST Content-Type: application/json or
// application/x-www-form-urlencoded
//
// This API implements OAuth 2.0 flows for AWS Sign-In CLI clients, supporting
// both:
//
//   - Authorization code redemption (grant_type=authorization_code) - NOT
//     idempotent
//   - Token refresh (grant_type=refresh_token) - Idempotent within token validity
//     window
//
// The operation behavior is determined by the grant_type parameter in the request
// body:
//
// Authorization Code Flow (NOT Idempotent):
//
//   - JSON or form-encoded body with client_id, grant_type=authorization_code,
//     code, redirect_uri, code_verifier
//   - Returns access_token, token_type, expires_in, refresh_token, and id_token
//   - Each authorization code can only be used ONCE for security (prevents replay
//     attacks)
//
// Token Refresh Flow (Idempotent):
//
//   - JSON or form-encoded body with client_id, grant_type=refresh_token,
//     refresh_token
//   - Returns access_token, token_type, expires_in, and refresh_token (no
//     id_token)
//   - Multiple calls with same refresh_token return consistent results within
//     validity window
//
// Authentication and authorization:
//
//   - Confidential clients: sigv4 signing required with signin:ExchangeToken
//     permissions
//   - CLI clients (public): authn/authz skipped based on client_id & grant_type
//
// Note: This operation cannot be marked as @idempotent because it handles both
// idempotent (token refresh) and non-idempotent (auth code redemption) flows in a
// single endpoint.
func (c *Client) CreateOAuth2Token(ctx context.Context, params *CreateOAuth2TokenInput, optFns ...func(*Options)) (*CreateOAuth2TokenOutput, error) {
	if params == nil {
		params = &CreateOAuth2TokenInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateOAuth2Token", params, optFns, c.addOperationCreateOAuth2TokenMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateOAuth2TokenOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input structure for CreateOAuth2Token operation
//
// Contains flattened token operation inputs for both authorization code and
// refresh token flows. The operation type is determined by the grant_type
// parameter in the request body.
type CreateOAuth2TokenInput struct {

	// Flattened token operation inputs The specific operation is determined by
	// grant_type in the request body
	//
	// This member is required.
	TokenInput *types.CreateOAuth2TokenRequestBody

	noSmithyDocumentSerde
}

// Output structure for CreateOAuth2Token operation
//
// Contains flattened token operation outputs for both authorization code and
// refresh token flows. The response content depends on the grant_type from the
// original request.
type CreateOAuth2TokenOutput struct {

	// Flattened token operation outputs The specific response fields depend on the
	// grant_type used in the request
	//
	// This member is required.
	TokenOutput *types.CreateOAuth2TokenResponseBody

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateOAuth2TokenMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateOAuth2Token{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateOAuth2Token{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateOAuth2Token"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateOAuth2TokenValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateOAuth2Token(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateOAuth2Token(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateOAuth2Token",
	}
}
