// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package awsquerycompatible

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCreateQueue = "CreateQueue"

// CreateQueueRequest generates a "aws/request.Request" representing the
// client's request for the CreateQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQueue for more information on using the CreateQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateQueueRequest method.
//	req, resp := client.CreateQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/awsquerycompatible-2012-11-05/CreateQueue
func (c *AwsQueryCompatible) CreateQueueRequest(input *CreateQueueInput) (req *request.Request, output *CreateQueueOutput) {
	op := &request.Operation{
		Name:       opCreateQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateQueueInput{}
	}

	output = &CreateQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateQueue API operation for AWSQuery Compatible Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSQuery Compatible Service's
// API operation CreateQueue for usage and error information.
//
// Returned Error Types:
//
//   - QueueDeletedRecently
//
//   - QueueNameExists
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/awsquerycompatible-2012-11-05/CreateQueue
func (c *AwsQueryCompatible) CreateQueue(input *CreateQueueInput) (*CreateQueueOutput, error) {
	req, out := c.CreateQueueRequest(input)
	return out, req.Send()
}

// CreateQueueWithContext is the same as CreateQueue with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AwsQueryCompatible) CreateQueueWithContext(ctx aws.Context, input *CreateQueueInput, opts ...request.Option) (*CreateQueueOutput, error) {
	req, out := c.CreateQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateQueueInput struct {
	_ struct{} `type:"structure"`

	// QueueName is a required field
	QueueName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQueueInput"}
	if s.QueueName == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueueName sets the QueueName field's value.
func (s *CreateQueueInput) SetQueueName(v string) *CreateQueueInput {
	s.QueueName = &v
	return s
}

type CreateQueueOutput struct {
	_ struct{} `type:"structure"`

	QueueUrl *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueOutput) GoString() string {
	return s.String()
}

// SetQueueUrl sets the QueueUrl field's value.
func (s *CreateQueueOutput) SetQueueUrl(v string) *CreateQueueOutput {
	s.QueueUrl = &v
	return s
}

type QueueDeletedRecently struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`
	Code_        *string

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueDeletedRecently) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueDeletedRecently) GoString() string {
	return s.String()
}

func newErrorQueueDeletedRecently(v protocol.ResponseMetadata) error {
	return &QueueDeletedRecently{
		RespMetadata: v,
	}
}
func newQueryCompatibleErrorQueueDeletedRecently(v protocol.ResponseMetadata, code string) error {
	return &QueueDeletedRecently{
		RespMetadata: v,
		Code_:        &code,
	}
}

// Code returns the exception type name.
func (s *QueueDeletedRecently) Code() string {
	if s.Code_ != nil {
		return *s.Code_
	}
	return "QueueDeletedRecently"
}

// Message returns the exception's message.
func (s *QueueDeletedRecently) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *QueueDeletedRecently) OrigErr() error {
	return nil
}

func (s *QueueDeletedRecently) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *QueueDeletedRecently) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *QueueDeletedRecently) RequestID() string {
	return s.RespMetadata.RequestID
}

type QueueNameExists struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`
	Code_        *string

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueNameExists) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueNameExists) GoString() string {
	return s.String()
}

func newErrorQueueNameExists(v protocol.ResponseMetadata) error {
	return &QueueNameExists{
		RespMetadata: v,
	}
}
func newQueryCompatibleErrorQueueNameExists(v protocol.ResponseMetadata, code string) error {
	return &QueueNameExists{
		RespMetadata: v,
		Code_:        &code,
	}
}

// Code returns the exception type name.
func (s *QueueNameExists) Code() string {
	if s.Code_ != nil {
		return *s.Code_
	}
	return "QueueNameExists"
}

// Message returns the exception's message.
func (s *QueueNameExists) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *QueueNameExists) OrigErr() error {
	return nil
}

func (s *QueueNameExists) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *QueueNameExists) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *QueueNameExists) RequestID() string {
	return s.RespMetadata.RequestID
}
