/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the EndpoinrtS3 type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EndpoinrtS3{}

// EndpoinrtS3 struct for EndpoinrtS3
type EndpoinrtS3 struct {
	EndpointType *string `json:"endpoint_type,omitempty"`
	AccessKey *string `json:"access_key,omitempty"`
	Region *string `json:"region,omitempty"`
	ObjectKeyPrefix *string `json:"object_key_prefix,omitempty"`
	BucketName *string `json:"bucket_name,omitempty"`
	ContentType *string `json:"content_type,omitempty"`
	HostUrl *string `json:"host_url,omitempty"`
	SecretKey *string `json:"secret_key,omitempty"`
}

// NewEndpoinrtS3 instantiates a new EndpoinrtS3 object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEndpoinrtS3() *EndpoinrtS3 {
	this := EndpoinrtS3{}
	return &this
}

// NewEndpoinrtS3WithDefaults instantiates a new EndpoinrtS3 object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEndpoinrtS3WithDefaults() *EndpoinrtS3 {
	this := EndpoinrtS3{}
	return &this
}

// GetEndpointType returns the EndpointType field value if set, zero value otherwise.
func (o *EndpoinrtS3) GetEndpointType() string {
	if o == nil || IsNil(o.EndpointType) {
		var ret string
		return ret
	}
	return *o.EndpointType
}

// GetEndpointTypeOk returns a tuple with the EndpointType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpoinrtS3) GetEndpointTypeOk() (*string, bool) {
	if o == nil || IsNil(o.EndpointType) {
		return nil, false
	}
	return o.EndpointType, true
}

// HasEndpointType returns a boolean if a field has been set.
func (o *EndpoinrtS3) HasEndpointType() bool {
	if o != nil && !IsNil(o.EndpointType) {
		return true
	}

	return false
}

// SetEndpointType gets a reference to the given string and assigns it to the EndpointType field.
func (o *EndpoinrtS3) SetEndpointType(v string) {
	o.EndpointType = &v
}

// GetAccessKey returns the AccessKey field value if set, zero value otherwise.
func (o *EndpoinrtS3) GetAccessKey() string {
	if o == nil || IsNil(o.AccessKey) {
		var ret string
		return ret
	}
	return *o.AccessKey
}

// GetAccessKeyOk returns a tuple with the AccessKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpoinrtS3) GetAccessKeyOk() (*string, bool) {
	if o == nil || IsNil(o.AccessKey) {
		return nil, false
	}
	return o.AccessKey, true
}

// HasAccessKey returns a boolean if a field has been set.
func (o *EndpoinrtS3) HasAccessKey() bool {
	if o != nil && !IsNil(o.AccessKey) {
		return true
	}

	return false
}

// SetAccessKey gets a reference to the given string and assigns it to the AccessKey field.
func (o *EndpoinrtS3) SetAccessKey(v string) {
	o.AccessKey = &v
}

// GetRegion returns the Region field value if set, zero value otherwise.
func (o *EndpoinrtS3) GetRegion() string {
	if o == nil || IsNil(o.Region) {
		var ret string
		return ret
	}
	return *o.Region
}

// GetRegionOk returns a tuple with the Region field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpoinrtS3) GetRegionOk() (*string, bool) {
	if o == nil || IsNil(o.Region) {
		return nil, false
	}
	return o.Region, true
}

// HasRegion returns a boolean if a field has been set.
func (o *EndpoinrtS3) HasRegion() bool {
	if o != nil && !IsNil(o.Region) {
		return true
	}

	return false
}

// SetRegion gets a reference to the given string and assigns it to the Region field.
func (o *EndpoinrtS3) SetRegion(v string) {
	o.Region = &v
}

// GetObjectKeyPrefix returns the ObjectKeyPrefix field value if set, zero value otherwise.
func (o *EndpoinrtS3) GetObjectKeyPrefix() string {
	if o == nil || IsNil(o.ObjectKeyPrefix) {
		var ret string
		return ret
	}
	return *o.ObjectKeyPrefix
}

// GetObjectKeyPrefixOk returns a tuple with the ObjectKeyPrefix field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpoinrtS3) GetObjectKeyPrefixOk() (*string, bool) {
	if o == nil || IsNil(o.ObjectKeyPrefix) {
		return nil, false
	}
	return o.ObjectKeyPrefix, true
}

// HasObjectKeyPrefix returns a boolean if a field has been set.
func (o *EndpoinrtS3) HasObjectKeyPrefix() bool {
	if o != nil && !IsNil(o.ObjectKeyPrefix) {
		return true
	}

	return false
}

// SetObjectKeyPrefix gets a reference to the given string and assigns it to the ObjectKeyPrefix field.
func (o *EndpoinrtS3) SetObjectKeyPrefix(v string) {
	o.ObjectKeyPrefix = &v
}

// GetBucketName returns the BucketName field value if set, zero value otherwise.
func (o *EndpoinrtS3) GetBucketName() string {
	if o == nil || IsNil(o.BucketName) {
		var ret string
		return ret
	}
	return *o.BucketName
}

// GetBucketNameOk returns a tuple with the BucketName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpoinrtS3) GetBucketNameOk() (*string, bool) {
	if o == nil || IsNil(o.BucketName) {
		return nil, false
	}
	return o.BucketName, true
}

// HasBucketName returns a boolean if a field has been set.
func (o *EndpoinrtS3) HasBucketName() bool {
	if o != nil && !IsNil(o.BucketName) {
		return true
	}

	return false
}

// SetBucketName gets a reference to the given string and assigns it to the BucketName field.
func (o *EndpoinrtS3) SetBucketName(v string) {
	o.BucketName = &v
}

// GetContentType returns the ContentType field value if set, zero value otherwise.
func (o *EndpoinrtS3) GetContentType() string {
	if o == nil || IsNil(o.ContentType) {
		var ret string
		return ret
	}
	return *o.ContentType
}

// GetContentTypeOk returns a tuple with the ContentType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpoinrtS3) GetContentTypeOk() (*string, bool) {
	if o == nil || IsNil(o.ContentType) {
		return nil, false
	}
	return o.ContentType, true
}

// HasContentType returns a boolean if a field has been set.
func (o *EndpoinrtS3) HasContentType() bool {
	if o != nil && !IsNil(o.ContentType) {
		return true
	}

	return false
}

// SetContentType gets a reference to the given string and assigns it to the ContentType field.
func (o *EndpoinrtS3) SetContentType(v string) {
	o.ContentType = &v
}

// GetHostUrl returns the HostUrl field value if set, zero value otherwise.
func (o *EndpoinrtS3) GetHostUrl() string {
	if o == nil || IsNil(o.HostUrl) {
		var ret string
		return ret
	}
	return *o.HostUrl
}

// GetHostUrlOk returns a tuple with the HostUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpoinrtS3) GetHostUrlOk() (*string, bool) {
	if o == nil || IsNil(o.HostUrl) {
		return nil, false
	}
	return o.HostUrl, true
}

// HasHostUrl returns a boolean if a field has been set.
func (o *EndpoinrtS3) HasHostUrl() bool {
	if o != nil && !IsNil(o.HostUrl) {
		return true
	}

	return false
}

// SetHostUrl gets a reference to the given string and assigns it to the HostUrl field.
func (o *EndpoinrtS3) SetHostUrl(v string) {
	o.HostUrl = &v
}

// GetSecretKey returns the SecretKey field value if set, zero value otherwise.
func (o *EndpoinrtS3) GetSecretKey() string {
	if o == nil || IsNil(o.SecretKey) {
		var ret string
		return ret
	}
	return *o.SecretKey
}

// GetSecretKeyOk returns a tuple with the SecretKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpoinrtS3) GetSecretKeyOk() (*string, bool) {
	if o == nil || IsNil(o.SecretKey) {
		return nil, false
	}
	return o.SecretKey, true
}

// HasSecretKey returns a boolean if a field has been set.
func (o *EndpoinrtS3) HasSecretKey() bool {
	if o != nil && !IsNil(o.SecretKey) {
		return true
	}

	return false
}

// SetSecretKey gets a reference to the given string and assigns it to the SecretKey field.
func (o *EndpoinrtS3) SetSecretKey(v string) {
	o.SecretKey = &v
}

func (o EndpoinrtS3) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EndpoinrtS3) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.EndpointType) {
		toSerialize["endpoint_type"] = o.EndpointType
	}
	if !IsNil(o.AccessKey) {
		toSerialize["access_key"] = o.AccessKey
	}
	if !IsNil(o.Region) {
		toSerialize["region"] = o.Region
	}
	if !IsNil(o.ObjectKeyPrefix) {
		toSerialize["object_key_prefix"] = o.ObjectKeyPrefix
	}
	if !IsNil(o.BucketName) {
		toSerialize["bucket_name"] = o.BucketName
	}
	if !IsNil(o.ContentType) {
		toSerialize["content_type"] = o.ContentType
	}
	if !IsNil(o.HostUrl) {
		toSerialize["host_url"] = o.HostUrl
	}
	if !IsNil(o.SecretKey) {
		toSerialize["secret_key"] = o.SecretKey
	}
	return toSerialize, nil
}

type NullableEndpoinrtS3 struct {
	value *EndpoinrtS3
	isSet bool
}

func (v NullableEndpoinrtS3) Get() *EndpoinrtS3 {
	return v.value
}

func (v *NullableEndpoinrtS3) Set(val *EndpoinrtS3) {
	v.value = val
	v.isSet = true
}

func (v NullableEndpoinrtS3) IsSet() bool {
	return v.isSet
}

func (v *NullableEndpoinrtS3) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEndpoinrtS3(val *EndpoinrtS3) *NullableEndpoinrtS3 {
	return &NullableEndpoinrtS3{value: val, isSet: true}
}

func (v NullableEndpoinrtS3) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEndpoinrtS3) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


