/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the EndpointDefault type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EndpointDefault{}

// EndpointDefault struct for EndpointDefault
type EndpointDefault struct {
	EndpointType *string `json:"endpoint_type,omitempty"`
	Url *string `json:"url,omitempty"`
	LogLineSeparator *string `json:"log_line_separator,omitempty"`
	PayloadFormat *string `json:"payload_format,omitempty"`
	MaxSize *int32 `json:"max_size,omitempty"`
	Headers []map[string]string `json:"headers,omitempty"`
}

// NewEndpointDefault instantiates a new EndpointDefault object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEndpointDefault() *EndpointDefault {
	this := EndpointDefault{}
	return &this
}

// NewEndpointDefaultWithDefaults instantiates a new EndpointDefault object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEndpointDefaultWithDefaults() *EndpointDefault {
	this := EndpointDefault{}
	return &this
}

// GetEndpointType returns the EndpointType field value if set, zero value otherwise.
func (o *EndpointDefault) GetEndpointType() string {
	if o == nil || IsNil(o.EndpointType) {
		var ret string
		return ret
	}
	return *o.EndpointType
}

// GetEndpointTypeOk returns a tuple with the EndpointType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointDefault) GetEndpointTypeOk() (*string, bool) {
	if o == nil || IsNil(o.EndpointType) {
		return nil, false
	}
	return o.EndpointType, true
}

// HasEndpointType returns a boolean if a field has been set.
func (o *EndpointDefault) HasEndpointType() bool {
	if o != nil && !IsNil(o.EndpointType) {
		return true
	}

	return false
}

// SetEndpointType gets a reference to the given string and assigns it to the EndpointType field.
func (o *EndpointDefault) SetEndpointType(v string) {
	o.EndpointType = &v
}

// GetUrl returns the Url field value if set, zero value otherwise.
func (o *EndpointDefault) GetUrl() string {
	if o == nil || IsNil(o.Url) {
		var ret string
		return ret
	}
	return *o.Url
}

// GetUrlOk returns a tuple with the Url field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointDefault) GetUrlOk() (*string, bool) {
	if o == nil || IsNil(o.Url) {
		return nil, false
	}
	return o.Url, true
}

// HasUrl returns a boolean if a field has been set.
func (o *EndpointDefault) HasUrl() bool {
	if o != nil && !IsNil(o.Url) {
		return true
	}

	return false
}

// SetUrl gets a reference to the given string and assigns it to the Url field.
func (o *EndpointDefault) SetUrl(v string) {
	o.Url = &v
}

// GetLogLineSeparator returns the LogLineSeparator field value if set, zero value otherwise.
func (o *EndpointDefault) GetLogLineSeparator() string {
	if o == nil || IsNil(o.LogLineSeparator) {
		var ret string
		return ret
	}
	return *o.LogLineSeparator
}

// GetLogLineSeparatorOk returns a tuple with the LogLineSeparator field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointDefault) GetLogLineSeparatorOk() (*string, bool) {
	if o == nil || IsNil(o.LogLineSeparator) {
		return nil, false
	}
	return o.LogLineSeparator, true
}

// HasLogLineSeparator returns a boolean if a field has been set.
func (o *EndpointDefault) HasLogLineSeparator() bool {
	if o != nil && !IsNil(o.LogLineSeparator) {
		return true
	}

	return false
}

// SetLogLineSeparator gets a reference to the given string and assigns it to the LogLineSeparator field.
func (o *EndpointDefault) SetLogLineSeparator(v string) {
	o.LogLineSeparator = &v
}

// GetPayloadFormat returns the PayloadFormat field value if set, zero value otherwise.
func (o *EndpointDefault) GetPayloadFormat() string {
	if o == nil || IsNil(o.PayloadFormat) {
		var ret string
		return ret
	}
	return *o.PayloadFormat
}

// GetPayloadFormatOk returns a tuple with the PayloadFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointDefault) GetPayloadFormatOk() (*string, bool) {
	if o == nil || IsNil(o.PayloadFormat) {
		return nil, false
	}
	return o.PayloadFormat, true
}

// HasPayloadFormat returns a boolean if a field has been set.
func (o *EndpointDefault) HasPayloadFormat() bool {
	if o != nil && !IsNil(o.PayloadFormat) {
		return true
	}

	return false
}

// SetPayloadFormat gets a reference to the given string and assigns it to the PayloadFormat field.
func (o *EndpointDefault) SetPayloadFormat(v string) {
	o.PayloadFormat = &v
}

// GetMaxSize returns the MaxSize field value if set, zero value otherwise.
func (o *EndpointDefault) GetMaxSize() int32 {
	if o == nil || IsNil(o.MaxSize) {
		var ret int32
		return ret
	}
	return *o.MaxSize
}

// GetMaxSizeOk returns a tuple with the MaxSize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointDefault) GetMaxSizeOk() (*int32, bool) {
	if o == nil || IsNil(o.MaxSize) {
		return nil, false
	}
	return o.MaxSize, true
}

// HasMaxSize returns a boolean if a field has been set.
func (o *EndpointDefault) HasMaxSize() bool {
	if o != nil && !IsNil(o.MaxSize) {
		return true
	}

	return false
}

// SetMaxSize gets a reference to the given int32 and assigns it to the MaxSize field.
func (o *EndpointDefault) SetMaxSize(v int32) {
	o.MaxSize = &v
}

// GetHeaders returns the Headers field value if set, zero value otherwise.
func (o *EndpointDefault) GetHeaders() []map[string]string {
	if o == nil || IsNil(o.Headers) {
		var ret []map[string]string
		return ret
	}
	return o.Headers
}

// GetHeadersOk returns a tuple with the Headers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointDefault) GetHeadersOk() ([]map[string]string, bool) {
	if o == nil || IsNil(o.Headers) {
		return nil, false
	}
	return o.Headers, true
}

// HasHeaders returns a boolean if a field has been set.
func (o *EndpointDefault) HasHeaders() bool {
	if o != nil && !IsNil(o.Headers) {
		return true
	}

	return false
}

// SetHeaders gets a reference to the given []map[string]string and assigns it to the Headers field.
func (o *EndpointDefault) SetHeaders(v []map[string]string) {
	o.Headers = v
}

func (o EndpointDefault) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EndpointDefault) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.EndpointType) {
		toSerialize["endpoint_type"] = o.EndpointType
	}
	if !IsNil(o.Url) {
		toSerialize["url"] = o.Url
	}
	if !IsNil(o.LogLineSeparator) {
		toSerialize["log_line_separator"] = o.LogLineSeparator
	}
	if !IsNil(o.PayloadFormat) {
		toSerialize["payload_format"] = o.PayloadFormat
	}
	if !IsNil(o.MaxSize) {
		toSerialize["max_size"] = o.MaxSize
	}
	if !IsNil(o.Headers) {
		toSerialize["headers"] = o.Headers
	}
	return toSerialize, nil
}

type NullableEndpointDefault struct {
	value *EndpointDefault
	isSet bool
}

func (v NullableEndpointDefault) Get() *EndpointDefault {
	return v.value
}

func (v *NullableEndpointDefault) Set(val *EndpointDefault) {
	v.value = val
	v.isSet = true
}

func (v NullableEndpointDefault) IsSet() bool {
	return v.isSet
}

func (v *NullableEndpointDefault) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEndpointDefault(val *EndpointDefault) *NullableEndpointDefault {
	return &NullableEndpointDefault{value: val, isSet: true}
}

func (v NullableEndpointDefault) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEndpointDefault) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


