/*
Personal Tokens - OpenAPI

The Personal Tokens API allows you to manage your existing personal tokens. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package personal_tokens

import (
	"encoding/json"
	"time"
)

// checks if the CreatePersonalTokenRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CreatePersonalTokenRequest{}

// CreatePersonalTokenRequest struct for CreatePersonalTokenRequest
type CreatePersonalTokenRequest struct {
	Name *string `json:"name,omitempty"`
	ExpiresAt *time.Time `json:"expires_at,omitempty"`
	Description NullableString `json:"description,omitempty"`
}

// NewCreatePersonalTokenRequest instantiates a new CreatePersonalTokenRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreatePersonalTokenRequest() *CreatePersonalTokenRequest {
	this := CreatePersonalTokenRequest{}
	return &this
}

// NewCreatePersonalTokenRequestWithDefaults instantiates a new CreatePersonalTokenRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreatePersonalTokenRequestWithDefaults() *CreatePersonalTokenRequest {
	this := CreatePersonalTokenRequest{}
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *CreatePersonalTokenRequest) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePersonalTokenRequest) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *CreatePersonalTokenRequest) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *CreatePersonalTokenRequest) SetName(v string) {
	o.Name = &v
}

// GetExpiresAt returns the ExpiresAt field value if set, zero value otherwise.
func (o *CreatePersonalTokenRequest) GetExpiresAt() time.Time {
	if o == nil || IsNil(o.ExpiresAt) {
		var ret time.Time
		return ret
	}
	return *o.ExpiresAt
}

// GetExpiresAtOk returns a tuple with the ExpiresAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePersonalTokenRequest) GetExpiresAtOk() (*time.Time, bool) {
	if o == nil || IsNil(o.ExpiresAt) {
		return nil, false
	}
	return o.ExpiresAt, true
}

// HasExpiresAt returns a boolean if a field has been set.
func (o *CreatePersonalTokenRequest) HasExpiresAt() bool {
	if o != nil && !IsNil(o.ExpiresAt) {
		return true
	}

	return false
}

// SetExpiresAt gets a reference to the given time.Time and assigns it to the ExpiresAt field.
func (o *CreatePersonalTokenRequest) SetExpiresAt(v time.Time) {
	o.ExpiresAt = &v
}

// GetDescription returns the Description field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *CreatePersonalTokenRequest) GetDescription() string {
	if o == nil || IsNil(o.Description.Get()) {
		var ret string
		return ret
	}
	return *o.Description.Get()
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CreatePersonalTokenRequest) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description.Get(), o.Description.IsSet()
}

// HasDescription returns a boolean if a field has been set.
func (o *CreatePersonalTokenRequest) HasDescription() bool {
	if o != nil && o.Description.IsSet() {
		return true
	}

	return false
}

// SetDescription gets a reference to the given NullableString and assigns it to the Description field.
func (o *CreatePersonalTokenRequest) SetDescription(v string) {
	o.Description.Set(&v)
}
// SetDescriptionNil sets the value for Description to be an explicit nil
func (o *CreatePersonalTokenRequest) SetDescriptionNil() {
	o.Description.Set(nil)
}

// UnsetDescription ensures that no value is present for Description, not even an explicit nil
func (o *CreatePersonalTokenRequest) UnsetDescription() {
	o.Description.Unset()
}

func (o CreatePersonalTokenRequest) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CreatePersonalTokenRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.ExpiresAt) {
		toSerialize["expires_at"] = o.ExpiresAt
	}
	if o.Description.IsSet() {
		toSerialize["description"] = o.Description.Get()
	}
	return toSerialize, nil
}

type NullableCreatePersonalTokenRequest struct {
	value *CreatePersonalTokenRequest
	isSet bool
}

func (v NullableCreatePersonalTokenRequest) Get() *CreatePersonalTokenRequest {
	return v.value
}

func (v *NullableCreatePersonalTokenRequest) Set(val *CreatePersonalTokenRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableCreatePersonalTokenRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableCreatePersonalTokenRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreatePersonalTokenRequest(val *CreatePersonalTokenRequest) *NullableCreatePersonalTokenRequest {
	return &NullableCreatePersonalTokenRequest{value: val, isSet: true}
}

func (v NullableCreatePersonalTokenRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreatePersonalTokenRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


