//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package asluav

import (
	"github.com/bluenviron/gomavlib/v3/pkg/dialects/common"
)

// Parameter protocol error types (see PARAM_ERROR).
type MAV_PARAM_ERROR = common.MAV_PARAM_ERROR

const (
	// No error occurred (not expected in PARAM_ERROR but may be used in future implementations.
	MAV_PARAM_ERROR_NO_ERROR MAV_PARAM_ERROR = common.MAV_PARAM_ERROR_NO_ERROR
	// Parameter does not exist
	MAV_PARAM_ERROR_DOES_NOT_EXIST MAV_PARAM_ERROR = common.MAV_PARAM_ERROR_DOES_NOT_EXIST
	// Parameter value does not fit within accepted range
	MAV_PARAM_ERROR_VALUE_OUT_OF_RANGE MAV_PARAM_ERROR = common.MAV_PARAM_ERROR_VALUE_OUT_OF_RANGE
	// Caller is not permitted to set the value of this parameter
	MAV_PARAM_ERROR_PERMISSION_DENIED MAV_PARAM_ERROR = common.MAV_PARAM_ERROR_PERMISSION_DENIED
	// Unknown component specified
	MAV_PARAM_ERROR_COMPONENT_NOT_FOUND MAV_PARAM_ERROR = common.MAV_PARAM_ERROR_COMPONENT_NOT_FOUND
	// Parameter is read-only
	MAV_PARAM_ERROR_READ_ONLY MAV_PARAM_ERROR = common.MAV_PARAM_ERROR_READ_ONLY
	// Parameter data type (MAV_PARAM_TYPE) is not supported by flight stack (at all)
	MAV_PARAM_ERROR_TYPE_UNSUPPORTED MAV_PARAM_ERROR = common.MAV_PARAM_ERROR_TYPE_UNSUPPORTED
	// Parameter type does not match expected type
	MAV_PARAM_ERROR_TYPE_MISMATCH MAV_PARAM_ERROR = common.MAV_PARAM_ERROR_TYPE_MISMATCH
	// Parameter exists but reading failed
	MAV_PARAM_ERROR_READ_FAIL MAV_PARAM_ERROR = common.MAV_PARAM_ERROR_READ_FAIL
)
