//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
)

// The frame of a target observation from an onboard sensor.
type TARGET_OBS_FRAME uint64

const (
	// NED local tangent frame (x: North, y: East, z: Down) with origin fixed relative to earth.
	TARGET_OBS_FRAME_LOCAL_NED TARGET_OBS_FRAME = 0
	// FRD local frame aligned to the vehicle's attitude (x: Forward, y: Right, z: Down) with an origin that travels with vehicle.
	TARGET_OBS_FRAME_BODY_FRD TARGET_OBS_FRAME = 1
	// NED local tangent frame (x: North, y: East, z: Down) with an origin that travels with vehicle.
	TARGET_OBS_FRAME_LOCAL_OFFSET_NED TARGET_OBS_FRAME = 2
	// Other sensor frame for target observations neither in local NED nor in body FRD.
	TARGET_OBS_FRAME_OTHER TARGET_OBS_FRAME = 3
)

var value_to_label_TARGET_OBS_FRAME = map[TARGET_OBS_FRAME]string{
	TARGET_OBS_FRAME_LOCAL_NED:        "TARGET_OBS_FRAME_LOCAL_NED",
	TARGET_OBS_FRAME_BODY_FRD:         "TARGET_OBS_FRAME_BODY_FRD",
	TARGET_OBS_FRAME_LOCAL_OFFSET_NED: "TARGET_OBS_FRAME_LOCAL_OFFSET_NED",
	TARGET_OBS_FRAME_OTHER:            "TARGET_OBS_FRAME_OTHER",
}

var label_to_value_TARGET_OBS_FRAME = map[string]TARGET_OBS_FRAME{
	"TARGET_OBS_FRAME_LOCAL_NED":        TARGET_OBS_FRAME_LOCAL_NED,
	"TARGET_OBS_FRAME_BODY_FRD":         TARGET_OBS_FRAME_BODY_FRD,
	"TARGET_OBS_FRAME_LOCAL_OFFSET_NED": TARGET_OBS_FRAME_LOCAL_OFFSET_NED,
	"TARGET_OBS_FRAME_OTHER":            TARGET_OBS_FRAME_OTHER,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e TARGET_OBS_FRAME) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_TARGET_OBS_FRAME[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *TARGET_OBS_FRAME) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_TARGET_OBS_FRAME[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = TARGET_OBS_FRAME(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e TARGET_OBS_FRAME) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
