//autogenerated:yes
//nolint:revive,misspell,govet,lll
package marsh

// These values are an extra cue that should be added to accelerations and rotations etc. resulting from aircraft state, with the resulting cue being the sum of the latest aircraft and extra values. An example use case would be a cockpit shaker.
type MessageMotionCueExtra struct {
	// Timestamp (time since system boot).
	TimeBootMs uint32
	// Roll velocity, positive right.
	VelRoll float32
	// Pitch velocity, positive nose up.
	VelPitch float32
	// Yaw velocity, positive right.
	VelYaw float32
	// X axis (surge) acceleration, positive forward.
	AccX float32
	// Y axis (sway) acceleration, positive right.
	AccY float32
	// Z axis (heave) acceleration, positive down.
	AccZ float32
}

// GetID implements the message.Message interface.
func (*MessageMotionCueExtra) GetID() uint32 {
	return 52504
}
