---
description: Explains how to use the S3 storage drivers
keywords: registry, service, driver, images, storage,  S3
title: S3 storage driver
---

An implementation of the `storagedriver.StorageDriver` interface which uses
Amazon S3 or S3 compatible services for object storage.

> **Note** When S3 storage is used, registry redirects to a pre-signed URL for the requested object.
> By not having to serve the stored images directly, this allows running registry on hosts with lightweight resource requirements.

## Parameters

| Parameter     | Required | Description                                                                                                                                                                                                                                                         |
|:--------------|:---------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `accesskey` | no     | Your AWS Access Key. If you use [IAM roles](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html), omit to fetch temporary credentials from IAM. |
| `secretkey`  | no   | Your AWS Secret Key. If you use [IAM roles](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html), omit to fetch temporary credentials from IAM. |
| `region` |  yes  | The AWS region in which your bucket exists. |
| `regionendpoint` | no | Endpoint for S3 compatible storage services (Minio, etc). |
| `forcepathstyle` | no | To enable path-style addressing when the value is set to `true`. The default is `false`. |
| `bucket`  | yes | The bucket name in which you want to store the registry's data. |
| `encrypt`  | no | Specifies whether the registry stores the image in encrypted format or not. A boolean value. The default is `false`. |
| `keyid`  | no | Optional KMS key ID to use for encryption (encrypt must be true, or this parameter is ignored). The default is `none`. |
| `secure`  | no | Indicates whether to use HTTPS instead of HTTP. A boolean value. The default is `true`. |
| `skipverify`  | no  | Skips TLS verification when the value is set to `true`. The default is `false`. |
| `v4auth`  | no | Indicates whether the registry uses Version 4 of AWS's authentication. The default is `true`. |
| `chunksize`  | no | The S3 API requires multipart upload chunks to be at least 5MB. This value should be a number that is larger than 5 * 1024 * 1024.|
| `multipartcopychunksize` | no | Default chunk size for all but the last S3 Multipart Upload part when copying stored objects. |
| `multipartcopymaxconcurrency` | no | Max number of concurrent S3 Multipart Upload operations when copying stored objects. |
| `multipartcopythresholdsize` | no | Default object size above which S3 Multipart Upload will be used when copying stored objects. |
| `rootdirectory`  | no | This is a prefix that is applied to all S3 keys to allow you to segment data in your bucket if necessary. |
| `storageclass`  | no | The S3 storage class applied to each registry file. The default is `STANDARD`. |
| `useragent` | no | The `User-Agent` header value for S3 API operations. |
| `usedualstack` | no | Use AWS dual-stack API endpoints. |
| `accelerate` | no | Enable S3 Transfer Acceleration. |
| `objectacl`  | no | The S3 Canned ACL for objects. The default value is "private". |
| `loglevel`  | no | The log level for the S3 client. The default value is `off`. |

> **Note** You can provide empty strings for your access and secret keys to run the driver
> on an ec2 instance and handles authentication with the instance's credentials. If you
> use [IAM roles](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html),
> omit these keys to fetch temporary credentials from IAM.

`region`: The name of the aws region in which you would like to store objects (for example `us-east-1`). For a list of regions, see [Regions, Availability Zones, and Local Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html).

`regionendpoint`: (optional) Endpoint URL for S3 compatible APIs. This should not be provided when using Amazon S3.

`forcepathstyle`: (optional) Force path style for S3 compatible APIs. Some manufacturers only support force path style, while others only support DNS based bucket routing. Amazon S3 supports both. The value of this parameter applies, regardless of the region settings.

`bucket`: The name of your S3 bucket where you wish to store objects. The bucket must exist prior to the driver initialization.

`encrypt`: (optional) Whether you would like your data encrypted on the server side (defaults to false if not specified).

`keyid`: (optional) Whether you would like your data encrypted with this KMS key ID (defaults to none if not specified, is ignored if encrypt is not true).

`secure`: (optional) Whether you would like to transfer data to the bucket over ssl or not. Defaults to true (meaning transferring over ssl) if not specified. While setting this to false improves performance, it is not recommended due to security concerns.

`v4auth`: (optional) Whether you would like to use aws signature version 4 with your requests. This defaults to `false` if not specified. The `eu-central-1` region does not work with version 2 signatures, so the driver errors out if initialized with this region and v4auth set to `false`.

`chunksize`: (optional) The default part size for multipart uploads (performed by WriteStream) to S3. The default is 10 MB. Keep in mind that the minimum part size for S3 is 5MB. Depending on the speed of your connection to S3, a larger chunk size may result in better performance; faster connections benefit from larger chunk sizes.

`multipartcopychunksize`: (optional) The default chunk size for all but the last Upload Part in the S3 Multipart Upload operation when copying stored objects. Default value is set to `32 MB`.

`multipartcopymaxconcurrency`: (optional) The default maximum number of concurrent Upload Part operations in the S3 Multipart Upload when copying stored objects. Default value is set to `100`.

`multipartcopythresholdsize`: (optional) The default S3 object size above which multipart copy will be used when copying the object. Otherwise the object is copied with a single S3 API operation. Default value is set to ` 32 MB`.

`rootdirectory`: (optional) The root directory tree in which all registry files are stored. Defaults to the empty string (bucket root).

`storageclass`: (optional) The storage class applied to each registry file. Defaults to STANDARD. Valid options are STANDARD and REDUCED_REDUNDANCY.

`useragent`: (optional) The `User-Agent` header value for S3 API operations.

`usedualstack`: (optional) Use AWS dual-stack API endpoints which support requests to S3 buckets over IPv6 and IPv4.

`accelerate`: (optional) Enable S3 transfer acceleration for faster transfers of files over long distances.

`objectacl`: (optional) The canned object ACL to be applied to each registry object. Defaults to `private`. If you are using a bucket owned by another AWS account, it is recommended that you set this to `bucket-owner-full-control` so that the bucket owner can access your objects. Other valid options are available in the [AWS S3 documentation](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl).

`loglevel`: (optional) Valid values are: `off` (default), `debug`, `debugwithsigning`, `debugwithhttpbody`, `debugwithrequestretries`, `debugwithrequesterrors` and `debugwitheventstreambody`. See the [AWS SDK for Go API reference](https://docs.aws.amazon.com/sdk-for-go/api/aws/#LogLevelType) for details.

## S3 permission scopes

The following AWS policy is required by the registry for push and pull. Make sure to replace `S3_BUCKET_NAME` with the name of your bucket.

```
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "s3:ListBucket",
        "s3:GetBucketLocation",
        "s3:ListBucketMultipartUploads"
      ],
      "Resource": "arn:aws:s3:::S3_BUCKET_NAME"
    },
    {
      "Effect": "Allow",
      "Action": [
        "s3:PutObject",
        "s3:GetObject",
        "s3:DeleteObject",
        "s3:ListMultipartUploadParts",
        "s3:AbortMultipartUpload"
      ],
      "Resource": "arn:aws:s3:::S3_BUCKET_NAME/*"
    }
  ]
}
```

See [the S3 policy documentation](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html) for more details.

# CloudFront as Middleware with S3 backend

## Use Case

Adding CloudFront as a middleware for your S3 backed registry can dramatically
improve pull times. Your registry can retrieve your images
from edge servers, rather than the geographically limited location of your S3
bucket. The farther your registry is from your bucket, the more improvements are
possible. See [Amazon CloudFront](https://aws.amazon.com/cloudfront/details/).

An alternative method for CloudFront that requires less configuration and will use
the same edge servers is [S3 Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html).
Please check acceleration [Requirements](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html#transfer-acceleration-requirements)
to see whether you need CloudFront or S3 Transfer Acceleration.

## Configuring CloudFront for Distribution

If you are unfamiliar with creating a CloudFront distribution, see [Getting
Started with
Cloudfront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/GettingStarted.html).

Defaults can be kept in most areas except:

### Origin:

  - The CloudFront distribution must be created such that the `Origin Path` is set
    to the directory level of the root "docker" key in S3. If your registry exists
    on the root of the bucket, this path should be left blank.

  - For private S3 buckets, you must set `Restrict Bucket Access` to `Yes`. See
    the [CloudFront documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).


### Behaviors:

  - Viewer Protocol Policy: HTTPS Only
  - Allowed HTTP Methods: GET, HEAD, OPTIONS, PUT, POST, PATCH, DELETE
  - Cached HTTP Methods: OPTIONS (checked)
  - Restrict Viewer Access (Use Signed URLs or Signed Cookies): Yes
    - Trusted Signers: Self (Can add other accounts as long as you have access to CloudFront Key Pairs for those additional accounts)

## Registry configuration

Here the `middleware` option is used. It is still important to keep the
`storage` option, because CloudFront only handles `pull` actions; `push` actions
are still directly written to S3.

The following example shows a minimum configuration:

```yaml
...
storage:
  s3:
    region: us-east-1
    bucket: docker.myregistry.com
middleware:
  storage:
    - name: cloudfront
      options:
        baseurl: https://abcdefghijklmn.cloudfront.net/
        privatekey: /etc/docker/cloudfront/pk-ABCEDFGHIJKLMNOPQRST.pem
        keypairid: ABCEDFGHIJKLMNOPQRST
...
```

## CloudFront Key-Pair

A CloudFront key-pair is required for all AWS accounts needing access to your
CloudFront distribution. You must have access to your AWS account's root credentials to create the required Cloudfront keypair. For information, see [Creating CloudFront Key
Pairs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html#private-content-creating-cloudfront-key-pairs).
