// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// EncryptionConfiguration encryption configuration
//
// swagger:model encryptionConfiguration
type EncryptionConfiguration struct {
	MetadataFields

	// aws
	Aws *AwsConfiguration `json:"aws,omitempty"`

	// azure
	Azure *AzureConfiguration `json:"azure,omitempty"`

	// gcp
	Gcp *GcpConfiguration `json:"gcp,omitempty"`

	// gemalto
	Gemalto *GemaltoConfiguration `json:"gemalto,omitempty"`

	// image
	Image string `json:"image,omitempty"`

	// kms mtls
	KmsMtls *EncryptionConfigurationAO1KmsMtls `json:"kms_mtls,omitempty"`

	// minio mtls
	MinioMtls *KeyPairConfiguration `json:"minio_mtls,omitempty"`

	// raw
	Raw string `json:"raw,omitempty"`

	// replicas
	Replicas string `json:"replicas,omitempty"`

	// secrets to be deleted
	SecretsToBeDeleted []string `json:"secretsToBeDeleted"`

	// security context
	SecurityContext *SecurityContext `json:"securityContext,omitempty"`

	// server tls
	ServerTLS *KeyPairConfiguration `json:"server_tls,omitempty"`

	// vault
	Vault *VaultConfiguration `json:"vault,omitempty"`
}

// UnmarshalJSON unmarshals this object from a JSON structure
func (m *EncryptionConfiguration) UnmarshalJSON(raw []byte) error {
	// AO0
	var aO0 MetadataFields
	if err := swag.ReadJSON(raw, &aO0); err != nil {
		return err
	}
	m.MetadataFields = aO0

	// AO1
	var dataAO1 struct {
		Aws *AwsConfiguration `json:"aws,omitempty"`

		Azure *AzureConfiguration `json:"azure,omitempty"`

		Gcp *GcpConfiguration `json:"gcp,omitempty"`

		Gemalto *GemaltoConfiguration `json:"gemalto,omitempty"`

		Image string `json:"image,omitempty"`

		KmsMtls *EncryptionConfigurationAO1KmsMtls `json:"kms_mtls,omitempty"`

		MinioMtls *KeyPairConfiguration `json:"minio_mtls,omitempty"`

		Raw string `json:"raw,omitempty"`

		Replicas string `json:"replicas,omitempty"`

		SecretsToBeDeleted []string `json:"secretsToBeDeleted"`

		SecurityContext *SecurityContext `json:"securityContext,omitempty"`

		ServerTLS *KeyPairConfiguration `json:"server_tls,omitempty"`

		Vault *VaultConfiguration `json:"vault,omitempty"`
	}
	if err := swag.ReadJSON(raw, &dataAO1); err != nil {
		return err
	}

	m.Aws = dataAO1.Aws

	m.Azure = dataAO1.Azure

	m.Gcp = dataAO1.Gcp

	m.Gemalto = dataAO1.Gemalto

	m.Image = dataAO1.Image

	m.KmsMtls = dataAO1.KmsMtls

	m.MinioMtls = dataAO1.MinioMtls

	m.Raw = dataAO1.Raw

	m.Replicas = dataAO1.Replicas

	m.SecretsToBeDeleted = dataAO1.SecretsToBeDeleted

	m.SecurityContext = dataAO1.SecurityContext

	m.ServerTLS = dataAO1.ServerTLS

	m.Vault = dataAO1.Vault

	return nil
}

// MarshalJSON marshals this object to a JSON structure
func (m EncryptionConfiguration) MarshalJSON() ([]byte, error) {
	_parts := make([][]byte, 0, 2)

	aO0, err := swag.WriteJSON(m.MetadataFields)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, aO0)
	var dataAO1 struct {
		Aws *AwsConfiguration `json:"aws,omitempty"`

		Azure *AzureConfiguration `json:"azure,omitempty"`

		Gcp *GcpConfiguration `json:"gcp,omitempty"`

		Gemalto *GemaltoConfiguration `json:"gemalto,omitempty"`

		Image string `json:"image,omitempty"`

		KmsMtls *EncryptionConfigurationAO1KmsMtls `json:"kms_mtls,omitempty"`

		MinioMtls *KeyPairConfiguration `json:"minio_mtls,omitempty"`

		Raw string `json:"raw,omitempty"`

		Replicas string `json:"replicas,omitempty"`

		SecretsToBeDeleted []string `json:"secretsToBeDeleted"`

		SecurityContext *SecurityContext `json:"securityContext,omitempty"`

		ServerTLS *KeyPairConfiguration `json:"server_tls,omitempty"`

		Vault *VaultConfiguration `json:"vault,omitempty"`
	}

	dataAO1.Aws = m.Aws

	dataAO1.Azure = m.Azure

	dataAO1.Gcp = m.Gcp

	dataAO1.Gemalto = m.Gemalto

	dataAO1.Image = m.Image

	dataAO1.KmsMtls = m.KmsMtls

	dataAO1.MinioMtls = m.MinioMtls

	dataAO1.Raw = m.Raw

	dataAO1.Replicas = m.Replicas

	dataAO1.SecretsToBeDeleted = m.SecretsToBeDeleted

	dataAO1.SecurityContext = m.SecurityContext

	dataAO1.ServerTLS = m.ServerTLS

	dataAO1.Vault = m.Vault

	jsonDataAO1, errAO1 := swag.WriteJSON(dataAO1)
	if errAO1 != nil {
		return nil, errAO1
	}
	_parts = append(_parts, jsonDataAO1)
	return swag.ConcatJSON(_parts...), nil
}

// Validate validates this encryption configuration
func (m *EncryptionConfiguration) Validate(formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with MetadataFields
	if err := m.MetadataFields.Validate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAws(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAzure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGcp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGemalto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKmsMtls(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinioMtls(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityContext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerTLS(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVault(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EncryptionConfiguration) validateAws(formats strfmt.Registry) error {

	if swag.IsZero(m.Aws) { // not required
		return nil
	}

	if m.Aws != nil {
		if err := m.Aws.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aws")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("aws")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) validateAzure(formats strfmt.Registry) error {

	if swag.IsZero(m.Azure) { // not required
		return nil
	}

	if m.Azure != nil {
		if err := m.Azure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("azure")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) validateGcp(formats strfmt.Registry) error {

	if swag.IsZero(m.Gcp) { // not required
		return nil
	}

	if m.Gcp != nil {
		if err := m.Gcp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gcp")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("gcp")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) validateGemalto(formats strfmt.Registry) error {

	if swag.IsZero(m.Gemalto) { // not required
		return nil
	}

	if m.Gemalto != nil {
		if err := m.Gemalto.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gemalto")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("gemalto")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) validateKmsMtls(formats strfmt.Registry) error {

	if swag.IsZero(m.KmsMtls) { // not required
		return nil
	}

	if m.KmsMtls != nil {
		if err := m.KmsMtls.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("kms_mtls")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("kms_mtls")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) validateMinioMtls(formats strfmt.Registry) error {

	if swag.IsZero(m.MinioMtls) { // not required
		return nil
	}

	if m.MinioMtls != nil {
		if err := m.MinioMtls.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("minio_mtls")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("minio_mtls")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) validateSecurityContext(formats strfmt.Registry) error {

	if swag.IsZero(m.SecurityContext) { // not required
		return nil
	}

	if m.SecurityContext != nil {
		if err := m.SecurityContext.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("securityContext")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("securityContext")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) validateServerTLS(formats strfmt.Registry) error {

	if swag.IsZero(m.ServerTLS) { // not required
		return nil
	}

	if m.ServerTLS != nil {
		if err := m.ServerTLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server_tls")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("server_tls")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) validateVault(formats strfmt.Registry) error {

	if swag.IsZero(m.Vault) { // not required
		return nil
	}

	if m.Vault != nil {
		if err := m.Vault.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vault")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("vault")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this encryption configuration based on the context it is used
func (m *EncryptionConfiguration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with MetadataFields
	if err := m.MetadataFields.ContextValidate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAws(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAzure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGcp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGemalto(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKmsMtls(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinioMtls(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecurityContext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServerTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVault(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EncryptionConfiguration) contextValidateAws(ctx context.Context, formats strfmt.Registry) error {

	if m.Aws != nil {
		if err := m.Aws.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aws")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("aws")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) contextValidateAzure(ctx context.Context, formats strfmt.Registry) error {

	if m.Azure != nil {
		if err := m.Azure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("azure")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) contextValidateGcp(ctx context.Context, formats strfmt.Registry) error {

	if m.Gcp != nil {
		if err := m.Gcp.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gcp")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("gcp")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) contextValidateGemalto(ctx context.Context, formats strfmt.Registry) error {

	if m.Gemalto != nil {
		if err := m.Gemalto.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gemalto")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("gemalto")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) contextValidateKmsMtls(ctx context.Context, formats strfmt.Registry) error {

	if m.KmsMtls != nil {
		if err := m.KmsMtls.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("kms_mtls")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("kms_mtls")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) contextValidateMinioMtls(ctx context.Context, formats strfmt.Registry) error {

	if m.MinioMtls != nil {
		if err := m.MinioMtls.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("minio_mtls")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("minio_mtls")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) contextValidateSecurityContext(ctx context.Context, formats strfmt.Registry) error {

	if m.SecurityContext != nil {
		if err := m.SecurityContext.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("securityContext")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("securityContext")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) contextValidateServerTLS(ctx context.Context, formats strfmt.Registry) error {

	if m.ServerTLS != nil {
		if err := m.ServerTLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server_tls")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("server_tls")
			}
			return err
		}
	}

	return nil
}

func (m *EncryptionConfiguration) contextValidateVault(ctx context.Context, formats strfmt.Registry) error {

	if m.Vault != nil {
		if err := m.Vault.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vault")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("vault")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EncryptionConfiguration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EncryptionConfiguration) UnmarshalBinary(b []byte) error {
	var res EncryptionConfiguration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EncryptionConfigurationAO1KmsMtls encryption configuration a o1 kms mtls
//
// swagger:model EncryptionConfigurationAO1KmsMtls
type EncryptionConfigurationAO1KmsMtls struct {

	// ca
	Ca string `json:"ca,omitempty"`

	// crt
	Crt string `json:"crt,omitempty"`

	// key
	Key string `json:"key,omitempty"`
}

// Validate validates this encryption configuration a o1 kms mtls
func (m *EncryptionConfigurationAO1KmsMtls) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this encryption configuration a o1 kms mtls based on context it is used
func (m *EncryptionConfigurationAO1KmsMtls) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EncryptionConfigurationAO1KmsMtls) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EncryptionConfigurationAO1KmsMtls) UnmarshalBinary(b []byte) error {
	var res EncryptionConfigurationAO1KmsMtls
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
