// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const DirectPVLogo = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      version="1.1"
      id="Layer_1"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
      className={`min-icon`}
      fill={"currentcolor"}
      viewBox="0 0 416.5 121.19"
    >
      <rect id="Rectangle_2" x="60.81" y=".48" width="10.5" height="30.9" />
      <path
        id="Path_1"
        d="M48.11,.98L26.81,13.98c-.3,.2-.7,.2-1,0L4.51,.98c-.5-.3-1-.4-1.5-.4h0C1.41,.58,.11,1.88,.11,3.48V31.48H10.61v-13.4c0-.6,.5-1,1.1-1,.2,0,.4,.1,.5,.2l11.9,7.3c1.2,.7,2.6,.7,3.8,0l12.6-7.4c.5-.3,1.1-.1,1.4,.4,.1,.2,.1,.3,.1,.5v13.4h10.5V3.48c0-1.6-1.3-2.9-2.9-2.9h0c-.5-.1-1,.1-1.5,.4Z"
      />
      <path
        id="Path_2"
        d="M123.61,.48h-10.6V14.58c0,.6-.5,1-1,1-.2,0-.3,0-.5-.1L83.91,.88c-.4-.2-.9-.3-1.4-.3h0c-1.6,0-2.9,1.3-2.9,2.9V31.48h10.5v-14.1c0-.6,.5-1,1.1-1,.2,0,.3,0,.5,.1l27.6,14.7c.4,.2,.9,.3,1.4,.3h0c1.6,0,2.9-1.3,2.9-2.9V.48Z"
      />
      <path id="Path_3" d="M131.81,31.5V.5h4.8V31.4l-4.8,.1Z" />
      <path
        id="Path_4"
        d="M165.01,32c-13,0-22.2-6.2-22.2-16S152.11,0,165.01,0s22.2,6.2,22.2,16-9.1,16-22.2,16Zm0-27.9c-9.6,0-17.1,4.2-17.1,11.9s7.4,11.9,17.1,11.9,17.1-4.2,17.1-11.9-7.5-11.9-17.1-11.9Z"
      />
      <path d="M0,50.99H26c11.3,0,20.3,3.1,26.9,9.4,6.6,6.3,10,14.6,10,25.2s-3.3,18.9-10,25.2c-6.6,6.3-15.6,9.4-26.9,9.4H0V50.99Zm26,7.5H7.9v54.2H26c9.2,0,16.2-2.4,21.1-7.3s7.4-11.5,7.4-19.8-2.5-14.9-7.4-19.8c-4.8-4.8-11.9-7.3-21.1-7.3Z" />
      <path d="M81.3,51.59c1.4,0,2.7,.5,3.7,1.5s1.5,2.2,1.5,3.7-.5,2.7-1.5,3.7-2.2,1.5-3.7,1.5-2.7-.5-3.7-1.5-1.5-2.2-1.5-3.7,.5-2.7,1.5-3.7c1-1,2.2-1.5,3.7-1.5Zm3.7,21.8v46.8h-7.4v-46.8h7.4Z" />
      <path d="M123.4,72.49c3.4,0,6.3,.5,8.6,1.6l-1.8,7.3c-2.3-1.3-5-1.9-8.1-1.9-3.7,0-6.7,1.3-9,4s-3.5,6.2-3.5,10.6v26.2h-7.4v-46.9h7.3v6.6c1.6-2.4,3.6-4.3,6-5.6s5.1-1.9,7.9-1.9Z" />
      <path d="M160.9,72.49c6.4,0,11.6,2.3,15.7,6.8,4.1,4.5,6.2,10.3,6.2,17.4,0,1,0,1.9-.1,2.8h-37.5c.5,4.9,2.3,8.6,5.3,11.3,3.1,2.7,6.8,4,11.2,4,5.6,0,10.5-2,14.8-5.9l4,5c-5.1,4.9-11.5,7.3-19.2,7.3-6.9,0-12.6-2.2-17-6.7s-6.6-10.3-6.6-17.6,2.2-12.9,6.6-17.5c4.4-4.7,9.9-6.9,16.6-6.9Zm-.1,6.5c-4.2,0-7.7,1.3-10.4,4-2.7,2.6-4.4,6.1-5,10.4h30c-.5-4.4-2-7.9-4.7-10.5-2.6-2.6-6-3.9-9.9-3.9Z" />
      <path d="M217.2,72.49c3.5,0,6.7,.6,9.7,1.9s5.5,3.1,7.6,5.5l-4.7,5c-3.7-3.6-8-5.4-12.8-5.4s-8.6,1.6-11.8,4.9c-3.1,3.3-4.7,7.4-4.7,12.4s1.6,9.2,4.7,12.5c3.1,3.3,7.1,4.9,11.8,4.9s9.2-1.8,12.9-5.5l4.6,5c-2.1,2.4-4.7,4.2-7.7,5.5s-6.2,1.9-9.7,1.9c-7.1,0-12.9-2.3-17.4-6.9s-6.8-10.4-6.8-17.4,2.3-12.8,6.8-17.4c4.6-4.6,10.4-6.9,17.5-6.9Z" />
      <path d="M279.6,73.39v6.7h-20.2v23.6c0,3.5,.8,6.2,2.5,7.9,1.7,1.7,3.9,2.6,6.8,2.6,3.5,0,6.8-1.1,9.8-3.3l3.5,5.6c-4.1,3.1-8.7,4.6-13.9,4.6s-9.1-1.4-11.9-4.3-4.2-7.2-4.2-13v-23.7h-10.2v-6.7h10.2v-14.9h7.4v14.9h20.2Z" />
      <path d="M320,92.39h-18.2v27.8h-8V50.99h26.1c7.7,0,13.7,1.8,18,5.5s6.4,8.7,6.4,15.2-2.1,11.5-6.4,15.2c-4.2,3.6-10.2,5.5-17.9,5.5Zm-.2-33.9h-17.9v26.4h17.9c5.4,0,9.4-1.1,12.2-3.3,2.8-2.2,4.2-5.5,4.2-9.9s-1.4-7.7-4.2-9.9-6.9-3.3-12.2-3.3Z" />
      <path d="M416.5,50.99l-27.7,69.1h-9.8l-27.7-69.1h8.4l24.3,61.2,24.3-61.2h8.2Z" />
    </svg>
  );
};

export default DirectPVLogo;
