// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const EnterpriseLightLogo = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 99.785 10.08"
    className={"min-icon"}
    fill={"currentcolor"}
    {...props}
  >
    <path
      d="M8.351-1.155H2.625v-3.2H8.1V-5.516H2.625V-8.645H8.281V-9.8H1.393V0H8.351ZM20.538-9.8H19.306v7.693l-5.929-7.7H12.264V0H13.5L13.5-7.693l5.922,7.7h1.113Zm11,0H23.618v1.169h3.346V0H28.2V-8.631h3.339ZM41.566-1.155H35.84v-3.2h5.474V-5.516H35.84V-8.645H41.5V-9.8H34.608V0h6.958ZM45.479-9.8V0h1.232V-4.228h1.148L51.226,0h1.526L49.3-4.228h.077c2.1,0,3.423-1.092,3.423-2.793,0-1.785-1.218-2.779-3.43-2.779Zm3.864,1.155c1.421,0,2.177.539,2.177,1.624s-.735,1.673-2.177,1.673H46.711v-3.3ZM60.1-3.92c2.212,0,3.465-1.106,3.465-2.94S62.314-9.8,60.1-9.8H56.378V0H57.61V-3.92Zm-.028-4.718c1.449,0,2.212.588,2.212,1.778s-.763,1.778-2.212,1.778H57.61V-8.638ZM67.067-9.8V0H68.3V-4.228h1.148L72.814,0H74.34L70.889-4.228h.077c2.1,0,3.423-1.092,3.423-2.793,0-1.785-1.218-2.779-3.43-2.779Zm3.864,1.155c1.421,0,2.177.539,2.177,1.624s-.735,1.673-2.177,1.673H68.3v-3.3ZM79.2-9.8H77.966V0H79.2Zm11.221.931A6,6,0,0,0,86.891-9.94c-2.065,0-3.745,1.057-3.745,2.947,0,1.673,1.288,2.422,2.9,2.618l.91.112c1.526.189,2.345.623,2.345,1.533,0,1.106-1.148,1.7-2.611,1.7A5.235,5.235,0,0,1,83.5-2.114l-.672.98A6.35,6.35,0,0,0,86.695.14c2.121,0,3.892-1.022,3.892-2.975,0-1.729-1.421-2.4-3.08-2.6l-.861-.1c-1.47-.182-2.219-.637-2.219-1.526,0-1.057,1.022-1.7,2.457-1.7a5.128,5.128,0,0,1,2.9.9Zm10.759,7.714H95.452v-3.2h5.474V-5.516H95.452V-8.645h5.656V-9.8H94.22V0h6.958Z"
      transform="translate(-1.393 9.94)"
      fill="#bccee6"
    />
  </svg>
);

export default EnterpriseLightLogo;
