// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const HardBucketQuotaIcon = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      className={`min-icon`}
      fill={"currentcolor"}
      viewBox="0 0 36.369 36.346"
      {...props}
    >
      <g id="hardquota-icn" transform="translate(-98.002 -28.027)">
        <path
          id="Trazado_7233"
          data-name="Trazado 7233"
          d="M344.76,203.93l2.664-2.664,8.15,8.15-2.664,2.664Z"
          transform="translate(-228.962 -160.744)"
          fill="#07193e"
        />
        <path
          id="Trazado_7234"
          data-name="Trazado 7234"
          d="M464.768,316.895a1.11,1.11,0,0,0-1.575,0l-2.827,2.827h0a1.111,1.111,0,0,0,0,1.575l5.182,5.182a1.114,1.114,0,0,0,.787.327,1.1,1.1,0,0,0,.808-.327l2.827-2.827a1.11,1.11,0,0,0,0-1.575Z"
          transform="translate(-335.926 -267.73)"
          fill="#07193e"
        />
        <path
          id="Trazado_7235"
          data-name="Trazado 7235"
          d="M235.486,84.317l-5.408-5.408a2.141,2.141,0,0,1-.157-.174L222.2,86.45c.061.052.121.105.178.161l5.4,5.4c.057.057.109.117.161.178l7.718-7.718a2.2,2.2,0,0,1-.178-.157Z"
          transform="translate(-115.243 -47.051)"
          fill="#07193e"
        />
        <path
          id="Trazado_7236"
          data-name="Trazado 7236"
          d="M337.566,36.693a1.912,1.912,0,0,0,2.706-2.7l-5.408-5.4a1.91,1.91,0,1,0-2.7,2.7Z"
          transform="translate(-216.754)"
          fill="#07193e"
        />
        <path
          id="Trazado_7237"
          data-name="Trazado 7237"
          d="M174.741,188.807a1.912,1.912,0,1,0-2.7,2.706l5.408,5.392a1.911,1.911,0,1,0,2.7-2.7Z"
          transform="translate(-68.177 -148.665)"
          fill="#07193e"
        />
        <path
          id="Trazado_7238"
          data-name="Trazado 7238"
          d="M143.562,432.083a3.239,3.239,0,0,1,.525.048v-.565a2.383,2.383,0,0,0-2.379-2.383h-15.63a2.383,2.383,0,0,0-2.379,2.383v.565a3.245,3.245,0,0,1,.525-.048Z"
          transform="translate(-23.844 -372.224)"
          fill="#07193e"
        />
        <path
          id="Trazado_7239"
          data-name="Trazado 7239"
          d="M122.1,482.968a2.379,2.379,0,0,0-2.379-2.379H100.381A2.379,2.379,0,0,0,98,482.968V484.3h24.1Z"
          transform="translate(0 -419.924)"
          fill="#07193e"
        />
      </g>
    </svg>
  );
};

export default HardBucketQuotaIcon;
