// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const HealIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="heal-icn"
        d="m157.546 239.085-4.729-4.747-24.864-24.809-29.5 29.555a57.519 57.519 0 0 1-81.482 0 57.729 57.729 0 0 1 0-81.769l29.5-29.547-24.864-24.927-4.635-4.629a57.738 57.738 0 0 1 0-81.777c21.764-21.913 59.749-21.913 81.482 0l4.729 4.645 24.77 24.911 29.593-29.555c21.764-21.913 59.718-21.913 81.482 0a57.738 57.738 0 0 1 0 81.777l-29.5 29.555 24.864 24.793 4.635 4.755a57.718 57.718 0 1 1-81.482 81.769Zm13.654-23.036 4.572 4.629c12.15 12.028 33.006 12.028 45.031 0a31.967 31.967 0 0 0 0-44.957l-4.791-4.747ZM35.261 175.721a31.814 31.814 0 0 0 0 44.957c11.962 12.028 32.943 12.028 44.968 0l29.471-29.547-45-45.09Zm22.954-72.88 6.482 6.52 81.638 81.769 6.482 6.5 44.968-45.074-6.482-6.52-81.603-81.63-6.514-6.52Zm117.556-67.992-29.436 29.557 44.965 44.955 29.5-29.555a31.6 31.6 0 0 0 9.238-22.541 31.28 31.28 0 0 0-9.238-22.416 32.381 32.381 0 0 0-45.031 0Zm-140.51 0a31.211 31.211 0 0 0-9.3 22.416 31.525 31.525 0 0 0 9.3 22.541l4.729 4.762 44.843-45.09-4.6-4.629a31.61 31.61 0 0 0-44.968 0Zm105.562 118.465a12.731 12.731 0 1 1 12.746 12.892 12.816 12.816 0 0 1-12.746-12.892Zm-25.616-25.546a12.808 12.808 0 1 1 12.745 12.773 12.747 12.747 0 0 1-12.744-12.773Zm-25.49-25.679a12.746 12.746 0 1 1 12.714 12.9 12.8 12.8 0 0 1-12.714-12.901Z"
      />
      <path
        data-name="heal-icn - Contorno"
        d="M198.286 256.5a57.755 57.755 0 0 1-41.094-17.062l-4.729-4.747-24.509-24.455-29.146 29.2a57.907 57.907 0 0 1-82.189 0A57.353 57.353 0 0 1 3.9 220.544a58.292 58.292 0 0 1-4.4-22.407 57.536 57.536 0 0 1 17.121-41.177l29.144-29.192-24.512-24.573-4.634-4.629a58.238 58.238 0 0 1 0-82.486A54.985 54.985 0 0 1 35.647 3.644 59.5 59.5 0 0 1 46.5.536a61.384 61.384 0 0 1 22.457 0A59.431 59.431 0 0 1 79.8 3.644a54.885 54.885 0 0 1 19.007 12.437l4.73 4.646 24.417 24.555 29.238-29.2a54.994 54.994 0 0 1 19.023-12.438A59.465 59.465 0 0 1 187.061.536a61.355 61.355 0 0 1 22.451 0 59.465 59.465 0 0 1 10.846 3.108 55 55 0 0 1 19.024 12.439 58.238 58.238 0 0 1 0 82.485l-29.143 29.2 24.515 24.445 4.631 4.751a57.534 57.534 0 0 1 17.115 41.173 58.292 58.292 0 0 1-4.4 22.407 58.2 58.2 0 0 1-53.811 35.956Zm-70.334-47.678 25.218 25.162 4.73 4.748a57.218 57.218 0 0 0 80.775-81.061l-.006-.006-4.632-4.752-25.216-25.144 29.852-29.909a57.238 57.238 0 0 0 0-81.069 54.007 54.007 0 0 0-18.681-12.217 58.461 58.461 0 0 0-10.663-3.055 60.354 60.354 0 0 0-22.084 0 58.461 58.461 0 0 0-10.663 3.055A54 54 0 0 0 157.9 16.788l-29.948 29.91-25.124-25.265-4.728-4.646A53.891 53.891 0 0 0 79.432 4.574a58.431 58.431 0 0 0-10.663-3.055 60.384 60.384 0 0 0-22.09 0 58.5 58.5 0 0 0-10.666 3.055 54 54 0 0 0-18.686 12.214 57.238 57.238 0 0 0 0 81.07l4.636 4.63 25.217 25.28-29.851 29.9A56.544 56.544 0 0 0 .5 198.137a57.3 57.3 0 0 0 4.327 22.024 56.362 56.362 0 0 0 12.5 18.568 57.019 57.019 0 0 0 80.776 0Zm70.381 21.377a33.611 33.611 0 0 1-12.273-2.293 31.079 31.079 0 0 1-10.641-6.876l-4.92-4.982 45.513-45.78 5.146 5.1a31.859 31.859 0 0 1 6.984 10.44 32.695 32.695 0 0 1-6.983 35.226 30.651 30.651 0 0 1-10.571 6.877 33.426 33.426 0 0 1-12.255 2.288Zm-22.209-9.874a30.085 30.085 0 0 0 10.3 6.653 32.98 32.98 0 0 0 23.8 0 29.659 29.659 0 0 0 10.229-6.654 31.294 31.294 0 0 0 0-44.25l-4.435-4.394-44.118 44.37Zm-118.4 9.874a33.463 33.463 0 0 1-12.264-2.293 30.418 30.418 0 0 1-10.554-6.879 32.165 32.165 0 0 1 0-45.664L64.7 145.332l45.707 45.8-29.82 29.9a30.63 30.63 0 0 1-10.593 6.874 33.555 33.555 0 0 1-12.273 2.293ZM64.7 146.75l-29.084 29.324a31.314 31.314 0 0 0 0 44.25 29.428 29.428 0 0 0 10.212 6.655 33.006 33.006 0 0 0 23.8 0 29.635 29.635 0 0 0 10.246-6.653l29.115-29.194Zm88.119 51.593-6.836-6.859-81.64-81.769-6.834-6.874 45.675-45.663 6.867 6.874 81.607 81.636 6.834 6.874Zm-93.9-95.5 6.132 6.163 81.637 81.769 6.129 6.149 44.262-44.367-6.131-6.167-81.605-81.632-6.16-6.166Zm94.65 63.863a13.334 13.334 0 0 1-13.245-13.391 13.231 13.231 0 1 1 13.245 13.391Zm0-25.664a12.316 12.316 0 0 0-12.245 12.273 12.23 12.23 0 1 0 20.867-8.667 12.1 12.1 0 0 0-8.622-3.607Zm-25.616 0a13 13 0 0 1-5.134-1.051 13.319 13.319 0 0 1-4.211-2.855 13.254 13.254 0 0 1 9.345-22.648 13.351 13.351 0 0 1 9.44 3.857 13.2 13.2 0 0 1 0 18.792 13.32 13.32 0 0 1-9.44 3.904Zm0-25.554a12.277 12.277 0 0 0 0 24.554 12.326 12.326 0 0 0 8.737-3.614 12.2 12.2 0 0 0 0-17.371 12.357 12.357 0 0 0-8.737-3.57Zm-25.522 0A13.347 13.347 0 0 1 93.1 92.729a13.255 13.255 0 0 1 22.607 9.36 13.353 13.353 0 0 1-13.276 13.398Zm0-25.664a12.3 12.3 0 0 0-12.214 12.265 12.246 12.246 0 1 0 24.49 0 12.331 12.331 0 0 0-12.277-12.265Zm88.869 20.245-45.672-45.663 29.788-29.909a30.775 30.775 0 0 1 10.606-6.947 33.717 33.717 0 0 1 24.527 0 30.776 30.776 0 0 1 10.607 6.947 31.725 31.725 0 0 1 6.981 10.426 32.714 32.714 0 0 1-6.983 35.237Zm-44.259-45.663 44.262 44.25 29.145-29.2a31.714 31.714 0 0 0 6.765-34.15 30.732 30.732 0 0 0-6.764-10.1 29.784 29.784 0 0 0-10.266-6.723 32.717 32.717 0 0 0-23.792 0 29.782 29.782 0 0 0-10.265 6.723ZM39.989 85.278l-5.083-5.119a32.15 32.15 0 0 1 0-45.661 32.11 32.11 0 0 1 45.679 0l4.952 4.98Zm17.725-59.32a30.554 30.554 0 0 0-22.095 9.24l-.006.006a31.314 31.314 0 0 0 0 44.247l4.376 4.408 44.138-44.381-4.256-4.28a30.629 30.629 0 0 0-22.157-9.24Z"
        fill="rgba(0,0,0,0)"
      />
      <path data-name="Rect\xE1ngulo 879" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default HealIcon;
