// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const IdentityMenuIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 17 12.782"
    {...props}
  >
    <path
      id="Sustracción_4"
      data-name="Sustracción 4"
      d="M14.01,11.782H1.99a2,2,0,0,1-1.99-2V2A2,2,0,0,1,1.99,0H14.01A2,2,0,0,1,16,2V9.786A2,2,0,0,1,14.01,11.782ZM2.793,10.4H6.814a1.166,1.166,0,0,0,1.055-.676A1.434,1.434,0,0,0,7.73,8.29,3.755,3.755,0,0,0,5.573,6.862a3.448,3.448,0,0,0-.791-.093c-.056,0-.116,0-.184,0A3.665,3.665,0,0,0,1.879,8.261q-.024.032-.046.065l-.015.023a1.411,1.411,0,0,0-.1,1.388,1.183,1.183,0,0,0,1.06.666ZM9.627,9.093a.627.627,0,1,0,0,1.254H14a.627.627,0,1,0,0-1.254Zm0-2.383a.627.627,0,1,0,0,1.255H14A.627.627,0,1,0,14,6.71ZM4.906.941A2.621,2.621,0,0,0,2.345,3.613,2.622,2.622,0,0,0,4.906,6.286a2.441,2.441,0,0,0,1-.211A2.538,2.538,0,0,0,6.718,5.5a2.677,2.677,0,0,0,.549-.85,2.739,2.739,0,0,0,.2-1.039A2.621,2.621,0,0,0,4.906.941ZM9.627,4.264a.627.627,0,1,0,0,1.254H14a.627.627,0,1,0,0-1.254Z"
      transform="translate(0.5 0.5)"
      stroke="rgba(0,0,0,0)"
      strokeWidth="1"
    />
  </svg>
);

export default IdentityMenuIcon;
