// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const UploadIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path data-name="Rect\xE1ngulo 870" fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 454"
        d="M16.412 256A16.487 16.487 0 0 1-.002 239.463V104.082c0-21.752 32.824-21.752 32.824 0v118.829h190.355V104.082c0-21.752 32.822-21.752 32.822 0v135.381a16.477 16.477 0 0 1-16.4 16.537Zm95.176-61.308V56.465L93 75.208c-15.262 15.385-38.471-8-23.205-23.393l46.5-46.878a16.345 16.345 0 0 1 23.408 0l46.51 46.878c15.266 15.39-7.949 38.777-23.211 23.393L144.41 56.464v138.227c0 10.872-8.205 16.307-16.41 16.307s-16.412-5.435-16.412-16.307Z"
      />
      <path
        data-name="Trazado 454 - Contorno"
        d="M239.6 256.5H16.416A17 17 0 0 1-.498 239.463V104.082a16.259 16.259 0 0 1 5.3-12.61 16.393 16.393 0 0 1 5.422-3.156 18.547 18.547 0 0 1 6.193-1.048 18.547 18.547 0 0 1 6.193 1.048 16.393 16.393 0 0 1 5.422 3.156 16.259 16.259 0 0 1 5.3 12.61v118.329h189.355V104.082a16.259 16.259 0 0 1 5.3-12.61 16.374 16.374 0 0 1 5.422-3.156 18.528 18.528 0 0 1 6.191-1.048 18.531 18.531 0 0 1 6.193 1.048 16.374 16.374 0 0 1 5.422 3.156 16.259 16.259 0 0 1 5.3 12.61v135.381a17.034 17.034 0 0 1-1.328 6.625 16.992 16.992 0 0 1-3.621 5.416 16.846 16.846 0 0 1-5.373 3.655 16.663 16.663 0 0 1-6.593 1.341ZM16.414 88.268a17.535 17.535 0 0 0-5.859.991 15.388 15.388 0 0 0-5.094 2.962 15.286 15.286 0 0 0-4.959 11.861v135.381A15.994 15.994 0 0 0 16.416 255.5H239.6a15.989 15.989 0 0 0 15.9-16.037V104.082a15.286 15.286 0 0 0-4.959-11.861 15.368 15.368 0 0 0-5.094-2.962 17.518 17.518 0 0 0-5.859-.991 17.515 17.515 0 0 0-5.857.991 15.368 15.368 0 0 0-5.094 2.962 15.286 15.286 0 0 0-4.959 11.861v119.329H32.323V104.082a15.286 15.286 0 0 0-4.959-11.861 15.388 15.388 0 0 0-5.094-2.962 17.526 17.526 0 0 0-5.86-.992ZM128 211.5a18.547 18.547 0 0 1-6.193-1.048 16.37 16.37 0 0 1-5.422-3.154 16.248 16.248 0 0 1-5.3-12.6V57.685L93.349 75.567a16.238 16.238 0 0 1-11.6 5.179 16.682 16.682 0 0 1-9.711-3.251 19.071 19.071 0 0 1-6.451-8.051 15.968 15.968 0 0 1-1.051-8.961 17 17 0 0 1 4.9-9.013l46.5-46.878a16.869 16.869 0 0 1 12.006-5.084 16.81 16.81 0 0 1 6.482 1.3 17.213 17.213 0 0 1 5.631 3.786l46.51 46.879a16.976 16.976 0 0 1 4.9 9.01 15.975 15.975 0 0 1-1.049 8.958 19.084 19.084 0 0 1-6.453 8.054 16.694 16.694 0 0 1-9.715 3.254 16.237 16.237 0 0 1-11.6-5.179l-17.736-17.882v137.013a16.249 16.249 0 0 1-5.3 12.6 16.351 16.351 0 0 1-5.422 3.154A18.527 18.527 0 0 1 128 211.5ZM112.088 55.252v139.441a15.275 15.275 0 0 0 4.959 11.855 15.365 15.365 0 0 0 5.094 2.961 17.538 17.538 0 0 0 5.859.991 17.547 17.547 0 0 0 5.859-.991 15.375 15.375 0 0 0 5.092-2.961 15.276 15.276 0 0 0 4.959-11.855V55.25l.855.862 18.592 18.744a15.257 15.257 0 0 0 10.891 4.883 15.7 15.7 0 0 0 9.133-3.067 18.064 18.064 0 0 0 6.111-7.625 14.955 14.955 0 0 0 .988-8.4 16 16 0 0 0-4.625-8.482l-46.51-46.878a16.222 16.222 0 0 0-5.3-3.567 15.825 15.825 0 0 0-6.1-1.222 15.868 15.868 0 0 0-11.295 4.789l-46.5 46.878a16.011 16.011 0 0 0-4.627 8.485 15 15 0 0 0 .988 8.4 18.055 18.055 0 0 0 6.111 7.623 15.688 15.688 0 0 0 9.129 3.064 15.259 15.259 0 0 0 10.893-4.883Z"
        fill="rgba(0,0,0,0)"
      />
    </g>
  </svg>
);

export default UploadIcon;
