// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package k_m_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// KMSMetricsOKCode is the HTTP code returned for type KMSMetricsOK
const KMSMetricsOKCode int = 200

/*
KMSMetricsOK A successful response.

swagger:response kMSMetricsOK
*/
type KMSMetricsOK struct {

	/*
	  In: Body
	*/
	Payload *models.KmsMetricsResponse `json:"body,omitempty"`
}

// NewKMSMetricsOK creates KMSMetricsOK with default headers values
func NewKMSMetricsOK() *KMSMetricsOK {

	return &KMSMetricsOK{}
}

// WithPayload adds the payload to the k m s metrics o k response
func (o *KMSMetricsOK) WithPayload(payload *models.KmsMetricsResponse) *KMSMetricsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the k m s metrics o k response
func (o *KMSMetricsOK) SetPayload(payload *models.KmsMetricsResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *KMSMetricsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
KMSMetricsDefault Generic error response.

swagger:response kMSMetricsDefault
*/
type KMSMetricsDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewKMSMetricsDefault creates KMSMetricsDefault with default headers values
func NewKMSMetricsDefault(code int) *KMSMetricsDefault {
	if code <= 0 {
		code = 500
	}

	return &KMSMetricsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the k m s metrics default response
func (o *KMSMetricsDefault) WithStatusCode(code int) *KMSMetricsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the k m s metrics default response
func (o *KMSMetricsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the k m s metrics default response
func (o *KMSMetricsDefault) WithPayload(payload *models.Error) *KMSMetricsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the k m s metrics default response
func (o *KMSMetricsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *KMSMetricsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
