// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package object

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// PutObjectRetentionOKCode is the HTTP code returned for type PutObjectRetentionOK
const PutObjectRetentionOKCode int = 200

/*
PutObjectRetentionOK A successful response.

swagger:response putObjectRetentionOK
*/
type PutObjectRetentionOK struct {
}

// NewPutObjectRetentionOK creates PutObjectRetentionOK with default headers values
func NewPutObjectRetentionOK() *PutObjectRetentionOK {

	return &PutObjectRetentionOK{}
}

// WriteResponse to the client
func (o *PutObjectRetentionOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

/*
PutObjectRetentionDefault Generic error response.

swagger:response putObjectRetentionDefault
*/
type PutObjectRetentionDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewPutObjectRetentionDefault creates PutObjectRetentionDefault with default headers values
func NewPutObjectRetentionDefault(code int) *PutObjectRetentionDefault {
	if code <= 0 {
		code = 500
	}

	return &PutObjectRetentionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the put object retention default response
func (o *PutObjectRetentionDefault) WithStatusCode(code int) *PutObjectRetentionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the put object retention default response
func (o *PutObjectRetentionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the put object retention default response
func (o *PutObjectRetentionDefault) WithPayload(payload *models.Error) *PutObjectRetentionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the put object retention default response
func (o *PutObjectRetentionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PutObjectRetentionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
