// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BucketReplicationRule bucket replication rule
//
// swagger:model bucketReplicationRule
type BucketReplicationRule struct {

	// bandwidth
	Bandwidth string `json:"bandwidth,omitempty"`

	// delete marker replication
	DeleteMarkerReplication bool `json:"delete_marker_replication,omitempty"`

	// deletes replication
	DeletesReplication bool `json:"deletes_replication,omitempty"`

	// destination
	Destination *BucketReplicationDestination `json:"destination,omitempty"`

	// existing objects
	ExistingObjects bool `json:"existingObjects,omitempty"`

	// health check period
	HealthCheckPeriod int64 `json:"healthCheckPeriod,omitempty"`

	// id
	ID string `json:"id,omitempty"`

	// metadata replication
	MetadataReplication bool `json:"metadata_replication,omitempty"`

	// prefix
	Prefix string `json:"prefix,omitempty"`

	// priority
	Priority int32 `json:"priority,omitempty"`

	// status
	// Enum: ["Enabled","Disabled"]
	Status string `json:"status,omitempty"`

	// storage class
	StorageClass string `json:"storageClass,omitempty"`

	// sync mode
	// Enum: ["async","sync"]
	SyncMode *string `json:"syncMode,omitempty"`

	// tags
	Tags string `json:"tags,omitempty"`
}

// Validate validates this bucket replication rule
func (m *BucketReplicationRule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSyncMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BucketReplicationRule) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(m.Destination) { // not required
		return nil
	}

	if m.Destination != nil {
		if err := m.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("destination")
			}
			return err
		}
	}

	return nil
}

var bucketReplicationRuleTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["Enabled","Disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bucketReplicationRuleTypeStatusPropEnum = append(bucketReplicationRuleTypeStatusPropEnum, v)
	}
}

const (

	// BucketReplicationRuleStatusEnabled captures enum value "Enabled"
	BucketReplicationRuleStatusEnabled string = "Enabled"

	// BucketReplicationRuleStatusDisabled captures enum value "Disabled"
	BucketReplicationRuleStatusDisabled string = "Disabled"
)

// prop value enum
func (m *BucketReplicationRule) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bucketReplicationRuleTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BucketReplicationRule) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

var bucketReplicationRuleTypeSyncModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["async","sync"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bucketReplicationRuleTypeSyncModePropEnum = append(bucketReplicationRuleTypeSyncModePropEnum, v)
	}
}

const (

	// BucketReplicationRuleSyncModeAsync captures enum value "async"
	BucketReplicationRuleSyncModeAsync string = "async"

	// BucketReplicationRuleSyncModeSync captures enum value "sync"
	BucketReplicationRuleSyncModeSync string = "sync"
)

// prop value enum
func (m *BucketReplicationRule) validateSyncModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bucketReplicationRuleTypeSyncModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BucketReplicationRule) validateSyncMode(formats strfmt.Registry) error {
	if swag.IsZero(m.SyncMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateSyncModeEnum("syncMode", "body", *m.SyncMode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this bucket replication rule based on the context it is used
func (m *BucketReplicationRule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BucketReplicationRule) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if m.Destination != nil {

		if swag.IsZero(m.Destination) { // not required
			return nil
		}

		if err := m.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("destination")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BucketReplicationRule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BucketReplicationRule) UnmarshalBinary(b []byte) error {
	var res BucketReplicationRule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
