// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// KmsMetricsResponse kms metrics response
//
// swagger:model kmsMetricsResponse
type KmsMetricsResponse struct {

	// audit events
	// Required: true
	AuditEvents *int64 `json:"auditEvents"`

	// cpus
	// Required: true
	Cpus *int64 `json:"cpus"`

	// error events
	// Required: true
	ErrorEvents *int64 `json:"errorEvents"`

	// heap alloc
	// Required: true
	HeapAlloc *int64 `json:"heapAlloc"`

	// heap objects
	HeapObjects int64 `json:"heapObjects,omitempty"`

	// latency histogram
	// Required: true
	LatencyHistogram []*KmsLatencyHistogram `json:"latencyHistogram"`

	// request active
	// Required: true
	RequestActive *int64 `json:"requestActive"`

	// request err
	// Required: true
	RequestErr *int64 `json:"requestErr"`

	// request fail
	// Required: true
	RequestFail *int64 `json:"requestFail"`

	// request o k
	// Required: true
	RequestOK *int64 `json:"requestOK"`

	// stack alloc
	// Required: true
	StackAlloc *int64 `json:"stackAlloc"`

	// threads
	// Required: true
	Threads *int64 `json:"threads"`

	// uptime
	// Required: true
	Uptime *int64 `json:"uptime"`

	// usable c p us
	// Required: true
	UsableCPUs *int64 `json:"usableCPUs"`
}

// Validate validates this kms metrics response
func (m *KmsMetricsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuditEvents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCpus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorEvents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHeapAlloc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyHistogram(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRequestActive(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRequestErr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRequestFail(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRequestOK(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStackAlloc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThreads(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUptime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsableCPUs(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KmsMetricsResponse) validateAuditEvents(formats strfmt.Registry) error {

	if err := validate.Required("auditEvents", "body", m.AuditEvents); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateCpus(formats strfmt.Registry) error {

	if err := validate.Required("cpus", "body", m.Cpus); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateErrorEvents(formats strfmt.Registry) error {

	if err := validate.Required("errorEvents", "body", m.ErrorEvents); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateHeapAlloc(formats strfmt.Registry) error {

	if err := validate.Required("heapAlloc", "body", m.HeapAlloc); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateLatencyHistogram(formats strfmt.Registry) error {

	if err := validate.Required("latencyHistogram", "body", m.LatencyHistogram); err != nil {
		return err
	}

	for i := 0; i < len(m.LatencyHistogram); i++ {
		if swag.IsZero(m.LatencyHistogram[i]) { // not required
			continue
		}

		if m.LatencyHistogram[i] != nil {
			if err := m.LatencyHistogram[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("latencyHistogram" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("latencyHistogram" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *KmsMetricsResponse) validateRequestActive(formats strfmt.Registry) error {

	if err := validate.Required("requestActive", "body", m.RequestActive); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateRequestErr(formats strfmt.Registry) error {

	if err := validate.Required("requestErr", "body", m.RequestErr); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateRequestFail(formats strfmt.Registry) error {

	if err := validate.Required("requestFail", "body", m.RequestFail); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateRequestOK(formats strfmt.Registry) error {

	if err := validate.Required("requestOK", "body", m.RequestOK); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateStackAlloc(formats strfmt.Registry) error {

	if err := validate.Required("stackAlloc", "body", m.StackAlloc); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateThreads(formats strfmt.Registry) error {

	if err := validate.Required("threads", "body", m.Threads); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateUptime(formats strfmt.Registry) error {

	if err := validate.Required("uptime", "body", m.Uptime); err != nil {
		return err
	}

	return nil
}

func (m *KmsMetricsResponse) validateUsableCPUs(formats strfmt.Registry) error {

	if err := validate.Required("usableCPUs", "body", m.UsableCPUs); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this kms metrics response based on the context it is used
func (m *KmsMetricsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLatencyHistogram(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KmsMetricsResponse) contextValidateLatencyHistogram(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.LatencyHistogram); i++ {

		if m.LatencyHistogram[i] != nil {

			if swag.IsZero(m.LatencyHistogram[i]) { // not required
				return nil
			}

			if err := m.LatencyHistogram[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("latencyHistogram" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("latencyHistogram" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *KmsMetricsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KmsMetricsResponse) UnmarshalBinary(b []byte) error {
	var res KmsMetricsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
