// This file is part of MinIO DirectPV
// Copyright (c) 2021, 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	clientset "github.com/minio/directpv/pkg/clientset"
	directv1alpha1 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1alpha1"
	fakedirectv1alpha1 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1alpha1/fake"
	directv1beta1 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1beta1"
	fakedirectv1beta1 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1beta1/fake"
	directv1beta2 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1beta2"
	fakedirectv1beta2 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1beta2/fake"
	directv1beta3 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1beta3"
	fakedirectv1beta3 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1beta3/fake"
	directv1beta4 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1beta4"
	fakedirectv1beta4 "github.com/minio/directpv/pkg/clientset/typed/direct.csi.min.io/v1beta4/fake"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/discovery"
	fakediscovery "k8s.io/client-go/discovery/fake"
	"k8s.io/client-go/testing"
)

// NewSimpleClientset returns a clientset that will respond with the provided objects.
// It's backed by a very simple object tracker that processes creates, updates and deletions as-is,
// without applying any validations and/or defaults. It shouldn't be considered a replacement
// for a real clientset and is mostly useful in simple unit tests.
func NewSimpleClientset(objects ...runtime.Object) *Clientset {
	o := testing.NewObjectTracker(scheme, codecs.UniversalDecoder())
	for _, obj := range objects {
		if err := o.Add(obj); err != nil {
			panic(err)
		}
	}

	cs := &Clientset{tracker: o}
	cs.discovery = &fakediscovery.FakeDiscovery{Fake: &cs.Fake}
	cs.AddReactor("*", "*", testing.ObjectReaction(o))
	cs.AddWatchReactor("*", func(action testing.Action) (handled bool, ret watch.Interface, err error) {
		gvr := action.GetResource()
		ns := action.GetNamespace()
		watch, err := o.Watch(gvr, ns)
		if err != nil {
			return false, nil, err
		}
		return true, watch, nil
	})

	return cs
}

// Clientset implements clientset.Interface. Meant to be embedded into a
// struct to get a default implementation. This makes faking out just the method
// you want to test easier.
type Clientset struct {
	testing.Fake
	discovery *fakediscovery.FakeDiscovery
	tracker   testing.ObjectTracker
}

func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	return c.discovery
}

func (c *Clientset) Tracker() testing.ObjectTracker {
	return c.tracker
}

var (
	_ clientset.Interface = &Clientset{}
	_ testing.FakeClient  = &Clientset{}
)

// DirectV1alpha1 retrieves the DirectV1alpha1Client
func (c *Clientset) DirectV1alpha1() directv1alpha1.DirectV1alpha1Interface {
	return &fakedirectv1alpha1.FakeDirectV1alpha1{Fake: &c.Fake}
}

// DirectV1beta1 retrieves the DirectV1beta1Client
func (c *Clientset) DirectV1beta1() directv1beta1.DirectV1beta1Interface {
	return &fakedirectv1beta1.FakeDirectV1beta1{Fake: &c.Fake}
}

// DirectV1beta2 retrieves the DirectV1beta2Client
func (c *Clientset) DirectV1beta2() directv1beta2.DirectV1beta2Interface {
	return &fakedirectv1beta2.FakeDirectV1beta2{Fake: &c.Fake}
}

// DirectV1beta3 retrieves the DirectV1beta3Client
func (c *Clientset) DirectV1beta3() directv1beta3.DirectV1beta3Interface {
	return &fakedirectv1beta3.FakeDirectV1beta3{Fake: &c.Fake}
}

// DirectV1beta4 retrieves the DirectV1beta4Client
func (c *Clientset) DirectV1beta4() directv1beta4.DirectV1beta4Interface {
	return &fakedirectv1beta4.FakeDirectV1beta4{Fake: &c.Fake}
}
