## Decommission a Pool in Operator

### Decommission using `mc`

First you need to pick a pool that you need to decommission.
```
mc admin decommission start myminio/ https://minio-ss-0-{0...3}.minio-hl..svc.cluster.local/export{0...3}
```

Then monitor the status of the decommissioned pool
```
mc admin decom status myminio/
```

More details documentation available [here](https://docs.min.io/minio/baremetal/installation/decommission-pool.html#minio-decommissioning)

### Update `tenant.yaml`

After the pool says completed you can remove the pool from your `tenant.yaml` and apply the change using `kubectl apply -f <tenant.yaml>`.

#### Caveats

Tenant CRD does not mandate `spec.pools[].Name` to be non-empty, however to safely perform decommission of a `pool` it is mandatory to have a `spec.pools[].Name`. if a `spec.pools[].Name` is empty for any `pool` removal of that `pool` is rejected. Following changes are necessary in such scenarios to proceed with removal of the `pool`.

First figure out what is the current autogenerated `ssName` (statefulset name) of the individual pools:

```
kubectl get tenants -n <namespace> <tenant_name> | jq '.status.pools[].ssName'
```

A practical example:
```
~ kubectl get tenants -n ns-1 all-nodes -o json | jq '.status.pools[].ssName'
"worker-ss-0"
"worker-ss-1"
```


In this case your tenant name is `worker` and pools are `ss-0` and `ss-1`, proceed to make following changes to your `tenant.yaml`


```yaml
spec:
  pools:
	...
	- name: "ss-0"
	...
	...
	- name: "ss-1"
	...
	...
```

**NOTE: This applies to helm chart users as well**
