// This file is part of MinIO Operator
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/minio/operator/pkg/apis/minio.min.io/v1"
	"github.com/minio/operator/pkg/client/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type MinioV1Interface interface {
	RESTClient() rest.Interface
	TenantsGetter
}

// MinioV1Client is used to interact with features provided by the minio.min.io group.
type MinioV1Client struct {
	restClient rest.Interface
}

func (c *MinioV1Client) Tenants(namespace string) TenantInterface {
	return newTenants(c, namespace)
}

// NewForConfig creates a new MinioV1Client for the given config.
func NewForConfig(c *rest.Config) (*MinioV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &MinioV1Client{client}, nil
}

// NewForConfigOrDie creates a new MinioV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *MinioV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new MinioV1Client for the given RESTClient.
func New(c rest.Interface) *MinioV1Client {
	return &MinioV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *MinioV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
