// This file is part of MinIO Operator
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v2 "github.com/minio/operator/pkg/apis/minio.min.io/v2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeTenants implements TenantInterface
type FakeTenants struct {
	Fake *FakeMinioV2
	ns   string
}

var tenantsResource = schema.GroupVersionResource{Group: "minio.min.io", Version: "v2", Resource: "tenants"}

var tenantsKind = schema.GroupVersionKind{Group: "minio.min.io", Version: "v2", Kind: "Tenant"}

// Get takes name of the tenant, and returns the corresponding tenant object, and an error if there is any.
func (c *FakeTenants) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2.Tenant, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(tenantsResource, c.ns, name), &v2.Tenant{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.Tenant), err
}

// List takes label and field selectors, and returns the list of Tenants that match those selectors.
func (c *FakeTenants) List(ctx context.Context, opts v1.ListOptions) (result *v2.TenantList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(tenantsResource, tenantsKind, c.ns, opts), &v2.TenantList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v2.TenantList{ListMeta: obj.(*v2.TenantList).ListMeta}
	for _, item := range obj.(*v2.TenantList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested tenants.
func (c *FakeTenants) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(tenantsResource, c.ns, opts))

}

// Create takes the representation of a tenant and creates it.  Returns the server's representation of the tenant, and an error, if there is any.
func (c *FakeTenants) Create(ctx context.Context, tenant *v2.Tenant, opts v1.CreateOptions) (result *v2.Tenant, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(tenantsResource, c.ns, tenant), &v2.Tenant{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.Tenant), err
}

// Update takes the representation of a tenant and updates it. Returns the server's representation of the tenant, and an error, if there is any.
func (c *FakeTenants) Update(ctx context.Context, tenant *v2.Tenant, opts v1.UpdateOptions) (result *v2.Tenant, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(tenantsResource, c.ns, tenant), &v2.Tenant{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.Tenant), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeTenants) UpdateStatus(ctx context.Context, tenant *v2.Tenant, opts v1.UpdateOptions) (*v2.Tenant, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(tenantsResource, "status", c.ns, tenant), &v2.Tenant{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.Tenant), err
}

// Delete takes name of the tenant and deletes it. Returns an error if one occurs.
func (c *FakeTenants) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(tenantsResource, c.ns, name), &v2.Tenant{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeTenants) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(tenantsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v2.TenantList{})
	return err
}

// Patch applies the patch and returns the patched tenant.
func (c *FakeTenants) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.Tenant, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(tenantsResource, c.ns, name, pt, data, subresources...), &v2.Tenant{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.Tenant), err
}
