// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// ScanResultProblemSeverityEnum Enum with underlying type: string
type ScanResultProblemSeverityEnum string

// Set of constants representing the allowable values for ScanResultProblemSeverityEnum
const (
	ScanResultProblemSeverityNone     ScanResultProblemSeverityEnum = "NONE"
	ScanResultProblemSeverityLow      ScanResultProblemSeverityEnum = "LOW"
	ScanResultProblemSeverityMedium   ScanResultProblemSeverityEnum = "MEDIUM"
	ScanResultProblemSeverityHigh     ScanResultProblemSeverityEnum = "HIGH"
	ScanResultProblemSeverityCritical ScanResultProblemSeverityEnum = "CRITICAL"
)

var mappingScanResultProblemSeverityEnum = map[string]ScanResultProblemSeverityEnum{
	"NONE":     ScanResultProblemSeverityNone,
	"LOW":      ScanResultProblemSeverityLow,
	"MEDIUM":   ScanResultProblemSeverityMedium,
	"HIGH":     ScanResultProblemSeverityHigh,
	"CRITICAL": ScanResultProblemSeverityCritical,
}

var mappingScanResultProblemSeverityEnumLowerCase = map[string]ScanResultProblemSeverityEnum{
	"none":     ScanResultProblemSeverityNone,
	"low":      ScanResultProblemSeverityLow,
	"medium":   ScanResultProblemSeverityMedium,
	"high":     ScanResultProblemSeverityHigh,
	"critical": ScanResultProblemSeverityCritical,
}

// GetScanResultProblemSeverityEnumValues Enumerates the set of values for ScanResultProblemSeverityEnum
func GetScanResultProblemSeverityEnumValues() []ScanResultProblemSeverityEnum {
	values := make([]ScanResultProblemSeverityEnum, 0)
	for _, v := range mappingScanResultProblemSeverityEnum {
		values = append(values, v)
	}
	return values
}

// GetScanResultProblemSeverityEnumStringValues Enumerates the set of values in String for ScanResultProblemSeverityEnum
func GetScanResultProblemSeverityEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingScanResultProblemSeverityEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingScanResultProblemSeverityEnum(val string) (ScanResultProblemSeverityEnum, bool) {
	enum, ok := mappingScanResultProblemSeverityEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
