package main

import (
	"context"
	"log"

	"github.com/owenthereal/tmux"
)

func main() {
	ctx := context.Background()

	t, err := tmux.Default()
	if err != nil {
		log.Fatal(err)
	}

	s, err := t.NewSession(ctx, &tmux.SessionOptions{
		StartDirectory: "/home",
		Name:           "somename",
	})
	if err != nil {
		log.Fatal(err)
	}

	// takes over the client (terminal) if possible
	err = s.Attach(ctx)
	if err != nil {
		log.Fatal(err)
	}

	// when detached this will continue...

	// next and prev cycle
	err = s.NextWindow(ctx)
	if err != nil {
		log.Fatal(err)
	}

	// kill the session
	s.Kill(ctx)
}
