// Copyright 2013-present Barefoot Networks, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v3.18.1
// source: p4/config/v1/p4types.proto

package v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// These P4 types (struct, header_type, header_union and enum) are guaranteed to
// have a fully-qualified name (e.g. you cannot use an anonymous struct to
// declare a variable like in C). Instead of duplicating the type spec for these
// every time the type is used, we include the type spec once in this P4TypeInfo
// message and refer to the types by name in the P4DataTypeSpec message. We also
// support annotations for these type specs which can be useful, e.g. to
// identify well-known headers (such as ipv4).
type P4TypeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Structs           map[string]*P4StructTypeSpec           `protobuf:"bytes,1,rep,name=structs,proto3" json:"structs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Headers           map[string]*P4HeaderTypeSpec           `protobuf:"bytes,2,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	HeaderUnions      map[string]*P4HeaderUnionTypeSpec      `protobuf:"bytes,3,rep,name=header_unions,json=headerUnions,proto3" json:"header_unions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Enums             map[string]*P4EnumTypeSpec             `protobuf:"bytes,4,rep,name=enums,proto3" json:"enums,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Error             *P4ErrorTypeSpec                       `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	SerializableEnums map[string]*P4SerializableEnumTypeSpec `protobuf:"bytes,6,rep,name=serializable_enums,json=serializableEnums,proto3" json:"serializable_enums,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	NewTypes          map[string]*P4NewTypeSpec              `protobuf:"bytes,7,rep,name=new_types,json=newTypes,proto3" json:"new_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *P4TypeInfo) Reset() {
	*x = P4TypeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4TypeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4TypeInfo) ProtoMessage() {}

func (x *P4TypeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4TypeInfo.ProtoReflect.Descriptor instead.
func (*P4TypeInfo) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{0}
}

func (x *P4TypeInfo) GetStructs() map[string]*P4StructTypeSpec {
	if x != nil {
		return x.Structs
	}
	return nil
}

func (x *P4TypeInfo) GetHeaders() map[string]*P4HeaderTypeSpec {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *P4TypeInfo) GetHeaderUnions() map[string]*P4HeaderUnionTypeSpec {
	if x != nil {
		return x.HeaderUnions
	}
	return nil
}

func (x *P4TypeInfo) GetEnums() map[string]*P4EnumTypeSpec {
	if x != nil {
		return x.Enums
	}
	return nil
}

func (x *P4TypeInfo) GetError() *P4ErrorTypeSpec {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *P4TypeInfo) GetSerializableEnums() map[string]*P4SerializableEnumTypeSpec {
	if x != nil {
		return x.SerializableEnums
	}
	return nil
}

func (x *P4TypeInfo) GetNewTypes() map[string]*P4NewTypeSpec {
	if x != nil {
		return x.NewTypes
	}
	return nil
}

// Describes a P4_16 type.
type P4DataTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to TypeSpec:
	//
	//	*P4DataTypeSpec_Bitstring
	//	*P4DataTypeSpec_Bool
	//	*P4DataTypeSpec_Tuple
	//	*P4DataTypeSpec_Struct
	//	*P4DataTypeSpec_Header
	//	*P4DataTypeSpec_HeaderUnion
	//	*P4DataTypeSpec_HeaderStack
	//	*P4DataTypeSpec_HeaderUnionStack
	//	*P4DataTypeSpec_Enum
	//	*P4DataTypeSpec_Error
	//	*P4DataTypeSpec_SerializableEnum
	//	*P4DataTypeSpec_NewType
	TypeSpec isP4DataTypeSpec_TypeSpec `protobuf_oneof:"type_spec"`
}

func (x *P4DataTypeSpec) Reset() {
	*x = P4DataTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4DataTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4DataTypeSpec) ProtoMessage() {}

func (x *P4DataTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4DataTypeSpec.ProtoReflect.Descriptor instead.
func (*P4DataTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{1}
}

func (m *P4DataTypeSpec) GetTypeSpec() isP4DataTypeSpec_TypeSpec {
	if m != nil {
		return m.TypeSpec
	}
	return nil
}

func (x *P4DataTypeSpec) GetBitstring() *P4BitstringLikeTypeSpec {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_Bitstring); ok {
		return x.Bitstring
	}
	return nil
}

func (x *P4DataTypeSpec) GetBool() *P4BoolType {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_Bool); ok {
		return x.Bool
	}
	return nil
}

func (x *P4DataTypeSpec) GetTuple() *P4TupleTypeSpec {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_Tuple); ok {
		return x.Tuple
	}
	return nil
}

func (x *P4DataTypeSpec) GetStruct() *P4NamedType {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_Struct); ok {
		return x.Struct
	}
	return nil
}

func (x *P4DataTypeSpec) GetHeader() *P4NamedType {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_Header); ok {
		return x.Header
	}
	return nil
}

func (x *P4DataTypeSpec) GetHeaderUnion() *P4NamedType {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_HeaderUnion); ok {
		return x.HeaderUnion
	}
	return nil
}

func (x *P4DataTypeSpec) GetHeaderStack() *P4HeaderStackTypeSpec {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_HeaderStack); ok {
		return x.HeaderStack
	}
	return nil
}

func (x *P4DataTypeSpec) GetHeaderUnionStack() *P4HeaderUnionStackTypeSpec {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_HeaderUnionStack); ok {
		return x.HeaderUnionStack
	}
	return nil
}

func (x *P4DataTypeSpec) GetEnum() *P4NamedType {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_Enum); ok {
		return x.Enum
	}
	return nil
}

func (x *P4DataTypeSpec) GetError() *P4ErrorType {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_Error); ok {
		return x.Error
	}
	return nil
}

func (x *P4DataTypeSpec) GetSerializableEnum() *P4NamedType {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_SerializableEnum); ok {
		return x.SerializableEnum
	}
	return nil
}

func (x *P4DataTypeSpec) GetNewType() *P4NamedType {
	if x, ok := x.GetTypeSpec().(*P4DataTypeSpec_NewType); ok {
		return x.NewType
	}
	return nil
}

type isP4DataTypeSpec_TypeSpec interface {
	isP4DataTypeSpec_TypeSpec()
}

type P4DataTypeSpec_Bitstring struct {
	Bitstring *P4BitstringLikeTypeSpec `protobuf:"bytes,1,opt,name=bitstring,proto3,oneof"`
}

type P4DataTypeSpec_Bool struct {
	Bool *P4BoolType `protobuf:"bytes,2,opt,name=bool,proto3,oneof"`
}

type P4DataTypeSpec_Tuple struct {
	Tuple *P4TupleTypeSpec `protobuf:"bytes,3,opt,name=tuple,proto3,oneof"`
}

type P4DataTypeSpec_Struct struct {
	Struct *P4NamedType `protobuf:"bytes,4,opt,name=struct,proto3,oneof"`
}

type P4DataTypeSpec_Header struct {
	Header *P4NamedType `protobuf:"bytes,5,opt,name=header,proto3,oneof"`
}

type P4DataTypeSpec_HeaderUnion struct {
	HeaderUnion *P4NamedType `protobuf:"bytes,6,opt,name=header_union,json=headerUnion,proto3,oneof"`
}

type P4DataTypeSpec_HeaderStack struct {
	HeaderStack *P4HeaderStackTypeSpec `protobuf:"bytes,7,opt,name=header_stack,json=headerStack,proto3,oneof"`
}

type P4DataTypeSpec_HeaderUnionStack struct {
	HeaderUnionStack *P4HeaderUnionStackTypeSpec `protobuf:"bytes,8,opt,name=header_union_stack,json=headerUnionStack,proto3,oneof"`
}

type P4DataTypeSpec_Enum struct {
	Enum *P4NamedType `protobuf:"bytes,9,opt,name=enum,proto3,oneof"`
}

type P4DataTypeSpec_Error struct {
	Error *P4ErrorType `protobuf:"bytes,10,opt,name=error,proto3,oneof"`
}

type P4DataTypeSpec_SerializableEnum struct {
	SerializableEnum *P4NamedType `protobuf:"bytes,11,opt,name=serializable_enum,json=serializableEnum,proto3,oneof"`
}

type P4DataTypeSpec_NewType struct {
	NewType *P4NamedType `protobuf:"bytes,12,opt,name=new_type,json=newType,proto3,oneof"`
}

func (*P4DataTypeSpec_Bitstring) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_Bool) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_Tuple) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_Struct) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_Header) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_HeaderUnion) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_HeaderStack) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_HeaderUnionStack) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_Enum) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_Error) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_SerializableEnum) isP4DataTypeSpec_TypeSpec() {}

func (*P4DataTypeSpec_NewType) isP4DataTypeSpec_TypeSpec() {}

type P4NamedType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *P4NamedType) Reset() {
	*x = P4NamedType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4NamedType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4NamedType) ProtoMessage() {}

func (x *P4NamedType) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4NamedType.ProtoReflect.Descriptor instead.
func (*P4NamedType) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{2}
}

func (x *P4NamedType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Empty message as no type information needed, just used as a placeholder in
// the oneof to identify boolean types.
type P4BoolType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *P4BoolType) Reset() {
	*x = P4BoolType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4BoolType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4BoolType) ProtoMessage() {}

func (x *P4BoolType) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4BoolType.ProtoReflect.Descriptor instead.
func (*P4BoolType) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{3}
}

type P4ErrorType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *P4ErrorType) Reset() {
	*x = P4ErrorType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4ErrorType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4ErrorType) ProtoMessage() {}

func (x *P4ErrorType) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4ErrorType.ProtoReflect.Descriptor instead.
func (*P4ErrorType) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{4}
}

type P4BitstringLikeTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to TypeSpec:
	//
	//	*P4BitstringLikeTypeSpec_Bit
	//	*P4BitstringLikeTypeSpec_Int
	//	*P4BitstringLikeTypeSpec_Varbit
	TypeSpec isP4BitstringLikeTypeSpec_TypeSpec `protobuf_oneof:"type_spec"`
	// Useful to identify well-known types, such as IP address or Ethernet MAC
	// address.
	Annotations []string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,5,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,6,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *P4BitstringLikeTypeSpec) Reset() {
	*x = P4BitstringLikeTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4BitstringLikeTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4BitstringLikeTypeSpec) ProtoMessage() {}

func (x *P4BitstringLikeTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4BitstringLikeTypeSpec.ProtoReflect.Descriptor instead.
func (*P4BitstringLikeTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{5}
}

func (m *P4BitstringLikeTypeSpec) GetTypeSpec() isP4BitstringLikeTypeSpec_TypeSpec {
	if m != nil {
		return m.TypeSpec
	}
	return nil
}

func (x *P4BitstringLikeTypeSpec) GetBit() *P4BitTypeSpec {
	if x, ok := x.GetTypeSpec().(*P4BitstringLikeTypeSpec_Bit); ok {
		return x.Bit
	}
	return nil
}

func (x *P4BitstringLikeTypeSpec) GetInt() *P4IntTypeSpec {
	if x, ok := x.GetTypeSpec().(*P4BitstringLikeTypeSpec_Int); ok {
		return x.Int
	}
	return nil
}

func (x *P4BitstringLikeTypeSpec) GetVarbit() *P4VarbitTypeSpec {
	if x, ok := x.GetTypeSpec().(*P4BitstringLikeTypeSpec_Varbit); ok {
		return x.Varbit
	}
	return nil
}

func (x *P4BitstringLikeTypeSpec) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *P4BitstringLikeTypeSpec) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *P4BitstringLikeTypeSpec) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

type isP4BitstringLikeTypeSpec_TypeSpec interface {
	isP4BitstringLikeTypeSpec_TypeSpec()
}

type P4BitstringLikeTypeSpec_Bit struct {
	Bit *P4BitTypeSpec `protobuf:"bytes,1,opt,name=bit,proto3,oneof"` // bit<W>
}

type P4BitstringLikeTypeSpec_Int struct {
	Int *P4IntTypeSpec `protobuf:"bytes,2,opt,name=int,proto3,oneof"` // int<W>
}

type P4BitstringLikeTypeSpec_Varbit struct {
	Varbit *P4VarbitTypeSpec `protobuf:"bytes,3,opt,name=varbit,proto3,oneof"` // varbit<W>
}

func (*P4BitstringLikeTypeSpec_Bit) isP4BitstringLikeTypeSpec_TypeSpec() {}

func (*P4BitstringLikeTypeSpec_Int) isP4BitstringLikeTypeSpec_TypeSpec() {}

func (*P4BitstringLikeTypeSpec_Varbit) isP4BitstringLikeTypeSpec_TypeSpec() {}

type P4BitTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Bitwidth int32 `protobuf:"varint,1,opt,name=bitwidth,proto3" json:"bitwidth,omitempty"`
}

func (x *P4BitTypeSpec) Reset() {
	*x = P4BitTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4BitTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4BitTypeSpec) ProtoMessage() {}

func (x *P4BitTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4BitTypeSpec.ProtoReflect.Descriptor instead.
func (*P4BitTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{6}
}

func (x *P4BitTypeSpec) GetBitwidth() int32 {
	if x != nil {
		return x.Bitwidth
	}
	return 0
}

type P4IntTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Bitwidth int32 `protobuf:"varint,1,opt,name=bitwidth,proto3" json:"bitwidth,omitempty"`
}

func (x *P4IntTypeSpec) Reset() {
	*x = P4IntTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4IntTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4IntTypeSpec) ProtoMessage() {}

func (x *P4IntTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4IntTypeSpec.ProtoReflect.Descriptor instead.
func (*P4IntTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{7}
}

func (x *P4IntTypeSpec) GetBitwidth() int32 {
	if x != nil {
		return x.Bitwidth
	}
	return 0
}

type P4VarbitTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxBitwidth int32 `protobuf:"varint,1,opt,name=max_bitwidth,json=maxBitwidth,proto3" json:"max_bitwidth,omitempty"`
}

func (x *P4VarbitTypeSpec) Reset() {
	*x = P4VarbitTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4VarbitTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4VarbitTypeSpec) ProtoMessage() {}

func (x *P4VarbitTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4VarbitTypeSpec.ProtoReflect.Descriptor instead.
func (*P4VarbitTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{8}
}

func (x *P4VarbitTypeSpec) GetMaxBitwidth() int32 {
	if x != nil {
		return x.MaxBitwidth
	}
	return 0
}

// From the P4_16 spec: "A tuple is similar to a struct, in that it holds
// multiple values. Unlike a struct type, tuples have no named fields."
type P4TupleTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Members []*P4DataTypeSpec `protobuf:"bytes,1,rep,name=members,proto3" json:"members,omitempty"`
}

func (x *P4TupleTypeSpec) Reset() {
	*x = P4TupleTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4TupleTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4TupleTypeSpec) ProtoMessage() {}

func (x *P4TupleTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4TupleTypeSpec.ProtoReflect.Descriptor instead.
func (*P4TupleTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{9}
}

func (x *P4TupleTypeSpec) GetMembers() []*P4DataTypeSpec {
	if x != nil {
		return x.Members
	}
	return nil
}

type P4StructTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Members     []*P4StructTypeSpec_Member `protobuf:"bytes,1,rep,name=members,proto3" json:"members,omitempty"`
	Annotations []string                   `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,3,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,4,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *P4StructTypeSpec) Reset() {
	*x = P4StructTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4StructTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4StructTypeSpec) ProtoMessage() {}

func (x *P4StructTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4StructTypeSpec.ProtoReflect.Descriptor instead.
func (*P4StructTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{10}
}

func (x *P4StructTypeSpec) GetMembers() []*P4StructTypeSpec_Member {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *P4StructTypeSpec) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *P4StructTypeSpec) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *P4StructTypeSpec) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

type P4HeaderTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Members     []*P4HeaderTypeSpec_Member `protobuf:"bytes,1,rep,name=members,proto3" json:"members,omitempty"`
	Annotations []string                   `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,3,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,4,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *P4HeaderTypeSpec) Reset() {
	*x = P4HeaderTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4HeaderTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4HeaderTypeSpec) ProtoMessage() {}

func (x *P4HeaderTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4HeaderTypeSpec.ProtoReflect.Descriptor instead.
func (*P4HeaderTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{11}
}

func (x *P4HeaderTypeSpec) GetMembers() []*P4HeaderTypeSpec_Member {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *P4HeaderTypeSpec) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *P4HeaderTypeSpec) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *P4HeaderTypeSpec) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

type P4HeaderUnionTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Members     []*P4HeaderUnionTypeSpec_Member `protobuf:"bytes,1,rep,name=members,proto3" json:"members,omitempty"`
	Annotations []string                        `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,3,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,4,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *P4HeaderUnionTypeSpec) Reset() {
	*x = P4HeaderUnionTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4HeaderUnionTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4HeaderUnionTypeSpec) ProtoMessage() {}

func (x *P4HeaderUnionTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4HeaderUnionTypeSpec.ProtoReflect.Descriptor instead.
func (*P4HeaderUnionTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{12}
}

func (x *P4HeaderUnionTypeSpec) GetMembers() []*P4HeaderUnionTypeSpec_Member {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *P4HeaderUnionTypeSpec) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *P4HeaderUnionTypeSpec) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *P4HeaderUnionTypeSpec) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

type P4HeaderStackTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *P4NamedType `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Size   int32        `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *P4HeaderStackTypeSpec) Reset() {
	*x = P4HeaderStackTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4HeaderStackTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4HeaderStackTypeSpec) ProtoMessage() {}

func (x *P4HeaderStackTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4HeaderStackTypeSpec.ProtoReflect.Descriptor instead.
func (*P4HeaderStackTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{13}
}

func (x *P4HeaderStackTypeSpec) GetHeader() *P4NamedType {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *P4HeaderStackTypeSpec) GetSize() int32 {
	if x != nil {
		return x.Size
	}
	return 0
}

type P4HeaderUnionStackTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HeaderUnion *P4NamedType `protobuf:"bytes,1,opt,name=header_union,json=headerUnion,proto3" json:"header_union,omitempty"`
	Size        int32        `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *P4HeaderUnionStackTypeSpec) Reset() {
	*x = P4HeaderUnionStackTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4HeaderUnionStackTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4HeaderUnionStackTypeSpec) ProtoMessage() {}

func (x *P4HeaderUnionStackTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4HeaderUnionStackTypeSpec.ProtoReflect.Descriptor instead.
func (*P4HeaderUnionStackTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{14}
}

func (x *P4HeaderUnionStackTypeSpec) GetHeaderUnion() *P4NamedType {
	if x != nil {
		return x.HeaderUnion
	}
	return nil
}

func (x *P4HeaderUnionStackTypeSpec) GetSize() int32 {
	if x != nil {
		return x.Size
	}
	return 0
}

type KeyValuePair struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string      `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value *Expression `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *KeyValuePair) Reset() {
	*x = KeyValuePair{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyValuePair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyValuePair) ProtoMessage() {}

func (x *KeyValuePair) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyValuePair.ProtoReflect.Descriptor instead.
func (*KeyValuePair) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{15}
}

func (x *KeyValuePair) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *KeyValuePair) GetValue() *Expression {
	if x != nil {
		return x.Value
	}
	return nil
}

type KeyValuePairList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KvPairs []*KeyValuePair `protobuf:"bytes,1,rep,name=kv_pairs,json=kvPairs,proto3" json:"kv_pairs,omitempty"`
}

func (x *KeyValuePairList) Reset() {
	*x = KeyValuePairList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyValuePairList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyValuePairList) ProtoMessage() {}

func (x *KeyValuePairList) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyValuePairList.ProtoReflect.Descriptor instead.
func (*KeyValuePairList) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{16}
}

func (x *KeyValuePairList) GetKvPairs() []*KeyValuePair {
	if x != nil {
		return x.KvPairs
	}
	return nil
}

type Expression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*Expression_StringValue
	//	*Expression_Int64Value
	//	*Expression_BoolValue
	Value isExpression_Value `protobuf_oneof:"value"`
}

func (x *Expression) Reset() {
	*x = Expression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression) ProtoMessage() {}

func (x *Expression) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression.ProtoReflect.Descriptor instead.
func (*Expression) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{17}
}

func (m *Expression) GetValue() isExpression_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Expression) GetStringValue() string {
	if x, ok := x.GetValue().(*Expression_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Expression) GetInt64Value() int64 {
	if x, ok := x.GetValue().(*Expression_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *Expression) GetBoolValue() bool {
	if x, ok := x.GetValue().(*Expression_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

type isExpression_Value interface {
	isExpression_Value()
}

type Expression_StringValue struct {
	StringValue string `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Expression_Int64Value struct {
	Int64Value int64 `protobuf:"varint,2,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type Expression_BoolValue struct {
	BoolValue bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

func (*Expression_StringValue) isExpression_Value() {}

func (*Expression_Int64Value) isExpression_Value() {}

func (*Expression_BoolValue) isExpression_Value() {}

type ExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Expressions []*Expression `protobuf:"bytes,1,rep,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *ExpressionList) Reset() {
	*x = ExpressionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpressionList) ProtoMessage() {}

func (x *ExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpressionList.ProtoReflect.Descriptor instead.
func (*ExpressionList) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{18}
}

func (x *ExpressionList) GetExpressions() []*Expression {
	if x != nil {
		return x.Expressions
	}
	return nil
}

type StructuredAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to Body:
	//
	//	*StructuredAnnotation_ExpressionList
	//	*StructuredAnnotation_KvPairList
	Body isStructuredAnnotation_Body `protobuf_oneof:"body"`
	// Optional. Location of the '@' symbol of this annotation in the source code.
	SourceLocation *SourceLocation `protobuf:"bytes,4,opt,name=source_location,json=sourceLocation,proto3" json:"source_location,omitempty"`
}

func (x *StructuredAnnotation) Reset() {
	*x = StructuredAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredAnnotation) ProtoMessage() {}

func (x *StructuredAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredAnnotation.ProtoReflect.Descriptor instead.
func (*StructuredAnnotation) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{19}
}

func (x *StructuredAnnotation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *StructuredAnnotation) GetBody() isStructuredAnnotation_Body {
	if m != nil {
		return m.Body
	}
	return nil
}

func (x *StructuredAnnotation) GetExpressionList() *ExpressionList {
	if x, ok := x.GetBody().(*StructuredAnnotation_ExpressionList); ok {
		return x.ExpressionList
	}
	return nil
}

func (x *StructuredAnnotation) GetKvPairList() *KeyValuePairList {
	if x, ok := x.GetBody().(*StructuredAnnotation_KvPairList); ok {
		return x.KvPairList
	}
	return nil
}

func (x *StructuredAnnotation) GetSourceLocation() *SourceLocation {
	if x != nil {
		return x.SourceLocation
	}
	return nil
}

type isStructuredAnnotation_Body interface {
	isStructuredAnnotation_Body()
}

type StructuredAnnotation_ExpressionList struct {
	ExpressionList *ExpressionList `protobuf:"bytes,2,opt,name=expression_list,json=expressionList,proto3,oneof"`
}

type StructuredAnnotation_KvPairList struct {
	KvPairList *KeyValuePairList `protobuf:"bytes,3,opt,name=kv_pair_list,json=kvPairList,proto3,oneof"`
}

func (*StructuredAnnotation_ExpressionList) isStructuredAnnotation_Body() {}

func (*StructuredAnnotation_KvPairList) isStructuredAnnotation_Body() {}

// Location of code relative to a given source file.
type SourceLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the source file (absolute or relative to the working directory).
	File string `protobuf:"bytes,1,opt,name=file,proto3" json:"file,omitempty"`
	// Line and column numbers within the source file, 1-based.
	Line   int32 `protobuf:"varint,2,opt,name=line,proto3" json:"line,omitempty"`
	Column int32 `protobuf:"varint,3,opt,name=column,proto3" json:"column,omitempty"`
}

func (x *SourceLocation) Reset() {
	*x = SourceLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceLocation) ProtoMessage() {}

func (x *SourceLocation) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceLocation.ProtoReflect.Descriptor instead.
func (*SourceLocation) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{20}
}

func (x *SourceLocation) GetFile() string {
	if x != nil {
		return x.File
	}
	return ""
}

func (x *SourceLocation) GetLine() int32 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *SourceLocation) GetColumn() int32 {
	if x != nil {
		return x.Column
	}
	return 0
}

// For "safe" enums with no underlying representation and no member integer
// values.
type P4EnumTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Members     []*P4EnumTypeSpec_Member `protobuf:"bytes,1,rep,name=members,proto3" json:"members,omitempty"`
	Annotations []string                 `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,4,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,3,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *P4EnumTypeSpec) Reset() {
	*x = P4EnumTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4EnumTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4EnumTypeSpec) ProtoMessage() {}

func (x *P4EnumTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4EnumTypeSpec.ProtoReflect.Descriptor instead.
func (*P4EnumTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{21}
}

func (x *P4EnumTypeSpec) GetMembers() []*P4EnumTypeSpec_Member {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *P4EnumTypeSpec) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *P4EnumTypeSpec) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *P4EnumTypeSpec) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

// For serializable (or "unsafe") enums, which have an underlying type. Note
// that as per the P4_16 specification, the underlying representation can only
// be a bit<W> type.
type P4SerializableEnumTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UnderlyingType *P4BitTypeSpec                       `protobuf:"bytes,1,opt,name=underlying_type,json=underlyingType,proto3" json:"underlying_type,omitempty"`
	Members        []*P4SerializableEnumTypeSpec_Member `protobuf:"bytes,2,rep,name=members,proto3" json:"members,omitempty"`
	Annotations    []string                             `protobuf:"bytes,3,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,5,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,4,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *P4SerializableEnumTypeSpec) Reset() {
	*x = P4SerializableEnumTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4SerializableEnumTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4SerializableEnumTypeSpec) ProtoMessage() {}

func (x *P4SerializableEnumTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4SerializableEnumTypeSpec.ProtoReflect.Descriptor instead.
func (*P4SerializableEnumTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{22}
}

func (x *P4SerializableEnumTypeSpec) GetUnderlyingType() *P4BitTypeSpec {
	if x != nil {
		return x.UnderlyingType
	}
	return nil
}

func (x *P4SerializableEnumTypeSpec) GetMembers() []*P4SerializableEnumTypeSpec_Member {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *P4SerializableEnumTypeSpec) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *P4SerializableEnumTypeSpec) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *P4SerializableEnumTypeSpec) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

// Similar to an enum, but there is always one and only one instance per P4
// program.
type P4ErrorTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Members []string `protobuf:"bytes,1,rep,name=members,proto3" json:"members,omitempty"`
}

func (x *P4ErrorTypeSpec) Reset() {
	*x = P4ErrorTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4ErrorTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4ErrorTypeSpec) ProtoMessage() {}

func (x *P4ErrorTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4ErrorTypeSpec.ProtoReflect.Descriptor instead.
func (*P4ErrorTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{23}
}

func (x *P4ErrorTypeSpec) GetMembers() []string {
	if x != nil {
		return x.Members
	}
	return nil
}

type P4NewTypeTranslation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the URI uniquely identifies the translation in order to enable the
	// P4Runtime agent to perform value-mapping appropriately when required. It is
	// recommended that the URI includes at least the P4 architecture name and the
	// type name.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The object is either represented as an unsigned integer with a bitwidth of
	// `sdn_bitwidth`, or as a string.
	//
	// Types that are assignable to SdnType:
	//
	//	*P4NewTypeTranslation_SdnBitwidth
	//	*P4NewTypeTranslation_SdnString_
	SdnType isP4NewTypeTranslation_SdnType `protobuf_oneof:"sdn_type"`
}

func (x *P4NewTypeTranslation) Reset() {
	*x = P4NewTypeTranslation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4NewTypeTranslation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4NewTypeTranslation) ProtoMessage() {}

func (x *P4NewTypeTranslation) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4NewTypeTranslation.ProtoReflect.Descriptor instead.
func (*P4NewTypeTranslation) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{24}
}

func (x *P4NewTypeTranslation) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (m *P4NewTypeTranslation) GetSdnType() isP4NewTypeTranslation_SdnType {
	if m != nil {
		return m.SdnType
	}
	return nil
}

func (x *P4NewTypeTranslation) GetSdnBitwidth() int32 {
	if x, ok := x.GetSdnType().(*P4NewTypeTranslation_SdnBitwidth); ok {
		return x.SdnBitwidth
	}
	return 0
}

func (x *P4NewTypeTranslation) GetSdnString() *P4NewTypeTranslation_SdnString {
	if x, ok := x.GetSdnType().(*P4NewTypeTranslation_SdnString_); ok {
		return x.SdnString
	}
	return nil
}

type isP4NewTypeTranslation_SdnType interface {
	isP4NewTypeTranslation_SdnType()
}

type P4NewTypeTranslation_SdnBitwidth struct {
	SdnBitwidth int32 `protobuf:"varint,2,opt,name=sdn_bitwidth,json=sdnBitwidth,proto3,oneof"`
}

type P4NewTypeTranslation_SdnString_ struct {
	SdnString *P4NewTypeTranslation_SdnString `protobuf:"bytes,3,opt,name=sdn_string,json=sdnString,proto3,oneof"`
}

func (*P4NewTypeTranslation_SdnBitwidth) isP4NewTypeTranslation_SdnType() {}

func (*P4NewTypeTranslation_SdnString_) isP4NewTypeTranslation_SdnType() {}

// New types introduced with the "type" keyword
type P4NewTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Representation:
	//
	//	*P4NewTypeSpec_OriginalType
	//	*P4NewTypeSpec_TranslatedType
	Representation isP4NewTypeSpec_Representation `protobuf_oneof:"representation"`
	// for other annotations (not @p4runtime_translation)
	Annotations []string `protobuf:"bytes,3,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,5,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,4,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *P4NewTypeSpec) Reset() {
	*x = P4NewTypeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4NewTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4NewTypeSpec) ProtoMessage() {}

func (x *P4NewTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4NewTypeSpec.ProtoReflect.Descriptor instead.
func (*P4NewTypeSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{25}
}

func (m *P4NewTypeSpec) GetRepresentation() isP4NewTypeSpec_Representation {
	if m != nil {
		return m.Representation
	}
	return nil
}

func (x *P4NewTypeSpec) GetOriginalType() *P4DataTypeSpec {
	if x, ok := x.GetRepresentation().(*P4NewTypeSpec_OriginalType); ok {
		return x.OriginalType
	}
	return nil
}

func (x *P4NewTypeSpec) GetTranslatedType() *P4NewTypeTranslation {
	if x, ok := x.GetRepresentation().(*P4NewTypeSpec_TranslatedType); ok {
		return x.TranslatedType
	}
	return nil
}

func (x *P4NewTypeSpec) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *P4NewTypeSpec) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *P4NewTypeSpec) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

type isP4NewTypeSpec_Representation interface {
	isP4NewTypeSpec_Representation()
}

type P4NewTypeSpec_OriginalType struct {
	// if no @p4runtime_translation annotation present
	OriginalType *P4DataTypeSpec `protobuf:"bytes,1,opt,name=original_type,json=originalType,proto3,oneof"`
}

type P4NewTypeSpec_TranslatedType struct {
	// if @p4runtime_translation annotation present
	TranslatedType *P4NewTypeTranslation `protobuf:"bytes,2,opt,name=translated_type,json=translatedType,proto3,oneof"`
}

func (*P4NewTypeSpec_OriginalType) isP4NewTypeSpec_Representation() {}

func (*P4NewTypeSpec_TranslatedType) isP4NewTypeSpec_Representation() {}

type P4StructTypeSpec_Member struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string          `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	TypeSpec *P4DataTypeSpec `protobuf:"bytes,2,opt,name=type_spec,json=typeSpec,proto3" json:"type_spec,omitempty"`
}

func (x *P4StructTypeSpec_Member) Reset() {
	*x = P4StructTypeSpec_Member{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4StructTypeSpec_Member) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4StructTypeSpec_Member) ProtoMessage() {}

func (x *P4StructTypeSpec_Member) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4StructTypeSpec_Member.ProtoReflect.Descriptor instead.
func (*P4StructTypeSpec_Member) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{10, 0}
}

func (x *P4StructTypeSpec_Member) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *P4StructTypeSpec_Member) GetTypeSpec() *P4DataTypeSpec {
	if x != nil {
		return x.TypeSpec
	}
	return nil
}

type P4HeaderTypeSpec_Member struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string                   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	TypeSpec *P4BitstringLikeTypeSpec `protobuf:"bytes,2,opt,name=type_spec,json=typeSpec,proto3" json:"type_spec,omitempty"`
}

func (x *P4HeaderTypeSpec_Member) Reset() {
	*x = P4HeaderTypeSpec_Member{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4HeaderTypeSpec_Member) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4HeaderTypeSpec_Member) ProtoMessage() {}

func (x *P4HeaderTypeSpec_Member) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4HeaderTypeSpec_Member.ProtoReflect.Descriptor instead.
func (*P4HeaderTypeSpec_Member) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{11, 0}
}

func (x *P4HeaderTypeSpec_Member) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *P4HeaderTypeSpec_Member) GetTypeSpec() *P4BitstringLikeTypeSpec {
	if x != nil {
		return x.TypeSpec
	}
	return nil
}

type P4HeaderUnionTypeSpec_Member struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name   string       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Header *P4NamedType `protobuf:"bytes,2,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *P4HeaderUnionTypeSpec_Member) Reset() {
	*x = P4HeaderUnionTypeSpec_Member{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4HeaderUnionTypeSpec_Member) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4HeaderUnionTypeSpec_Member) ProtoMessage() {}

func (x *P4HeaderUnionTypeSpec_Member) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4HeaderUnionTypeSpec_Member.ProtoReflect.Descriptor instead.
func (*P4HeaderUnionTypeSpec_Member) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{12, 0}
}

func (x *P4HeaderUnionTypeSpec_Member) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *P4HeaderUnionTypeSpec_Member) GetHeader() *P4NamedType {
	if x != nil {
		return x.Header
	}
	return nil
}

type P4EnumTypeSpec_Member struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Annotations []string `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,4,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,3,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *P4EnumTypeSpec_Member) Reset() {
	*x = P4EnumTypeSpec_Member{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4EnumTypeSpec_Member) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4EnumTypeSpec_Member) ProtoMessage() {}

func (x *P4EnumTypeSpec_Member) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4EnumTypeSpec_Member.ProtoReflect.Descriptor instead.
func (*P4EnumTypeSpec_Member) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{21, 0}
}

func (x *P4EnumTypeSpec_Member) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *P4EnumTypeSpec_Member) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *P4EnumTypeSpec_Member) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *P4EnumTypeSpec_Member) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

type P4SerializableEnumTypeSpec_Member struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value       []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Annotations []string `protobuf:"bytes,3,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,5,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,4,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *P4SerializableEnumTypeSpec_Member) Reset() {
	*x = P4SerializableEnumTypeSpec_Member{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4SerializableEnumTypeSpec_Member) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4SerializableEnumTypeSpec_Member) ProtoMessage() {}

func (x *P4SerializableEnumTypeSpec_Member) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4SerializableEnumTypeSpec_Member.ProtoReflect.Descriptor instead.
func (*P4SerializableEnumTypeSpec_Member) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{22, 0}
}

func (x *P4SerializableEnumTypeSpec_Member) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *P4SerializableEnumTypeSpec_Member) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *P4SerializableEnumTypeSpec_Member) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *P4SerializableEnumTypeSpec_Member) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *P4SerializableEnumTypeSpec_Member) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

type P4NewTypeTranslation_SdnString struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *P4NewTypeTranslation_SdnString) Reset() {
	*x = P4NewTypeTranslation_SdnString{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4types_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4NewTypeTranslation_SdnString) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4NewTypeTranslation_SdnString) ProtoMessage() {}

func (x *P4NewTypeTranslation_SdnString) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4types_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4NewTypeTranslation_SdnString.ProtoReflect.Descriptor instead.
func (*P4NewTypeTranslation_SdnString) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4types_proto_rawDescGZIP(), []int{24, 0}
}

var File_p4_config_v1_p4types_proto protoreflect.FileDescriptor

var file_p4_config_v1_p4types_proto_rawDesc = []byte{
	0x0a, 0x1a, 0x70, 0x34, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x34, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x22, 0xb4, 0x08, 0x0a, 0x0a, 0x50,
	0x34, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3f, 0x0a, 0x07, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x54, 0x79, 0x70, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x07, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x54, 0x79, 0x70,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x4f, 0x0a, 0x0d, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x34, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x39, 0x0a, 0x05,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x54, 0x79, 0x70,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x05, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x12, 0x33, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x5e, 0x0a, 0x12,
	0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x45,
	0x6e, 0x75, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x73, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x12, 0x43, 0x0a, 0x09,
	0x6e, 0x65, 0x77, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x34, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4e, 0x65, 0x77, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6e, 0x65, 0x77, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x1a, 0x5a, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x34, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x5a, 0x0a,
	0x0c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x34, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x64, 0x0a, 0x11, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x39, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x34, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x56, 0x0a, 0x0a, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x32, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34,
	0x45, 0x6e, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6e, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x3e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x34, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65,
	0x45, 0x6e, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x58, 0x0a, 0x0d, 0x4e, 0x65, 0x77, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x31, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e, 0x65, 0x77, 0x54, 0x79,
	0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xff, 0x05, 0x0a, 0x0e, 0x50, 0x34, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x45, 0x0a, 0x09, 0x62, 0x69, 0x74, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x42, 0x69, 0x74, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x4c, 0x69, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00,
	0x52, 0x09, 0x62, 0x69, 0x74, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x2e, 0x0a, 0x04, 0x62,
	0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x42, 0x6f, 0x6f, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x04, 0x62, 0x6f, 0x6f, 0x6c, 0x12, 0x35, 0x0a, 0x05, 0x74,
	0x75, 0x70, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x54, 0x75, 0x70, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x05, 0x74, 0x75, 0x70,
	0x6c, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52,
	0x06, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0x33, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79,
	0x70, 0x65, 0x48, 0x00, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x3e, 0x0a, 0x0c,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52,
	0x0b, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0c,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x34, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x12, 0x58, 0x0a, 0x12, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x5f, 0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x34, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x10,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x12, 0x2f, 0x0a, 0x04, 0x65, 0x6e, 0x75, 0x6d, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34,
	0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x04, 0x65, 0x6e, 0x75,
	0x6d, 0x12, 0x31, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x34, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x48, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x75, 0x6d, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x10, 0x73, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x36,
	0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x07, 0x6e,
	0x65, 0x77, 0x54, 0x79, 0x70, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x22, 0x21, 0x0a, 0x0b, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x0c, 0x0a, 0x0a, 0x50, 0x34, 0x42, 0x6f, 0x6f, 0x6c,
	0x54, 0x79, 0x70, 0x65, 0x22, 0x0d, 0x0a, 0x0b, 0x50, 0x34, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x22, 0x90, 0x03, 0x0a, 0x17, 0x50, 0x34, 0x42, 0x69, 0x74, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x2f, 0x0a, 0x03, 0x62, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70,
	0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x42, 0x69,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x03, 0x62, 0x69, 0x74,
	0x12, 0x2f, 0x0a, 0x03, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x49,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x03, 0x69, 0x6e,
	0x74, 0x12, 0x38, 0x0a, 0x06, 0x76, 0x61, 0x72, 0x62, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x34, 0x56, 0x61, 0x72, 0x62, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x48, 0x00, 0x52, 0x06, 0x76, 0x61, 0x72, 0x62, 0x69, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a,
	0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59,
	0x0a, 0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0x2b, 0x0a, 0x0d, 0x50, 0x34, 0x42, 0x69, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x22, 0x2b, 0x0a, 0x0d, 0x50, 0x34, 0x49, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x22, 0x35, 0x0a, 0x10, 0x50, 0x34, 0x56, 0x61, 0x72, 0x62, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x69, 0x74, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x42,
	0x69, 0x74, 0x77, 0x69, 0x64, 0x74, 0x68, 0x22, 0x49, 0x0a, 0x0f, 0x50, 0x34, 0x54, 0x75, 0x70,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x36, 0x0a, 0x07, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x44, 0x61, 0x74,
	0x61, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x22, 0xfa, 0x02, 0x0a, 0x10, 0x50, 0x34, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3f, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52,
	0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x16, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x57, 0x0a, 0x06, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x22,
	0x83, 0x03, 0x0a, 0x10, 0x50, 0x34, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x3f, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x07, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x60, 0x0a, 0x06, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x42, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x42, 0x69, 0x74, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c,
	0x69, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x08, 0x74, 0x79, 0x70,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x22, 0xfc, 0x02, 0x0a, 0x15, 0x50, 0x34, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x44, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x34, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x07, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x4f, 0x0a, 0x06, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x31, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x22, 0x5e, 0x0a, 0x15, 0x50, 0x34, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x31, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e,
	0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04,
	0x73, 0x69, 0x7a, 0x65, 0x22, 0x6e, 0x0a, 0x1a, 0x50, 0x34, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x3c, 0x0a, 0x0c, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x75, 0x6e, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04,
	0x73, 0x69, 0x7a, 0x65, 0x22, 0x50, 0x0a, 0x0c, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x50, 0x61, 0x69, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x49, 0x0a, 0x10, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x08, 0x6b, 0x76,
	0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x70,
	0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x52, 0x07, 0x6b, 0x76, 0x50, 0x61, 0x69, 0x72,
	0x73, 0x22, 0x7e, 0x0a, 0x0a, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x62,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x4c, 0x0a, 0x0e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x86, 0x02, 0x0a, 0x14, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0f,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x0c, 0x6b, 0x76, 0x5f, 0x70, 0x61, 0x69, 0x72,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x6b,
	0x76, 0x50, 0x61, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x0f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x06, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x50, 0x0a, 0x0e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x69,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x22, 0x8a, 0x04, 0x0a, 0x0e, 0x50,
	0x34, 0x45, 0x6e, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3d, 0x0a,
	0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34,
	0x45, 0x6e, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x20, 0x0a, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f,
	0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70,
	0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x59, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xea, 0x01, 0x0a, 0x06, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x16,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70,
	0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xfe, 0x04, 0x0a, 0x1a, 0x50, 0x34, 0x53, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x54, 0x79,
	0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x44, 0x0a, 0x0f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x6c,
	0x79, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x34, 0x42, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x75, 0x6e,
	0x64, 0x65, 0x72, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x49, 0x0a, 0x07,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x53,
	0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x07,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x16, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x80, 0x02, 0x0a, 0x06, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a,
	0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x2b, 0x0a, 0x0f, 0x50, 0x34, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x18, 0x0a, 0x07, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0xb5, 0x01, 0x0a, 0x14, 0x50, 0x34, 0x4e, 0x65, 0x77, 0x54,
	0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x23, 0x0a, 0x0c, 0x73, 0x64, 0x6e, 0x5f, 0x62, 0x69, 0x74, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x64, 0x6e, 0x42, 0x69, 0x74,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x4d, 0x0a, 0x0a, 0x73, 0x64, 0x6e, 0x5f, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e, 0x65, 0x77, 0x54, 0x79,
	0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x64,
	0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x09, 0x73, 0x64, 0x6e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x1a, 0x0b, 0x0a, 0x09, 0x53, 0x64, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x42, 0x0a, 0x0a, 0x08, 0x73, 0x64, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x83, 0x03,
	0x0a, 0x0d, 0x50, 0x34, 0x4e, 0x65, 0x77, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x43, 0x0a, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0c, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e,
	0x65, 0x77, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x42, 0x10, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x2d, 0x5a, 0x2b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x70, 0x34, 0x6c, 0x61, 0x6e, 0x67, 0x2f, 0x70, 0x34, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x34, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_p4_config_v1_p4types_proto_rawDescOnce sync.Once
	file_p4_config_v1_p4types_proto_rawDescData = file_p4_config_v1_p4types_proto_rawDesc
)

func file_p4_config_v1_p4types_proto_rawDescGZIP() []byte {
	file_p4_config_v1_p4types_proto_rawDescOnce.Do(func() {
		file_p4_config_v1_p4types_proto_rawDescData = protoimpl.X.CompressGZIP(file_p4_config_v1_p4types_proto_rawDescData)
	})
	return file_p4_config_v1_p4types_proto_rawDescData
}

var file_p4_config_v1_p4types_proto_msgTypes = make([]protoimpl.MessageInfo, 38)
var file_p4_config_v1_p4types_proto_goTypes = []interface{}{
	(*P4TypeInfo)(nil),                        // 0: p4.config.v1.P4TypeInfo
	(*P4DataTypeSpec)(nil),                    // 1: p4.config.v1.P4DataTypeSpec
	(*P4NamedType)(nil),                       // 2: p4.config.v1.P4NamedType
	(*P4BoolType)(nil),                        // 3: p4.config.v1.P4BoolType
	(*P4ErrorType)(nil),                       // 4: p4.config.v1.P4ErrorType
	(*P4BitstringLikeTypeSpec)(nil),           // 5: p4.config.v1.P4BitstringLikeTypeSpec
	(*P4BitTypeSpec)(nil),                     // 6: p4.config.v1.P4BitTypeSpec
	(*P4IntTypeSpec)(nil),                     // 7: p4.config.v1.P4IntTypeSpec
	(*P4VarbitTypeSpec)(nil),                  // 8: p4.config.v1.P4VarbitTypeSpec
	(*P4TupleTypeSpec)(nil),                   // 9: p4.config.v1.P4TupleTypeSpec
	(*P4StructTypeSpec)(nil),                  // 10: p4.config.v1.P4StructTypeSpec
	(*P4HeaderTypeSpec)(nil),                  // 11: p4.config.v1.P4HeaderTypeSpec
	(*P4HeaderUnionTypeSpec)(nil),             // 12: p4.config.v1.P4HeaderUnionTypeSpec
	(*P4HeaderStackTypeSpec)(nil),             // 13: p4.config.v1.P4HeaderStackTypeSpec
	(*P4HeaderUnionStackTypeSpec)(nil),        // 14: p4.config.v1.P4HeaderUnionStackTypeSpec
	(*KeyValuePair)(nil),                      // 15: p4.config.v1.KeyValuePair
	(*KeyValuePairList)(nil),                  // 16: p4.config.v1.KeyValuePairList
	(*Expression)(nil),                        // 17: p4.config.v1.Expression
	(*ExpressionList)(nil),                    // 18: p4.config.v1.ExpressionList
	(*StructuredAnnotation)(nil),              // 19: p4.config.v1.StructuredAnnotation
	(*SourceLocation)(nil),                    // 20: p4.config.v1.SourceLocation
	(*P4EnumTypeSpec)(nil),                    // 21: p4.config.v1.P4EnumTypeSpec
	(*P4SerializableEnumTypeSpec)(nil),        // 22: p4.config.v1.P4SerializableEnumTypeSpec
	(*P4ErrorTypeSpec)(nil),                   // 23: p4.config.v1.P4ErrorTypeSpec
	(*P4NewTypeTranslation)(nil),              // 24: p4.config.v1.P4NewTypeTranslation
	(*P4NewTypeSpec)(nil),                     // 25: p4.config.v1.P4NewTypeSpec
	nil,                                       // 26: p4.config.v1.P4TypeInfo.StructsEntry
	nil,                                       // 27: p4.config.v1.P4TypeInfo.HeadersEntry
	nil,                                       // 28: p4.config.v1.P4TypeInfo.HeaderUnionsEntry
	nil,                                       // 29: p4.config.v1.P4TypeInfo.EnumsEntry
	nil,                                       // 30: p4.config.v1.P4TypeInfo.SerializableEnumsEntry
	nil,                                       // 31: p4.config.v1.P4TypeInfo.NewTypesEntry
	(*P4StructTypeSpec_Member)(nil),           // 32: p4.config.v1.P4StructTypeSpec.Member
	(*P4HeaderTypeSpec_Member)(nil),           // 33: p4.config.v1.P4HeaderTypeSpec.Member
	(*P4HeaderUnionTypeSpec_Member)(nil),      // 34: p4.config.v1.P4HeaderUnionTypeSpec.Member
	(*P4EnumTypeSpec_Member)(nil),             // 35: p4.config.v1.P4EnumTypeSpec.Member
	(*P4SerializableEnumTypeSpec_Member)(nil), // 36: p4.config.v1.P4SerializableEnumTypeSpec.Member
	(*P4NewTypeTranslation_SdnString)(nil),    // 37: p4.config.v1.P4NewTypeTranslation.SdnString
}
var file_p4_config_v1_p4types_proto_depIdxs = []int32{
	26, // 0: p4.config.v1.P4TypeInfo.structs:type_name -> p4.config.v1.P4TypeInfo.StructsEntry
	27, // 1: p4.config.v1.P4TypeInfo.headers:type_name -> p4.config.v1.P4TypeInfo.HeadersEntry
	28, // 2: p4.config.v1.P4TypeInfo.header_unions:type_name -> p4.config.v1.P4TypeInfo.HeaderUnionsEntry
	29, // 3: p4.config.v1.P4TypeInfo.enums:type_name -> p4.config.v1.P4TypeInfo.EnumsEntry
	23, // 4: p4.config.v1.P4TypeInfo.error:type_name -> p4.config.v1.P4ErrorTypeSpec
	30, // 5: p4.config.v1.P4TypeInfo.serializable_enums:type_name -> p4.config.v1.P4TypeInfo.SerializableEnumsEntry
	31, // 6: p4.config.v1.P4TypeInfo.new_types:type_name -> p4.config.v1.P4TypeInfo.NewTypesEntry
	5,  // 7: p4.config.v1.P4DataTypeSpec.bitstring:type_name -> p4.config.v1.P4BitstringLikeTypeSpec
	3,  // 8: p4.config.v1.P4DataTypeSpec.bool:type_name -> p4.config.v1.P4BoolType
	9,  // 9: p4.config.v1.P4DataTypeSpec.tuple:type_name -> p4.config.v1.P4TupleTypeSpec
	2,  // 10: p4.config.v1.P4DataTypeSpec.struct:type_name -> p4.config.v1.P4NamedType
	2,  // 11: p4.config.v1.P4DataTypeSpec.header:type_name -> p4.config.v1.P4NamedType
	2,  // 12: p4.config.v1.P4DataTypeSpec.header_union:type_name -> p4.config.v1.P4NamedType
	13, // 13: p4.config.v1.P4DataTypeSpec.header_stack:type_name -> p4.config.v1.P4HeaderStackTypeSpec
	14, // 14: p4.config.v1.P4DataTypeSpec.header_union_stack:type_name -> p4.config.v1.P4HeaderUnionStackTypeSpec
	2,  // 15: p4.config.v1.P4DataTypeSpec.enum:type_name -> p4.config.v1.P4NamedType
	4,  // 16: p4.config.v1.P4DataTypeSpec.error:type_name -> p4.config.v1.P4ErrorType
	2,  // 17: p4.config.v1.P4DataTypeSpec.serializable_enum:type_name -> p4.config.v1.P4NamedType
	2,  // 18: p4.config.v1.P4DataTypeSpec.new_type:type_name -> p4.config.v1.P4NamedType
	6,  // 19: p4.config.v1.P4BitstringLikeTypeSpec.bit:type_name -> p4.config.v1.P4BitTypeSpec
	7,  // 20: p4.config.v1.P4BitstringLikeTypeSpec.int:type_name -> p4.config.v1.P4IntTypeSpec
	8,  // 21: p4.config.v1.P4BitstringLikeTypeSpec.varbit:type_name -> p4.config.v1.P4VarbitTypeSpec
	20, // 22: p4.config.v1.P4BitstringLikeTypeSpec.annotation_locations:type_name -> p4.config.v1.SourceLocation
	19, // 23: p4.config.v1.P4BitstringLikeTypeSpec.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	1,  // 24: p4.config.v1.P4TupleTypeSpec.members:type_name -> p4.config.v1.P4DataTypeSpec
	32, // 25: p4.config.v1.P4StructTypeSpec.members:type_name -> p4.config.v1.P4StructTypeSpec.Member
	20, // 26: p4.config.v1.P4StructTypeSpec.annotation_locations:type_name -> p4.config.v1.SourceLocation
	19, // 27: p4.config.v1.P4StructTypeSpec.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	33, // 28: p4.config.v1.P4HeaderTypeSpec.members:type_name -> p4.config.v1.P4HeaderTypeSpec.Member
	20, // 29: p4.config.v1.P4HeaderTypeSpec.annotation_locations:type_name -> p4.config.v1.SourceLocation
	19, // 30: p4.config.v1.P4HeaderTypeSpec.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	34, // 31: p4.config.v1.P4HeaderUnionTypeSpec.members:type_name -> p4.config.v1.P4HeaderUnionTypeSpec.Member
	20, // 32: p4.config.v1.P4HeaderUnionTypeSpec.annotation_locations:type_name -> p4.config.v1.SourceLocation
	19, // 33: p4.config.v1.P4HeaderUnionTypeSpec.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	2,  // 34: p4.config.v1.P4HeaderStackTypeSpec.header:type_name -> p4.config.v1.P4NamedType
	2,  // 35: p4.config.v1.P4HeaderUnionStackTypeSpec.header_union:type_name -> p4.config.v1.P4NamedType
	17, // 36: p4.config.v1.KeyValuePair.value:type_name -> p4.config.v1.Expression
	15, // 37: p4.config.v1.KeyValuePairList.kv_pairs:type_name -> p4.config.v1.KeyValuePair
	17, // 38: p4.config.v1.ExpressionList.expressions:type_name -> p4.config.v1.Expression
	18, // 39: p4.config.v1.StructuredAnnotation.expression_list:type_name -> p4.config.v1.ExpressionList
	16, // 40: p4.config.v1.StructuredAnnotation.kv_pair_list:type_name -> p4.config.v1.KeyValuePairList
	20, // 41: p4.config.v1.StructuredAnnotation.source_location:type_name -> p4.config.v1.SourceLocation
	35, // 42: p4.config.v1.P4EnumTypeSpec.members:type_name -> p4.config.v1.P4EnumTypeSpec.Member
	20, // 43: p4.config.v1.P4EnumTypeSpec.annotation_locations:type_name -> p4.config.v1.SourceLocation
	19, // 44: p4.config.v1.P4EnumTypeSpec.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	6,  // 45: p4.config.v1.P4SerializableEnumTypeSpec.underlying_type:type_name -> p4.config.v1.P4BitTypeSpec
	36, // 46: p4.config.v1.P4SerializableEnumTypeSpec.members:type_name -> p4.config.v1.P4SerializableEnumTypeSpec.Member
	20, // 47: p4.config.v1.P4SerializableEnumTypeSpec.annotation_locations:type_name -> p4.config.v1.SourceLocation
	19, // 48: p4.config.v1.P4SerializableEnumTypeSpec.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	37, // 49: p4.config.v1.P4NewTypeTranslation.sdn_string:type_name -> p4.config.v1.P4NewTypeTranslation.SdnString
	1,  // 50: p4.config.v1.P4NewTypeSpec.original_type:type_name -> p4.config.v1.P4DataTypeSpec
	24, // 51: p4.config.v1.P4NewTypeSpec.translated_type:type_name -> p4.config.v1.P4NewTypeTranslation
	20, // 52: p4.config.v1.P4NewTypeSpec.annotation_locations:type_name -> p4.config.v1.SourceLocation
	19, // 53: p4.config.v1.P4NewTypeSpec.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	10, // 54: p4.config.v1.P4TypeInfo.StructsEntry.value:type_name -> p4.config.v1.P4StructTypeSpec
	11, // 55: p4.config.v1.P4TypeInfo.HeadersEntry.value:type_name -> p4.config.v1.P4HeaderTypeSpec
	12, // 56: p4.config.v1.P4TypeInfo.HeaderUnionsEntry.value:type_name -> p4.config.v1.P4HeaderUnionTypeSpec
	21, // 57: p4.config.v1.P4TypeInfo.EnumsEntry.value:type_name -> p4.config.v1.P4EnumTypeSpec
	22, // 58: p4.config.v1.P4TypeInfo.SerializableEnumsEntry.value:type_name -> p4.config.v1.P4SerializableEnumTypeSpec
	25, // 59: p4.config.v1.P4TypeInfo.NewTypesEntry.value:type_name -> p4.config.v1.P4NewTypeSpec
	1,  // 60: p4.config.v1.P4StructTypeSpec.Member.type_spec:type_name -> p4.config.v1.P4DataTypeSpec
	5,  // 61: p4.config.v1.P4HeaderTypeSpec.Member.type_spec:type_name -> p4.config.v1.P4BitstringLikeTypeSpec
	2,  // 62: p4.config.v1.P4HeaderUnionTypeSpec.Member.header:type_name -> p4.config.v1.P4NamedType
	20, // 63: p4.config.v1.P4EnumTypeSpec.Member.annotation_locations:type_name -> p4.config.v1.SourceLocation
	19, // 64: p4.config.v1.P4EnumTypeSpec.Member.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	20, // 65: p4.config.v1.P4SerializableEnumTypeSpec.Member.annotation_locations:type_name -> p4.config.v1.SourceLocation
	19, // 66: p4.config.v1.P4SerializableEnumTypeSpec.Member.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	67, // [67:67] is the sub-list for method output_type
	67, // [67:67] is the sub-list for method input_type
	67, // [67:67] is the sub-list for extension type_name
	67, // [67:67] is the sub-list for extension extendee
	0,  // [0:67] is the sub-list for field type_name
}

func init() { file_p4_config_v1_p4types_proto_init() }
func file_p4_config_v1_p4types_proto_init() {
	if File_p4_config_v1_p4types_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_p4_config_v1_p4types_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4TypeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4DataTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4NamedType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4BoolType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4ErrorType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4BitstringLikeTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4BitTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4IntTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4VarbitTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4TupleTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4StructTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4HeaderTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4HeaderUnionTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4HeaderStackTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4HeaderUnionStackTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyValuePair); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyValuePairList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExpressionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4EnumTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4SerializableEnumTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4ErrorTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4NewTypeTranslation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4NewTypeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4StructTypeSpec_Member); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4HeaderTypeSpec_Member); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4HeaderUnionTypeSpec_Member); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4EnumTypeSpec_Member); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4SerializableEnumTypeSpec_Member); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4types_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4NewTypeTranslation_SdnString); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_p4_config_v1_p4types_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*P4DataTypeSpec_Bitstring)(nil),
		(*P4DataTypeSpec_Bool)(nil),
		(*P4DataTypeSpec_Tuple)(nil),
		(*P4DataTypeSpec_Struct)(nil),
		(*P4DataTypeSpec_Header)(nil),
		(*P4DataTypeSpec_HeaderUnion)(nil),
		(*P4DataTypeSpec_HeaderStack)(nil),
		(*P4DataTypeSpec_HeaderUnionStack)(nil),
		(*P4DataTypeSpec_Enum)(nil),
		(*P4DataTypeSpec_Error)(nil),
		(*P4DataTypeSpec_SerializableEnum)(nil),
		(*P4DataTypeSpec_NewType)(nil),
	}
	file_p4_config_v1_p4types_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*P4BitstringLikeTypeSpec_Bit)(nil),
		(*P4BitstringLikeTypeSpec_Int)(nil),
		(*P4BitstringLikeTypeSpec_Varbit)(nil),
	}
	file_p4_config_v1_p4types_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*Expression_StringValue)(nil),
		(*Expression_Int64Value)(nil),
		(*Expression_BoolValue)(nil),
	}
	file_p4_config_v1_p4types_proto_msgTypes[19].OneofWrappers = []interface{}{
		(*StructuredAnnotation_ExpressionList)(nil),
		(*StructuredAnnotation_KvPairList)(nil),
	}
	file_p4_config_v1_p4types_proto_msgTypes[24].OneofWrappers = []interface{}{
		(*P4NewTypeTranslation_SdnBitwidth)(nil),
		(*P4NewTypeTranslation_SdnString_)(nil),
	}
	file_p4_config_v1_p4types_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*P4NewTypeSpec_OriginalType)(nil),
		(*P4NewTypeSpec_TranslatedType)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_p4_config_v1_p4types_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   38,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_p4_config_v1_p4types_proto_goTypes,
		DependencyIndexes: file_p4_config_v1_p4types_proto_depIdxs,
		MessageInfos:      file_p4_config_v1_p4types_proto_msgTypes,
	}.Build()
	File_p4_config_v1_p4types_proto = out.File
	file_p4_config_v1_p4types_proto_rawDesc = nil
	file_p4_config_v1_p4types_proto_goTypes = nil
	file_p4_config_v1_p4types_proto_depIdxs = nil
}
